<?php get_header(); ?>

<div id="main" class="archive-portfolio <?php echo leap_main_col_class(); ?>">

    <?php
    // Content top widget position
    get_template_part( 'includes/sidebar/content-top' );
    ?>

    <div class="content-section">

        <?php if ( have_posts() ) { ?>
            <div class="archive-info">
                <?php
                $category_id            = get_queried_object()->term_id;
                $category_page_settings = ot_get_option( 'portfolio_category_page_settings', array() );
                if ( in_array( 'portfolio_category_rss', $category_page_settings ) ) {
                    ?>
                    <div class="archive-rss"><a title="<?php esc_html_e( 'Feed Subscription', 'wiz' ); ?>" href="<?php echo get_term_feed_link( $category_id, 'leap-portfolio-category' ) ?>"><i class="fa fa-rss-square fa-lg"></i></a></div>
                <?php } ?>
                <?php
                $leap_portfolio_cat_image = get_term_meta( $category_id, 'leap_portfolio_cat_image', true );
                if ( in_array( 'portfolio_category_image', $category_page_settings ) && !empty( $leap_portfolio_cat_image ) ) {
                    $cat_image_attributes = wp_get_attachment_image_src( $leap_portfolio_cat_image[ 'id' ], 'large' );
                    ?>
                    <div class="archive-image"><a data-rel="prettyPhoto" href="<?php echo $cat_image_attributes[ 0 ]; ?>"  title="<?php echo single_cat_title( '', false ); ?>"><?php echo wp_get_attachment_image( $leap_portfolio_cat_image[ 'id' ], 'leap-portfolio-1col' ); ?></a></div>

                <?php } ?>

                <?php
                $category_description = category_description();
                if ( in_array( 'portfolio_category_desc', $category_page_settings ) && !empty( $category_description ) ) {
                    echo '<div class="archive-description">' . $category_description . '</div>';
                }
                ?>
            </div>
        <?php } ?>

        <div class="portfolio-wrapper">

            <?php
            $portfolio_as_catalog = ot_get_option( 'portfolio_as_catalog', 'off' );
            $catalog_columns      = ot_get_option( 'catalog_columns', 3 );
            $col_num              = 12 / $catalog_columns;
            $current_term         = get_queried_object()->term_id;
            $args                 = array(
                'hide_empty' => false,
                'parent'     => $current_term
            );
            $portfolio_terms      = get_terms( 'leap-portfolio-category', $args );
            if ( $portfolio_terms && ($portfolio_as_catalog == 'on') ) {
                echo '<div class="portfolio-catalog">';
                echo '<div class="row">';
                $i = 1;
                foreach ( $portfolio_terms as $term ) {
                    ?>
                    <div class="<?php echo leap_bws_col_class( $col_num ); ?>">
                        <div class="entry-wrapper">
                            <?php
                            $leap_portfolio_cat_image = get_term_meta( $term->term_id, 'leap_portfolio_cat_image', true );
                            if ( $leap_portfolio_cat_image ) {
                                ?>
                                <a href="<?php echo get_term_link( $term ); ?>" title="<?php echo $term->name; ?>"><?php echo wp_get_attachment_image( $leap_portfolio_cat_image[ 'id' ], 'leap-portfolio-1col' ); ?></a>
                            <?php } ?>
                            <h2 class="entry-title"><a href="<?php echo get_term_link( $term ); ?>"><?php echo $term->name; ?></a></h2>
                            <?php if ( $term->description ) { ?>
                                <div class="post-content"><?php echo do_shortcode( $term->description ); ?></div>
                            <?php } ?>
                        </div>
                    </div>
                    <?php
                    if ( $i % $catalog_columns == 0 ) {
                        echo '</div><div class="row">';
                    }
                    $i++;
                }
                echo '</div>';
                echo '</div>';
            }
            ?>


            <?php
            if ( !$portfolio_terms ) {
                $portfolio_as_catalog = 'off';
            }

            if ( $portfolio_as_catalog != 'on' ) {
                if ( have_posts() ) {
                    $layout = ot_get_option( 'portfolio_archive_layout', 'medium' );
                    ?>
                    <div class="entry-layout portfolio-<?php echo $layout; ?>">

                        <?php
                        while ( have_posts() ): the_post();
                            $item_classes = array();
                            $item_cats    = get_the_terms( get_the_ID(), 'leap-portfolio-category' );
                            if ( $item_cats ) {
                                foreach ( $item_cats as $item_cat ) {
                                    $item_classes[] = $item_cat->slug;
                                }
                            }
                            ?>

                            <div id="post-<?php the_ID(); ?>" <?php post_class( $item_classes ); ?>>


                                <div class="entry-wrapper">
                                    <?php
                                    $large_image_url       = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'large' );
                                    $project_link          = get_post_meta( get_the_ID(), 'project_link', true );
                                    $leap_project_url      = (isset( $project_link[ 'url' ] )) ? esc_url( $project_link[ 'url' ] ) : '';
                                    $leap_project_url_text = (isset( $project_link[ 'text' ] )) ? esc_html( $project_link[ 'text' ] ) : '';
                                    if ( empty( $leap_project_url_text ) ) {
                                        $leap_project_url_text = __( "Visit Project", "wiz" );
                                    }
                                    ?>
                                    <div class="entry-header">
                                        <div class="entry-head">				
                                            <div class="entry-img">
                                                <div class="leap-overlay item-img">
                                                    <?php echo get_the_post_thumbnail( get_the_ID(), "leap-portfolio-" . $layout ); ?>
                                                    <div class="item-overlay">
                                                        <div class="item-img-color"></div>
                                                        <div class="item-details">
                                                            <div class="item-links">
                                                                <a class="item-link" href="<?php the_permalink() ?>" title="<?php the_title_attribute(); ?>"><?php esc_html_e( 'Link', 'wiz' ) ?></a>
                                                                <a class="enlarge" data-rel="prettyPhoto" href="<?php echo $large_image_url[ 0 ]; ?>" title="<?php the_title_attribute(); ?>">
                                                                    <?php echo __( 'Enlarge', 'wiz' ); ?>
                                                                </a>
                                                            </div>

                                                            <h4 class="item-title"><a href="<?php the_permalink() ?>" title="<?php the_title_attribute(); ?>" ><?php the_title(); ?></a></h4>

                                                            <p class="item-category"><?php echo get_the_term_list( get_the_ID(), 'leap-portfolio-category', '', ', ', '' ); ?></p>
                                                        </div>
                                                    </div>

                                                </div>
                                            </div>
                                        </div>


                                        <div class="entry-info">
                                            <h2 class="entry-title"><a href="<?php the_permalink() ?>" title="<?php the_title_attribute(); ?>" ><?php the_title(); ?></a></h2>

                                            <div class="entry-meta">
                                                <small class="entry-category small"><i class="fa fa-align-left"></i> <?php echo get_the_term_list( get_the_ID(), 'leap-portfolio-category', '', ', ', '' ); ?></small>
                                            </div>
                                        </div>

                                    </div>

                                    <div class="entry-content">
                                        <div class="post-content">
                                            <?php
                                            if ( ot_get_option( 'portfolio_archive_display_format' ) == 'excerpt' ) {
                                                the_excerpt();
                                            } else {
                                                the_content( '<span>' . __( 'Read More', 'wiz' ) . '</span>' );
                                                wp_link_pages( array(
                                                    'before'         => '<div class="pagination pagination-page"><strong>' . esc_html__( 'Pages', 'wiz' ) . ':</strong><ul class="clearfix">',
                                                    'after'          => '</ul></div>',
                                                    'next_or_number' => 'number',
                                                    'link_before'    => '<span>',
                                                    'link_after'     => '</span>'
                                                ) );
                                            }
                                            ?>
                                        </div>
                                    </div>

                                    <div class="entry-footer">
                                        <div class="portfolio-buttons">
                                            <a class="project-more btn btn-default btn-leap" href="<?php the_permalink() ?>" title="<?php the_title_attribute(); ?>" ><?php echo __( "Read More", "wiz" ); ?></a>

                                            <?php if ( !empty( $project_link[ 'url' ] ) ) { ?>
                                                <a class="project-url btn btn-default btn-leap" href="<?php echo $leap_project_url; ?>"><?php echo $leap_project_url_text; ?></a>
                                            <?php } ?>
                                        </div>
                                    </div>
                                    <div class="portfolio-sep"></div>
                                </div>
                            </div>
                        <?php endwhile; ?>
                    </div>

                    <?php leap_page_navi(); ?>
                    <?php
                } else {
                    get_template_part( 'includes/content/none' );
                }
            }
            ?>


        </div>
    </div>

    <?php
    // Content bottom widget position
    get_template_part( 'includes/sidebar/content-bottom' );
    ?>



</div> <!-- end #main -->
<?php get_footer(); ?>