<?php get_header(); ?>

<div id="main" class="<?php echo leap_main_col_class(); ?>">

	<?php
	// Content top widget position
	get_template_part( 'includes/sidebar/content-top' );
	?>

	<div class="content-section">

		<div id="post-not-found">

			<div class="post-not-found-head">
				<h1><?php esc_html_e( '404', 'wiz' ) ?><i class="fa fa-file"></i></h1>
				<p><?php esc_html_e( 'Oops, This page could not be found!', 'wiz' ) ?></p>
			</div>

			<div class="post-content">
				<div class="row">
					<div class="<?php echo leap_bws_col_class( 6 ); ?>">
						<div class="title">
							<h4><?php esc_html_e( 'Here are some useful links:', 'wiz' ) ?></h4>
							<div class="title-sep-container">
								<div class="title-sep"></div>
							</div>
						</div>
						<div class="useful-links">
							<?php
							$not_found_menu		 = leap_get_assigned_menu_on_theme_location( '404-menu' );
							$not_found_menu_obj	 = wp_get_nav_menu_object( $not_found_menu );

							if ( !empty( $not_found_menu_obj ) && $not_found_menu_obj->count > 0 ) {
								wp_nav_menu( array(
									'theme_location' => '404-menu',
									'menu'			 => $not_found_menu,
									'fallback_cb'	 => false
								) );
							}
							?>

						</div>
					</div>

					<div class="<?php echo leap_bws_col_class( 6 ); ?>">
						<div class="title">
							<h4><?php esc_html_e( 'What you are looking for?', 'wiz' ) ?></h4>

							<div class="title-sep-container">
								<div class="title-sep"></div>
							</div>
						</div>
						<p><?php esc_html_e( 'Sorry, What you are looking for is not available. Maybe you want to perform a search?', 'wiz' ) ?></p>
						<div class="useful-links">
							<?php get_search_form(); ?>
						</div>
					</div>
				</div>
			</div>

		</div>


	</div>
	<?php
	// Content bottom widget position
	get_template_part( 'includes/sidebar/content-bottom' );
	?>



</div> <!-- end #main -->
<?php get_footer(); ?>