<?php

/*
 * Plugin Name: Leap Port
 * Plugin URI: http://www.leap13.com
 * Description: LeapPort Plugin for Leap13 Themes
 * Version: 1.13.5
 * Author: Leap13
 * Author URI: http://www.leap13.com
 * Text Domain: leap-port
 */

define( 'LEAP_PORT_VERSION', '1.13.5' );
define( 'LEAP_PORT_DIR', trailingslashit( dirname( __FILE__ ) ) );
define( 'LEAP_PORT_URI', plugins_url( '', __FILE__ ) );

function leap_port_load_plugin_textdomain() {

    $domain = 'leap-port';
    $locale = apply_filters( 'plugin_locale', get_locale(), $domain );

    if ( $loaded = load_textdomain( $domain, trailingslashit( WP_LANG_DIR ) . $domain . '/' . $domain . '-' . $locale . '.mo' ) ) {
        return $loaded;
    } else {
        load_plugin_textdomain( $domain, FALSE, 'leap-port/languages/' );
    }
}

add_action( 'init', 'leap_port_load_plugin_textdomain' );


if ( function_exists( 'add_theme_support' ) ) {
    add_image_size( 'leap-image-100x100', 100, 100, true );
}

require_once LEAP_PORT_DIR . 'portfolio/portfolio.php';
require_once LEAP_PORT_DIR . 'shortcodes/shortcodes.php';
