<?php
define( 'JS_PATH', LEAP_PORT_URI . '/shortcodes/customcodes.js' );


// Enable font size & font family selects in the editor
if ( !function_exists( 'leap_font_family_size' ) ) {

    function leap_font_family_size( $buttons ) {
        array_unshift( $buttons, 'fontselect' ); // Add Font Select
        array_unshift( $buttons, 'fontsizeselect' ); // Add Font Size Select
        return $buttons;
    }

}
add_filter( 'mce_buttons_2', 'leap_font_family_size' );

if ( !function_exists( 'leap_strip_shortcode' ) ) {
    /**
    * @param string $code name of the shortcode
    * @param string $content
    * @return string content with shortcode striped
    */
   function leap_strip_shortcode($code, $content)
   {
       global $shortcode_tags;

       $stack = $shortcode_tags;
       $shortcode_tags = array($code => 1);

       $content = strip_shortcodes($content);

       $shortcode_tags = $stack;
       return $content;
   }
}

if ( !function_exists( 'leap_get_the_content' ) ) {

    /**
     * 
     * @param type $id
     * @return type
     */
    function leap_get_the_content( $id = null ) {

        if ( !$id ) {
            $id = get_the_ID();
        }

        $post    = get_post( $id );
        
        $content = leap_strip_shortcode('vc_posts_slider', $post->post_content);
        
        $content = apply_filters( 'the_content', $content );
        
        $content = str_replace( ']]>', ']]&gt;', $content );

        return $content;
    }

}

if ( !function_exists( 'leap_get_the_excerpt' ) ) {

    /**
     * 
     * @param type $id
     * @param type $wordsreturned
     * @return string
     */
    function leap_get_the_excerpt( $id = null, $wordsreturned = null ) {
        
        if ( has_excerpt() ) {
            return get_the_excerpt();
        }

        $content = wp_strip_all_tags( leap_get_the_content( $id ), true );

        if ( !$wordsreturned ) {
            $wordsreturned = apply_filters( 'excerpt_length', 55 );
        }

        $retval = $content;  //  Just in case of a problem
        $array  = explode( " ", $content );
        /*  Already short enough, return the whole thing */
        if ( count( $array ) <= $wordsreturned ) {
            $retval = $content;
        } else { /*  Need to chop of some words */

            $excerpt_more = apply_filters( 'excerpt_more', ' ' . '[&hellip;]' );

            array_splice( $array, $wordsreturned );
            $retval = implode( " ", $array ) . $excerpt_more;
        }
        return $retval;
    }

}

/*
 * 	Re-usable RSS feed reader with shortcode
 */
if ( !function_exists( 'base_rss_feed' ) ) {

    function base_rss_feed( $size = 5,
                            $feed = 'http://wordpress.org/news/feed/',
                            $date = 'no', $cache_time = 1800 ) {
        // Include SimplePie RSS parsing engine
        include_once ABSPATH . WPINC . '/feed.php';

        // Set the cache time for SimplePie
        add_filter( 'wp_feed_cache_transient_lifetime', create_function( '$a', "return $cache_time;" ) );

        // Build the SimplePie object
        $rss = fetch_feed( $feed );

        // Check for errors in the RSS XML
        if ( !is_wp_error( $rss ) ) {

            // Set a limit for the number of items to parse
            $maxitems  = $rss->get_item_quantity( $size );
            $rss_items = $rss->get_items( 0, $maxitems );

            // Store the total number of items found in the feed
            $i             = 0;
            $total_entries = count( $rss_items );

            // Output HTML
            $html = "<ul class='feedlist'>";
            foreach ( $rss_items as $item ) {
                $i++;

                // Add a class of "last" to the last item in the list
                if ( $total_entries == $i ) {
                    $last = " class='last'";
                } else {
                    $last = "";
                }

                // Store the data we need from the feed
                $title       = $item->get_title();
                $link        = $item->get_permalink();
                //$desc = $item->get_description();
                $date_posted = $item->get_date( 'F j, Y' );

                // Output
                $html .= "<li id='post-$i'$last>";
                $html .= '<a href="' . esc_url( $link ) . '" target="_blank">' . esc_html( $title ) . '</a>';
                if ( $date == 'yes' )
                    $html .= "<small class='small'>$date_posted</small>";
                //$html .= "<div class='rss-entry'>$desc</div>";
                $html .= "</li>";
            }
            $html .= "</ul>";
        } else {

            $html = "An error occurred while parsing your RSS feed. Check that it's a valid XML file.";
        }

        return $html;
    }

}


if( !function_exists('leap_all_font_families') ) {
    /**
    * Get all fonts list
    * @param string $field_id
    * @return array
    */
   function leap_all_font_families( $field_id = '' ) {
       return apply_filters( 'ot_recognized_font_families', array(
           ''           => 'Default',
           'arial'     => 'Arial',
           'georgia'   => 'Georgia',
           'helvetica' => 'Helvetica',
           'palatino'  => 'Palatino',
           'tahoma'    => 'Tahoma',
           'times'     => '"Times New Roman", sans-serif',
           'trebuchet' => 'Trebuchet',
           'verdana'   => 'Verdana'
       ), $field_id );
   }
}

function leap_get_font_family($font_key) {
    $families = leap_all_font_families();
    if( !empty($families[$font_key]) ) {
        return $families[$font_key];
    }
    return $font_key;
}

//////////////////////////////////////////////////////////////////
// Remove extra P tags
//////////////////////////////////////////////////////////////////
function leap_shortcodes_formatter( $content ) {
    $block = join( "|", array( "leap_video", "leap_soundcloud", "leap_button", "leap_highlight", "leap_quote", "leap_icon_box", "leap_ul", "leap_li", "leap_tagline_box", "leap_one_half", "leap_one_third", "leap_two_third", "leap_one_fourth", "leap_three_fourth", "leap_toggle", "leap_accordion", "leap_accordion_item", "leap_recentposts", "leap_iframe", "leap_lightbox", "leap_title", "leap_tabs", "leap_tab", "leap_tabs_container", "leap_tabs_head", "leap_tab_title", "leap_qr", "leap_separator", "leap_checklist", "leap_tooltip", "leap_testimonials", "leap_testimonial", "leap_progress_bar", "leap_alert_box", "leap_fontawesome", "leap_person", "leap_flickr", "leap_rss", "leap_clients", "leap_client", "leap_pricing_table", "leap_pricing_column", "leap_pricing_price", "leap_pricing_row", "leap_pricing_footer", "leap_fullwidth", "leap_blog", "leap_gap", "leap_image" ) );

    // opening tag
    $rep = preg_replace( "/(<p>)?\[($block)(\s[^\]]+)?\](<\/p>|<br \/>)?/", "[$2$3]", $content );

    // closing tag
    $rep = preg_replace( "/(<p>)?\[\/($block)](<\/p>|<br \/>)/", "[/$2]", $rep );

    return $rep;
}

//add_filter( 'the_content', 'leap_shortcodes_formatter' );
//add_filter( 'widget_text', 'leap_shortcodes_formatter' );
//////////////////////////////////////////////////////////////////
// Video shortcode
//////////////////////////////////////////////////////////////////
function leap_shortcode_video( $atts, $content = null ) {
    extract( shortcode_atts(
    array(
        'video_type' => 'youtube',
        'video_id'   => '',
        'width'      => 550,
        'height'     => 300
    ), $atts ) );

    if ( $video_type == 'youtube' ) {
        return '<iframe src="http://www.youtube.com/embed/' . urlencode( $video_id ) . '?rel=0" style="width:' . esc_attr( $width ) . '; height:' . esc_attr( $height ) . '; border:none;overflow:hidden;"></iframe>';
    } elseif ( $video_type == 'vimeo' ) {
        return '<iframe src="http://player.vimeo.com/video/' . urlencode( $video_id ) . '" style="width:' . esc_attr( $width ) . '; height:' . esc_attr( $height ) . '; border:none;overflow:hidden;"></iframe>';
    } elseif ( $video_type == 'dailymotion' ) {
        return '<iframe src="http://www.dailymotion.com/embed/video/' . urlencode( $video_id ) . '" style="width:' . esc_attr( $width ) . '; height:' . esc_attr( $height ) . '; border:none;overflow:hidden;"></iframe>';
    } else {
        return '';
    }
}

add_shortcode( 'leap_video', 'leap_shortcode_video' );

//////////////////////////////////////////////////////////////////
// SoundCloud shortcode
//////////////////////////////////////////////////////////////////
function leap_shortcode_soundcloud( $atts ) {
    extract( shortcode_atts(
    array(
        'url'       => '',
        'width'     => '100%',
        'height'    => '81px',
        'comments'  => 'true',
        'auto_play' => 'false',
    ), $atts ) );

    return '<iframe src="https://w.soundcloud.com/player/?url=' . urlencode( $url ) . '&amp;show_comments=' . urlencode( $comments ) . '&amp;auto_play=' . urlencode( $auto_play ) . '" style="width:' . esc_attr( $width ) . '; height:' . esc_attr( $height ) . '; border:none;overflow:hidden;"></iframe>';
}

add_shortcode( 'leap_soundcloud', 'leap_shortcode_soundcloud' );

//////////////////////////////////////////////////////////////////
// Button shortcode
//////////////////////////////////////////////////////////////////
function leap_shortcode_button( $atts, $content = null ) {
    extract( shortcode_atts(
    array(
        'align'                  => 'none',
        'link'                   => '#',
        'class'                  => '',
        'target'                 => '',
        'borderwidth'            => '',
        'borderradius'           => '',
        'bordercolor'            => '',
        'borderstyle'            => '',
        'leap_btn_font_family'   => '',
        'background_color'       => '',
        'button_title_color'     => '',
        'line_height'            => '',
        'leap_btn_font_size'     => '',
        'hover_title_color'      => '',
        'hover_background_color' => '',
        'bordercolor_hover'     => '',
        'padding_top'            => '',
        'padding_bottom'         => '',
        'padding_right'          => '',
        'padding_left'           => '',
    ), $atts ) );

    if ( empty( $align ) ) {
        $align = 'none';
    }

    if ( empty( $target ) ) {
        $target = '_self';
    }
      if ( is_numeric( $line_height ) ) {
        $line_height = $line_height . 'px';
    }
    if ( is_numeric( $borderradius ) ) {
        $borderradius = $borderradius . 'px';
    }
    if ( is_numeric( $borderwidth ) ) {
        $borderwidth = $borderwidth . 'px';
    }
    if ( is_numeric( $leap_btn_font_size ) ) {
        $leap_btn_font_size = $leap_btn_font_size . 'px';
    }
     if ( is_numeric( $padding_top ) ) {
        $padding_top = $padding_top . 'px';
    }
     if ( is_numeric( $padding_bottom ) ) {
        $padding_bottom = $padding_bottom . 'px';
    }
      if ( is_numeric( $padding_left ) ) {
        $padding_left = $padding_left . 'px';
    }
      if ( is_numeric( $padding_right ) ) {
        $padding_right = $padding_right . 'px';
    }
    
    $html = '';
    $id = uniqid();
    if ( $align != 'none' ) {
        $html .= '<div class="text-' . esc_attr( $align ) . '">';
    }
$css_style = '<style type="text/css" scoped>' . "\n";
    $css_style .='#leap_btn-' . $id . '.btn-leap {' . "\n";
    if ( !empty( $background_color ) ) {
        $css_style .= 'background-color:' . $background_color . ';' . "\n";
    }
    if ( !empty( $button_title_color ) ) {
        $css_style .= 'color:' . $button_title_color . ';' . "\n";
    }
    if ( !empty( $line_height ) ) {
        $css_style .= 'line-height:' . $line_height . ';' . "\n";
    }
    if ( !empty( $bordercolor ) ) {
        $css_style .= 'border-color:' . $bordercolor . ';' . "\n";
    }
    if ( !empty( $borderstyle ) ) {
        $css_style .= 'border-style:' . $borderstyle . ';' . "\n";
    }
    if ( !empty( $borderradius ) ) {
        $css_style .= 'border-radius:' . $borderradius . ';' . "\n";
    }
    if ( !empty( $borderwidth ) ) {
        $css_style .= 'border-width:' . $borderwidth . ';' . "\n";
    }
    if ( !empty( $leap_btn_font_family ) ) {
        $css_style .= 'font-family:' . leap_get_font_family( $leap_btn_font_family ) . ';' . "\n";
    }
    if ( !empty( $leap_btn_font_size ) ) {
        $css_style .= 'font-size:' . $leap_btn_font_size . ';' . "\n";
    }

    if ( !empty( $padding_top ) ) {
        $css_style .= 'padding-top:' . $padding_top . ';' . "\n";
    }

    if ( !empty( $padding_bottom ) ) {
        $css_style .= 'padding-bottom:' . $padding_bottom . ';' . "\n";
    }

    if ( !empty( $padding_left ) ) {
        $css_style .= 'padding-left:' . $padding_left . ';' . "\n";
    }

    if ( !empty( $padding_right ) ) {
        $css_style .= 'padding-right:' . $padding_right . ';' . "\n";
    }

    $css_style .= '}' . "\n";
    $css_style .='#leap_btn-' . $id . '.btn-leap:hover{' . "\n";
    if ( !empty( $hover_background_color ) ) {
        $css_style .= 'background-color:' . $hover_background_color . ';' . "\n";
    }
    if ( !empty( $hover_title_color ) ) {
        $css_style .= 'color:' . $hover_title_color . ';' . "\n";
    }
    if ( !empty( $bordercolor_hover ) ) {
        $css_style .= 'border-color:' . $bordercolor_hover . ';' . "\n";
    }

    $css_style .= '}' . "\n";
    $css_style .= '</style>';
     if( !empty($atts['link']) && !empty($atts['target']) ) {
    $html .= '<a class="btn-link"  href="' . esc_url( $link ) . '" target="' . esc_attr( $target ) . '">';
     }
    $html .= '<button   id="leap_btn-' . $id . '" class="btn btn-leap' . esc_attr( $class ) .'">';
    $html .= do_shortcode( $content );
    $html .= '</button>';
    $html .= $css_style;
 if( !empty($atts['link']) && !empty($atts['target']) ) {   
    $html .= '</a>';
    }
    if ( $align != 'none' ) {
        $html .= '</div>';
    }

    return $html;
    }


add_shortcode( 'leap_button', 'leap_shortcode_button' );


//////////////////////////////////////////////////////////////////
// Dropcap shortcode
//////////////////////////////////////////////////////////////////

function leap_shortcode_dropcap( $atts, $content = null ) {
    extract( shortcode_atts(
    array(
        'style' => 'style-1',
    ), $atts ) );
    return '<span class="dropcap ' . esc_attr( $style ) . '">' . do_shortcode( $content ) . '</span>';
}

add_shortcode( 'leap_dropcap', 'leap_shortcode_dropcap' );

//////////////////////////////////////////////////////////////////
// Highlight shortcode
//////////////////////////////////////////////////////////////////
function leap_shortcode_highlight( $atts, $content = null ) {
    extract( shortcode_atts(
    array(
        'style' => 'orange',
    ), $atts ) );
    return '<span class="highlight highlight-' . esc_attr( $style ) . '">' . do_shortcode( $content ) . '</span>';
}

add_shortcode( 'leap_highlight', 'leap_shortcode_highlight' );

//////////////////////////////////////////////////////////////////
// Highlight shortcode
//////////////////////////////////////////////////////////////////
function leap_shortcode_quote( $atts, $content = null ) {
    extract(
    shortcode_atts( array(
        'style'         => 'single-quotes',
        'icon_size'     => '',
        'icon_color'    => '',
        'text_size'     => '',
        'text_color'    => '',
        'padding_right' => '',
        'padding_left'  => '',
        'bg_color'      => '',
    ), $atts
    ) );

    $html = '';
    $id   = uniqid( 'quote-' );

    $css_style = '<style type="text/css" scoped>'
    . '#' . $id . '.single-quotes-bg, #' . $id . '.double-quotes-bg {'
    . 'background-color: ' . esc_attr( $bg_color ) . ';'
    . '}'
    . '#' . $id . ' .quote-inner > i  {'
    . 'font-size: ' . esc_attr( $icon_size ) . ';'
    . 'color: ' . esc_attr( $icon_color ) . ';'
    . '}'
    . '#' . $id . ' .quote-inner > div  {'
    . 'font-size: ' . esc_attr( $text_size ) . ';'
    . 'color: ' . esc_attr( $text_color ) . ';'
    . 'padding-right: ' . esc_attr( $padding_right ) . ';'
    . 'padding-left: ' . esc_attr( $padding_left ) . ';'
    . '}'
    . '</style>';

    $html .= '<div id="' . $id . '" class="leap-quote ' . esc_attr( $style ) . '">';
    $html .= $css_style;
    $html .= '<div class="quote-inner"><i class="fa fa-quote-left"></i><div>' . do_shortcode( $content ) . '</div><i class="fa fa-quote-left fa-flip-horizontal"></i></div></div>';

    return $html;
}

add_shortcode( 'leap_quote', 'leap_shortcode_quote' );

//////////////////////////////////////////////////////////////////
// Content box shortcode
//////////////////////////////////////////////////////////////////
add_shortcode( 'leap_image_box', 'leap_shortcode_image_box' );

function leap_shortcode_image_box( $atts, $content = null ) {
    extract( shortcode_atts( array(
        'layout'                => 'title-top',
        'centerbox'             => 'no',
        'image'                 => '',
        'title'                 => '',
        'titlecolor'            => '',
        'font_family'           => '',
        'font_size'             => '',
        'line_height'           => '',
        'backgroundcolor'       => '',
        'link'                  => '',
        'linkcolor'             => '',
        'linktext'              => '',
        'image_effect'          => 'no',
        'hover_titlecolor'      => '',
        'hover_textcolor'       => '',
        'hover_backgroundcolor' => '',
        'hover_linkcolor'       => '',
        'linktarget'            => '_self',
        'animationtype'         => '',
        'animationspeed'        => '1',
        'animationdelay'        => '0',
        'animationoffset'       => '100',
        'animationiteration'    => '1',
    ), $atts ) );


    if ( $centerbox == 'yes' ) {
        $centerbox = 'text-center';
    } else {
        $centerbox = '';
    }

    if ( $image_effect == 'yes' ) {
        $image_effect = 'image-effect';
    } else {
        $image_effect = '';
    }

    if ( empty( $layout ) ) {
        $layout = 'title-top';
    }
    
    if ( is_numeric( $font_size ) ) {
        $font_size = $font_size . 'px';
    }

    if ( is_numeric( $image ) ) {
        $attachment_id    = absint( $image );
        $image_attributes = wp_get_attachment_image_src( $attachment_id, 'full' );
        $image            = $image_attributes[ 0 ];
    }

    $imagebox_bg = '';
    if ( $backgroundcolor ) {
        $imagebox_bg = 'image-box-with-bg';
    }

    if ( empty( $animationspeed ) ) {
        $animationspeed = '1';
    }

    if ( empty( $animationdelay ) ) {
        $animationdelay = '0';
    }

    if ( empty( $animationoffset ) ) {
        $animationoffset = '100';
    }
    if ( empty( $animationiteration ) ) {
        $animationiteration = '1';
    }


    $antimation       = '';
    $antimation_class = '';

    if ( $animationtype ) {
        $antimation_class .= 'leap-animate ' . $animationtype;

        $antimation .= 'data-wow-offset="' . $animationoffset . '" data-wow-duration="' . $animationspeed . 's" data-wow-delay="' . $animationdelay . 's" data-wow-iteration="' . $animationiteration . '"';
    }

    static $leap_img_box_counter = 1;

    $css_style = '<style type="text/css" scoped>' . "\n";
    $css_style .= '#leap-img-box-' . $leap_img_box_counter . ' div.col {' . "\n";
    if ( !empty( $backgroundcolor ) ) {
        $css_style .= 'background-color:' . $backgroundcolor . ';' . "\n";
    }
    $css_style .= '}' . "\n";
    $css_style .= '#leap-img-box-' . $leap_img_box_counter . ' h4 {' . "\n";
    if ( !empty( $titlecolor ) ) {
        $css_style .= 'color:' . $titlecolor . ';' . "\n";
    }
    
    if (function_exists('leap_all_font_families')) {
        $families = leap_all_font_families();
        //$font_family = $families[$font_family];
    }
    if ( !empty( $font_family ) ) {
        $css_style .= 'font-family:' . leap_get_font_family($font_family) . ';';
    }

    if ( !empty( $font_size ) ) {
        $css_style .= 'font-size:' . $font_size . ';' . "\n";
    }

    if ( !empty( $line_height ) ) {
        $css_style .= 'line-height:' . $line_height . ';' . "\n";
    }
    $css_style .= '}' . "\n";
    $css_style .= '#leap-img-box-' . $leap_img_box_counter . ' .box-content a.more-link {' . "\n";
    if ( !empty( $linkcolor ) ) {
        $css_style .= 'color:' . $linkcolor . ';' . "\n";
    }
    $css_style .= '}' . "\n";
    $css_style .= '#leap-img-box-' . $leap_img_box_counter . ':hover h4 {' . "\n";
    if ( !empty( $hover_titlecolor ) ) {
        $css_style .= 'color:' . $hover_titlecolor . ';' . "\n";
    }
    $css_style .= '}' . "\n";
    $css_style .= '#leap-img-box-' . $leap_img_box_counter . ':hover .box-content {' . "\n";
    if ( !empty( $hover_textcolor ) ) {
        $css_style .= 'color:' . $hover_textcolor . '!important;' . "\n";
    }
    $css_style .= '}' . "\n";
    $css_style .= '#leap-img-box-' . $leap_img_box_counter . ':hover div.col {' . "\n";
    if ( !empty( $hover_backgroundcolor ) ) {
        $css_style .= 'background-color:' . $hover_backgroundcolor . ';' . "\n";
    }
    $css_style .= '}' . "\n";
    $css_style .= '#leap-img-box-' . $leap_img_box_counter . ':hover .box-content a.more-link {' . "\n";
    if ( !empty( $hover_linkcolor ) ) {
        $css_style .= 'color:' . $hover_linkcolor . ';' . "\n";
    }
    $css_style .= '}' . "\n";
    $css_style .= '</style>';

    $str = '<div id="leap-img-box-' . $leap_img_box_counter . '" class="leap-img-box layout-' . $layout . ' ' . $antimation_class . ' ' . $centerbox . ' ' . $image_effect . ' ' . $imagebox_bg . '" ' . $antimation . '>';
    $str .= $css_style;
    $str .= '<div class="col">';

    if ( $layout == 'title-top' ) {
        if ( $title ) {
            $str .= '<h4>' . $title . '</h4>';
        }

        if ( $image ) {
            $str .= '<div class="img-box-img"><img alt="' . $title . '" src="' . $image . '"></div>';
        }

        $str .= '<div class="box-content">';
        $str .= do_shortcode( $content );
        if ( $link && $linktext ):
            $str .= '<div class="more"><a class="more-link" href="' . $link . '" target="' . $linktarget . '"><span>' . $linktext . '</span></a></div>';
        endif;
        $str .= '</div>';
    }

    if ( $layout == 'image-top' ) {
        if ( $image ) {
            $str .= '<div class="img-box-img"><img alt="' . $title . '"  src="' . $image . '"></div>';
        }

        if ( $title ) {
            $str .= '<h4>' . $title . '</h4>';
        }

        $str .= '<div class="box-content">';
        $str .= do_shortcode( $content );
        if ( $link && $linktext ):
            $str .= '<div class="more"><a class="more-link" href="' . $link . '" target="' . $linktarget . '"><span>' . $linktext . '</span></a></div>';
        endif;
        $str .= '</div>';
    }

    if ( $layout == 'image-side' ) {
        if ( $image ) {
            $str .= '<div class="img-box-img"><img alt="' . $title . '"  src="' . $image . '"></div>';
        }

        $str .= '<div class="box-content">';
        if ( $title ) {
            $str .= '<h4>' . $title . '</h4>';
        }
        $str .= do_shortcode( $content );
        if ( $link && $linktext ):
            $str .= '<div class="more"><a class="more-link" href="' . $link . '" target="' . $linktarget . '"><span>' . $linktext . '</span></a></div>';
        endif;
        $str .= '</div>';
    }

    $str .= '</div></div>';

    $leap_img_box_counter++;

    return $str;
}

//////////////////////////////////////////////////////////////////
// Content box shortcode
//////////////////////////////////////////////////////////////////
add_shortcode( 'leap_icon_box', 'leap_shortcode_icons_box' );

function leap_shortcode_icons_box( $atts, $content = null ) {
    extract( shortcode_atts( array(
        'layout'             => 'icon-with-title',
        'iconimage'          => '',
        'iconimagewidth'     => '35',
        'iconimageheight'    => '35',
        'title'              => '',
        'titlecolor'         => '',
        'circle'             => 'yes',
        'circlecolor'        => '',
        'icon'               => '',
        'iconcolor'          => '',
        'circlebordercolor'  => '',
        'backgroundcolor'    => '',
        'link'               => '',
        'linkcolor'          => '',
        'linktext'           => '',
        'linktarget'         => '_self',
        'animationtype'      => '',
        'animationspeed'     => '1',
        'animationdelay'     => '0',
        'animationoffset'    => '100',
        'animationiteration' => '1',
    ), $atts ) );

    if ( empty( $layout ) ) {
        $layout = 'icon-with-title';
    }
    if ( empty( $iconimagewidth ) ) {
        $iconimagewidth = '35';
    }
    if ( empty( $iconimageheight ) ) {
        $iconimageheight = '35';
    }

    if ( empty( $iconcolor ) ) {
        $iconcolor = '#ffffff';
    }
    if ( empty( $circlecolor ) ) {
        $circlecolor = '#333333';
    }
    if ( empty( $circlebordercolor ) ) {
        $circlebordercolor = '#333333';
    }

    $icon_box_with_bg = '';
    if ( $backgroundcolor ) {
        $icon_box_with_bg = 'leap-box-with-bg';
    }

    if ( empty( $circle ) ) {
        $circle = 'yes';
    }

    if ( $circle == 'yes' ) {
        $circle_class = 'circle-yes';
    } else {
        $circle_class = '';
    }

    if ( is_numeric( $iconimage ) ) {
        $attachment_id    = absint( $iconimage );
        $image_attributes = wp_get_attachment_image_src( $attachment_id, 'full' );
        $iconimage        = $image_attributes[ 0 ];
    }




    if ( empty( $animationspeed ) ) {
        $animationspeed = '1';
    }

    if ( empty( $animationdelay ) ) {
        $animationdelay = '0';
    }

    if ( empty( $animationoffset ) ) {
        $animationoffset = '100';
    }
    if ( empty( $animationiteration ) ) {
        $animationiteration = '1';
    }


    $antimation       = '';
    $antimation_class = '';

    if ( $animationtype ) {
        $antimation_class .= 'leap-animate ' . $animationtype;

        $antimation .= 'data-wow-offset="' . $animationoffset . '" data-wow-duration="' . $animationspeed . 's" data-wow-delay="' . $animationdelay . 's" data-wow-iteration="' . $animationiteration . '"';
    }

    static $leap_icon_box_counter = 1;

    $css_styles = '<style type="text/css" scoped>
		#leap-icon-box-' . $leap_icon_box_counter . ' div.col{background-color: ' . $backgroundcolor . ';}
		#leap-icon-box-' . $leap_icon_box_counter . ' .fontawesome-icon{color: ' . $iconcolor . ';}
		#leap-icon-box-' . $leap_icon_box_counter . ' .fontawesome-icon.circle-yes{background-color: ' . $circlecolor . ' !important;border:1px solid ' . $circlebordercolor . ';}
		#leap-icon-box-' . $leap_icon_box_counter . ' .heading h4 {color: ' . $titlecolor . ';}
		#leap-icon-box-' . $leap_icon_box_counter . ' .col-content-container a.more-link {color: ' . $linkcolor . ';}
	</style>';

    $str = '<div id="leap-icon-box-' . $leap_icon_box_counter . '" class="leap-icon-box layout-' . $layout . ' ' . $icon_box_with_bg . ' ' . $circle_class . ' ' . $antimation_class . '" ' . $antimation . '>';
    $str .= $css_styles;
    $str .= '<div class="col">';

    if ( $iconimage || $title || $icon ):
        if ( !empty( $iconimage ) || !empty( $icon ) ) {
            $str .= '<div class="heading heading-and-icon">';
        } else {
            $str .= '<div class="heading">';
        }
        if ( $iconimage ):
            $str .= '<img src="' . esc_url( $iconimage ) . '" style="width:' . esc_attr( $iconimagewidth ) . '; height:' . esc_attr( $iconimageheight ) . ';" alt="">';
        endif;
        if ( !empty( $icon ) && $icon ):
            $str .= '<i class="fontawesome-icon medium ' . $circle_class . ' fa fa-' . $icon . '"></i>';
        endif;
        if ( $title ):
            $str .= '<h4>' . $title . '</h4>';
        endif;
        $str .= '</div>';
    endif;

    $str .= '<div class="col-content-container">';

    $str .= do_shortcode( $content );

    if ( $link && $linktext ):
        $str .= '<div class="more"><a class="more-link" href="' . $link . '" target="' . $linktarget . '"><span>' . $linktext . '</span></a></div>';
    endif;

    $str .= '</div>';

    $str .= '</div></div>';

    $leap_icon_box_counter++;

    return $str;
}
//////////////////////////////////////////////////////////////////
// Icon Box 2 shortcode
//////////////////////////////////////////////////////////////////
add_shortcode( 'leap_icon_box_2', 'leap_shortcode_icon_box_2' );

function leap_shortcode_icon_box_2( $atts, $content = null ) {
    $atts = shortcode_atts( array(
        
        'icon_to_display'    => 'icon',
        'image'              => '',
        'size'               => '',
        'icon'               => '',
        'icon_size'          => '',
        'icon_color'         => '',
        'icon_hover_color'   => '',
        'box_align'   => '',
        'hover_animation'    => 'hvr-pulse-grow',
        'title'              => '', 
        'title_heading'      => 'h2',
        'title_color'        => '',
        'readmore_link'      => '',
        'readmore_text'      => '',
        'readmore_icon'      => '',
        'readmore_color'     => '',
        'readmore_size'      => '',
        'readmore_icon_size'      => '',
        'readmore_hover_color'          => '',        
        'content_background_color' => '',
        'content_border_color' => '',
        'content_border_hover_color' => '',
        'background_color' => '',
        'back_icon_color' => '',
        'padding_top'     => '',
        'padding_bottom'     => '',
        'padding_right'     => '',
        'padding_left'     => ''
    ), $atts );
    
    if ( empty( $atts['size'] ) ) {
        $atts['size'] = 'full';
    }
    
    $size_x = stripos( $atts['size'], 'x' );
    $attachment_id    = absint( $atts['image'] );
    $image_attributes = wp_get_attachment_image_src( $attachment_id, $atts['size'] );
    if ( $size_x !== false ) {
        $size         = explode( 'x', $atts['size'] );
        $image_width  = ( empty( $size[ 0 ] ) ) ? 0 : (int) $size[ 0 ];
        $image_height = ( empty( $size[ 1 ] ) ) ? 0 : (int) $size[ 1 ];
    } else {
        $image_width  = $image_attributes[ 1 ];
        $image_height = $image_attributes[ 2 ];
    }

    if ( is_numeric( $atts['image'] ) ) {
        $attachment_id    = absint( $atts['image'] );
        $image_attributes = wp_get_attachment_image_src( $attachment_id, $atts['size'] );
        $atts['image']          = $image_attributes[ 0 ];
    }

    if ( is_numeric( $atts['icon_size'] ) ) {
        $atts['icon_size'] = $atts['icon_size'] . 'px';
    }
    
    if ( is_numeric( $atts['readmore_size'] ) ) {
        $atts['readmore_size'] = $atts['readmore_size'] . 'px';
    }
    
    if ( is_numeric( $atts['readmore_icon_size'] ) ) {
        $atts['readmore_icon_size'] = $atts['readmore_icon_size'] . 'px';
    }
    
    if( empty( $atts['title_heading'] ) ) {
        $atts['title_heading'] = 'h2';
    }

    static $counter = 1;

    $css_style = '<style type="text/css" scoped>' . "\n";  
    
		$css_style .= '#leap-icon-box-2-' . $counter . ' .main-icon i {' . "\n";
        if ( !empty( $atts['icon_color'] ) ) {
            $css_style .= 'color:' . $atts['icon_color'] . ';' . "\n";
        }
        if ( !empty( $atts['icon_size'] ) ) {
            $css_style .= 'font-size:' . $atts['icon_size'] . ';' . "\n";
        }
        $css_style .= '}' . "\n";
        
        $css_style .= '#leap-icon-box-2-' . $counter . ':hover .main-icon i {' . "\n";
        if ( !empty( $atts['icon_hover_color'] ) ) {
            $css_style .= 'color:' . $atts['icon_hover_color'] . ';' . "\n";
        }
        $css_style .= '}' . "\n";
        
        $css_style .= '#leap-icon-box-2-' . $counter . ' .icon-box-title {' . "\n";
        if ( !empty( $atts['title_color'] ) ) {
            $css_style .= 'color:' . $atts['title_color'] . ';' . "\n";
        }
        $css_style .= '}' . "\n";
        
        $css_style .= '#leap-icon-box-2-' . $counter . ' .learn-more {' . "\n";
        if ( !empty( $atts['readmore_color'] ) ) {
            $css_style .= 'color:' . $atts['readmore_color'] . ';' . "\n";
        }
        if ( !empty( $atts['readmore_size'] ) ) {
            $css_style .= 'font-size:' . $atts['readmore_size'] . ';' . "\n";
        }
        $css_style .= '}' . "\n";
        
        $css_style .= '#leap-icon-box-2-' . $counter . ' .learn-more i {' . "\n";
        if ( !empty( $atts['readmore_icon_size'] ) ) {
            $css_style .= 'font-size:' . $atts['readmore_icon_size'] . ';' . "\n";
        }
        $css_style .= '}' . "\n";
        
        $css_style .= '#leap-icon-box-2-' . $counter . ' .learn-more:hover {' . "\n";
        if ( !empty( $atts['readmore_hover_color'] ) ) {
            $css_style .= 'color:' . $atts['readmore_hover_color'] . ';' . "\n";
        }
        $css_style .= '}' . "\n";
        
        $css_style .= '#leap-icon-box-2-' . $counter . ' .icon-box-details {' . "\n";
        if ( !empty( $atts['content_background_color'] ) ) {
            $css_style .= 'background-color:' . $atts['content_background_color'] . ';' . "\n";
        }
        if ( !empty( $atts['content_border_color'] ) ) {
            $css_style .= 'border-color:' . $atts['content_border_color'] . ';' . "\n";
        }
        if ( !empty( $atts['padding_top'] ) ) {
            $css_style .= 'padding-top:' . $atts['padding_top'] . ';' . "\n";
        }
        if ( !empty( $atts['padding_bottom'] ) ) {
            $css_style .= 'padding-bottom:' . $atts['padding_bottom'] . ';' . "\n";
        }
        if ( !empty( $atts['padding_right'] ) ) {
            $css_style .= 'padding-right:' . $atts['padding_right'] . ';' . "\n";
        }
        if ( !empty( $atts['padding_left'] ) ) {
            $css_style .= 'padding-left:' . $atts['padding_left'] . ';' . "\n";
        }
        $css_style .= '}' . "\n";
        
        $css_style .= '#leap-icon-box-2-' . $counter . ':hover .icon-box-details {' . "\n";
        if ( !empty( $atts['content_border_hover_color'] ) ) {
            $css_style .= 'border-color:' . $atts['content_border_hover_color'] . ';' . "\n";
        }
        $css_style .= '}' . "\n";
        
        $css_style .= '#leap-icon-box-2-' . $counter . ' {' . "\n";
        if ( !empty( $atts['background_color'] ) ) {
            $css_style .= 'background-color:' . $atts['background_color'] . ';' . "\n";
        }
        $css_style .= '}' . "\n";
        
        $css_style .= '#leap-icon-box-2-' . $counter . ' .icon-bg i {' . "\n";
        if ( !empty( $atts['back_icon_color'] ) ) {
            $css_style .= 'color:' . $atts['back_icon_color'] . ';' . "\n";
        }
        $css_style .= '}' . "\n";
        
	$css_style .= '</style>';
    
    
    $str = $css_style;
    $str .= "<div id='leap-icon-box-2-{$counter}' class='icon-box2'>
                <div class='icon-box-details {$atts['box_align']}'> 
                    <span class='main-icon'>";
                        if( !empty($atts['icon']) && ($atts['icon_to_display'] == 'icon') ) {
                            $str .= "<i class= 'fa fa-{$atts['icon']} {$atts['hover_animation']}'></i>";
                            
                        }
                        if( !empty($atts['image']) && ($atts['icon_to_display'] == 'image') ) {
                            $str .= "<img src='{$atts['image']}' class='{$atts['hover_animation']}' width='{$image_width}' height='{$image_height}'/>";
                        }       
         $str .= "</span>
                    <{$atts['title_heading']} class='icon-box-title'>". esc_html($atts['title']) ."</{$atts['title_heading']}>
                    <div class='icon-box-description'>".  do_shortcode($content) ."</div>";
                    if( !empty($atts['readmore_link']) && !empty($atts['readmore_text']) ) {
                        $str .= "<a class='learn-more' href='". esc_url($atts['readmore_link']) ."'>". esc_html($atts['readmore_text']) ." <i class='{$atts['readmore_icon']}'></i></a>";
                    }
                $str .= "</div>
                <div class='icon-bg'>";
                    if( !empty($atts['icon']) && ($atts['icon_to_display'] == 'icon') ) {
                            $str .= "<i class='fa fa-{$atts['icon']}'></i>";
                    }
                    if( !empty($atts['image']) && ($atts['icon_to_display'] == 'image') ) {
                        $str .= "<img src='{$atts['image']}'/>";
                    }
                $str .= "</div>
            </div>";

    $counter++;

    return $str;
}
//////////////////////////////////////////////////////////////////
// ul shortcode
//////////////////////////////////////////////////////////////////
function leap_shortcode_ul( $atts, $content = null ) {
    $str = '<ul class="fa-ul ul-leap">';
    $str .= do_shortcode( $content );
    $str .= '</ul>';

    return $str;
}

add_shortcode( 'leap_ul', 'leap_shortcode_ul' );

//////////////////////////////////////////////////////////////////
// li shortcode
//////////////////////////////////////////////////////////////////
function leap_shortcode_li( $atts, $content = null ) {
    extract( shortcode_atts( array(
        'icon'      => 'fa-chevron-right',
        'iconcolor' => 'inherit'
    ), $atts ) );

    if ( empty( $icon ) ) {
        $icon = 'fa-chevron-right';
    }

    if ( empty( $iconcolor ) ) {
        $iconcolor = 'inherit';
    }

    // <li><i class="fa-li fa fa-check-square"></i>List icons (like these)</li>
    $str = '<li><i class="fa-li fa ' . $icon . '" style="color: ' . $iconcolor . ';"></i>';
    $str .= do_shortcode( $content );
    $str .= '</li>';

    return $str;
}

add_shortcode( 'leap_li', 'leap_shortcode_li' );

//////////////////////////////////////////////////////////////////
// Google Font shortcode
//////////////////////////////////////////////////////////////////
function leap_shortcode_google_font( $atts, $content = null ) {
    extract( shortcode_atts( array(
        'family'     => '',
        'size'       => '',
        'lineheight' => ''
    ), $atts ) );

    $style = '';
    if ( $family ) {
        $style .= 'font-family: \'' . $family . '\' !important;';
    }

    if ( $size ) {
        $style .= 'font-size:' . $size . ' !important;';
    }

    if ( empty( $lineheight ) ) {
        $lineheight = $size;
    }

    if ( $lineheight ) {
        $style .= 'line-height: ' . $lineheight . '  !important;';
    }

    if ( $family ) {
        $str = '<link href="//fonts.googleapis.com/css?family=' . $family . '" rel="stylesheet" type="text/css">';
    }
    $str .= '<div style="' . $style . '">';
    $str .= do_shortcode( $content );
    $str .= '</div>';

    return $str;
}

add_shortcode( 'leap_google_font', 'leap_shortcode_google_font' );

//////////////////////////////////////////////////////////////////
// Tagline box shortcode
//////////////////////////////////////////////////////////////////
function leap_shortcode_tagline_box( $atts, $content = null ) {
    extract( shortcode_atts(
    array(
        'style'              => '',
        'title'              => '',
        'button'             => '',
        'link'               => '',
        'target'             => '_self',
        'centertext'         => 'no',
        'backgroundcolor'    => '',
        'titlecolor'         => '',
        'textcolor'          => '',
        'bordersize'         => '0px',
        'bordercolor'        => '',
        'borderstyle'        => 'solid',
        'class'              => '',
        'animationtype'      => '',
        'animationspeed'     => '1',
        'animationdelay'     => '0',
        'animationoffset'    => '100',
        'animationiteration' => '1',
    ), $atts ) );

    static $leap_tagline_box_counter = 1;
    $str                             = '';

    if ( empty( $target ) ) {
        $target = '_self';
    }

    if ( empty( $animationspeed ) ) {
        $animationspeed = '1';
    }

    if ( empty( $animationdelay ) ) {
        $animationdelay = '0';
    }

    if ( empty( $animationoffset ) ) {
        $animationoffset = '100';
    }
    if ( empty( $animationiteration ) ) {
        $animationiteration = '1';
    }

    $antimation       = '';
    $antimation_class = '';

    if ( $animationtype ) {
        $antimation_class .= 'leap-animate ' . $animationtype;

        $antimation .= 'data-wow-offset="' . $animationoffset . '" data-wow-duration="' . $animationspeed . 's" data-wow-delay="' . $animationdelay . 's" data-wow-iteration="' . $animationiteration . '"';
    }

    if ( $centertext == 'yes' ) {
        $centertext = 'text-center';
    } else {
        $centertext = '';
    }


    $css_styles = '<style type="text/css" scoped>
			#tagline-box-' . $leap_tagline_box_counter . ' {
				background-color: ' . $backgroundcolor . ';
				border-width: ' . $bordersize . ';
				border-color: ' . $bordercolor . ';
				border-style: ' . $borderstyle . ';
			}
			#tagline-box-' . $leap_tagline_box_counter . ' h2.tagline-title {
				color: ' . $titlecolor . ';
			}
			#tagline-box-' . $leap_tagline_box_counter . ' .tagline-content {
				color: ' . $textcolor . ';
			}
		</style>';


    $str .= '<div id="tagline-box-' . $leap_tagline_box_counter . '" class="tagline-box ' . $style . ' ' . $centertext . ' ' . $class . ' ' . $antimation_class . '" ' . $antimation . '>';
    $str .= $css_styles;
    if ( $link && $button ):
        $str .= '<a href="' . $link . '" target="' . $target . '" class="btn btn-leap btn-lg hidden-xs">' . $button . '</a>';
    endif;
    $str .= '<h2 class="tagline-title">' . $title . '</h2>';
    if ( $content ):
        $str.= '<div class="tagline-content">';
        $str.= do_shortcode( $content );
        $str.= '</div>';
    endif;
    if ( $link && $button ):
        $str .= '<a href="' . $link . '" target="' . $target . '" class="btn btn-leap btn-lg visible-xs">' . $button . '</a>';
    endif;
    $str .= '</div>';

    $leap_tagline_box_counter++;
    return $str;
}

add_shortcode( 'leap_tagline_box', 'leap_shortcode_tagline_box' );

//////////////////////////////////////////////////////////////////
// Column one_half shortcode
//////////////////////////////////////////////////////////////////
function leap_shortcode_one_half( $atts, $content = null ) {
    extract( shortcode_atts(
    array(
        'last'               => 'no',
        'margintop'          => '',
        'marginbottom'       => '',
        'animationtype'      => '',
        'animationspeed'     => '1',
        'animationdelay'     => '0',
        'animationoffset'    => '100',
        'animationiteration' => '1',
    ), $atts ) );


    if ( empty( $animationspeed ) ) {
        $animationspeed = '1';
    }

    if ( empty( $animationdelay ) ) {
        $animationdelay = '0';
    }

    if ( empty( $animationoffset ) ) {
        $animationoffset = '100';
    }
    if ( empty( $animationiteration ) ) {
        $animationiteration = '1';
    }

    $antimation       = '';
    $antimation_class = '';

    if ( $animationtype ) {
        $antimation_class .= 'leap-animate ' . $animationtype;

        $antimation .= 'data-wow-offset="' . $animationoffset . '" data-wow-duration="' . $animationspeed . 's" data-wow-delay="' . $animationdelay . 's" data-wow-iteration="' . $animationiteration . '"';
    }

    $style = '';
    if ( $margintop ) {
        $style .= 'margin-top:' . $margintop . ';';
    }
    if ( $marginbottom ) {
        $style .= 'margin-bottom:' . $marginbottom . ';';
    }

    if ( $last == 'yes' ) {
        return '<div class="one_half last ' . $antimation_class . '" style="' . $style . '" ' . $antimation . '>' . do_shortcode( $content ) . '</div><div class="clearboth"></div>';
    } else {
        return '<div class="one_half ' . $antimation_class . '" style="' . $style . '" ' . $antimation . '>' . do_shortcode( $content ) . '</div>';
    }
}

add_shortcode( 'leap_one_half', 'leap_shortcode_one_half' );

//////////////////////////////////////////////////////////////////
// Column one_third shortcode
//////////////////////////////////////////////////////////////////
function leap_shortcode_one_third( $atts, $content = null ) {
    extract( shortcode_atts(
    array(
        'last'               => 'no',
        'margintop'          => '',
        'marginbottom'       => '',
        'animationtype'      => '',
        'animationspeed'     => '1',
        'animationdelay'     => '0',
        'animationoffset'    => '100',
        'animationiteration' => '1',
    ), $atts ) );

    if ( empty( $animationspeed ) ) {
        $animationspeed = '1';
    }

    if ( empty( $animationdelay ) ) {
        $animationdelay = '0';
    }

    if ( empty( $animationoffset ) ) {
        $animationoffset = '100';
    }
    if ( empty( $animationiteration ) ) {
        $animationiteration = '1';
    }

    $antimation       = '';
    $antimation_class = '';

    if ( $animationtype ) {
        $antimation_class .= 'leap-animate ' . $animationtype;

        $antimation .= 'data-wow-offset="' . $animationoffset . '" data-wow-duration="' . $animationspeed . 's" data-wow-delay="' . $animationdelay . 's" data-wow-iteration="' . $animationiteration . '"';
    }

    $style = '';
    if ( $margintop ) {
        $style .= 'margin-top:' . $margintop . ';';
    }
    if ( $marginbottom ) {
        $style .= 'margin-bottom:' . $marginbottom . ';';
    }

    if ( $last == 'yes' ) {
        return '<div class="one_third last ' . $antimation_class . '" style="' . $style . '" ' . $antimation . '>' . do_shortcode( $content ) . '</div><div class="clearboth"></div>';
    } else {
        return '<div class="one_third ' . $antimation_class . '" style="' . $style . '" ' . $antimation . '>' . do_shortcode( $content ) . '</div>';
    }
}

add_shortcode( 'leap_one_third', 'leap_shortcode_one_third' );

//////////////////////////////////////////////////////////////////
// Column two_third shortcode
//////////////////////////////////////////////////////////////////
function leap_shortcode_two_third( $atts, $content = null ) {
    extract( shortcode_atts(
    array(
        'last'               => 'no',
        'margintop'          => '',
        'marginbottom'       => '',
        'animationtype'      => '',
        'animationspeed'     => '1',
        'animationdelay'     => '0',
        'animationoffset'    => '100',
        'animationiteration' => '1',
    ), $atts ) );

    if ( empty( $animationspeed ) ) {
        $animationspeed = '1';
    }

    if ( empty( $animationdelay ) ) {
        $animationdelay = '0';
    }

    if ( empty( $animationoffset ) ) {
        $animationoffset = '100';
    }
    if ( empty( $animationiteration ) ) {
        $animationiteration = '1';
    }

    $antimation       = '';
    $antimation_class = '';

    if ( $animationtype ) {
        $antimation_class .= 'leap-animate ' . $animationtype;

        $antimation .= 'data-wow-offset="' . $animationoffset . '" data-wow-duration="' . $animationspeed . 's" data-wow-delay="' . $animationdelay . 's" data-wow-iteration="' . $animationiteration . '"';
    }

    $style = '';
    if ( $margintop ) {
        $style .= 'margin-top:' . $margintop . ';';
    }
    if ( $marginbottom ) {
        $style .= 'margin-bottom:' . $marginbottom . ';';
    }


    if ( $last == 'yes' ) {
        return '<div class="two_third last ' . $antimation_class . '" style="' . $style . '" ' . $antimation . '>' . do_shortcode( $content ) . '</div><div class="clearboth"></div>';
    } else {
        return '<div class="two_third ' . $antimation_class . '" style="' . $style . '" ' . $antimation . '>' . do_shortcode( $content ) . '</div>';
    }
}

add_shortcode( 'leap_two_third', 'leap_shortcode_two_third' );

//////////////////////////////////////////////////////////////////
// Column one_fourth shortcode
//////////////////////////////////////////////////////////////////
function leap_shortcode_one_fourth( $atts, $content = null ) {
    extract( shortcode_atts(
    array(
        'last'               => 'no',
        'margintop'          => '',
        'marginbottom'       => '',
        'animationtype'      => '',
        'animationspeed'     => '1',
        'animationdelay'     => '0',
        'animationoffset'    => '100',
        'animationiteration' => '1',
    ), $atts ) );

    if ( empty( $animationspeed ) ) {
        $animationspeed = '1';
    }

    if ( empty( $animationdelay ) ) {
        $animationdelay = '0';
    }

    if ( empty( $animationoffset ) ) {
        $animationoffset = '100';
    }
    if ( empty( $animationiteration ) ) {
        $animationiteration = '1';
    }

    $antimation       = '';
    $antimation_class = '';

    if ( $animationtype ) {
        $antimation_class .= 'leap-animate ' . $animationtype;

        $antimation .= 'data-wow-offset="' . $animationoffset . '" data-wow-duration="' . $animationspeed . 's" data-wow-delay="' . $animationdelay . 's" data-wow-iteration="' . $animationiteration . '"';
    }

    $style = '';
    if ( $margintop ) {
        $style .= 'margin-top:' . $margintop . ';';
    }
    if ( $marginbottom ) {
        $style .= 'margin-bottom:' . $marginbottom . ';';
    }

    if ( $last == 'yes' ) {
        return '<div class="one_fourth last ' . $antimation_class . '" style="' . $style . '" ' . $antimation . '>' . do_shortcode( $content ) . '</div><div class="clearboth"></div>';
    } else {
        return '<div class="one_fourth ' . $antimation_class . '" style="' . $style . '" ' . $antimation . '>' . do_shortcode( $content ) . '</div>';
    }
}

add_shortcode( 'leap_one_fourth', 'leap_shortcode_one_fourth' );

//////////////////////////////////////////////////////////////////
// Column three_fourth shortcode
//////////////////////////////////////////////////////////////////
function leap_shortcode_three_fourth( $atts, $content = null ) {
    extract( shortcode_atts(
    array(
        'last'               => 'no',
        'margintop'          => '',
        'marginbottom'       => '',
        'animationtype'      => '',
        'animationspeed'     => '1',
        'animationdelay'     => '0',
        'animationoffset'    => '100',
        'animationiteration' => '1',
    ), $atts ) );

    if ( empty( $animationspeed ) ) {
        $animationspeed = '1';
    }

    if ( empty( $animationdelay ) ) {
        $animationdelay = '0';
    }

    if ( empty( $animationoffset ) ) {
        $animationoffset = '100';
    }
    if ( empty( $animationiteration ) ) {
        $animationiteration = '1';
    }

    $antimation       = '';
    $antimation_class = '';

    if ( $animationtype ) {
        $antimation_class .= 'leap-animate ' . $animationtype;

        $antimation .= 'data-wow-offset="' . $animationoffset . '" data-wow-duration="' . $animationspeed . 's" data-wow-delay="' . $animationdelay . 's" data-wow-iteration="' . $animationiteration . '"';
    }

    $style = '';
    if ( $margintop ) {
        $style .= 'margin-top:' . $margintop . ';';
    }
    if ( $marginbottom ) {
        $style .= 'margin-bottom:' . $marginbottom . ';';
    }

    if ( $last == 'yes' ) {
        return '<div class="three_fourth last ' . $antimation_class . '" style="' . $style . '" ' . $antimation . '>' . do_shortcode( $content ) . '</div><div class="clearboth"></div>';
    } else {
        return '<div class="three_fourth ' . $antimation_class . '" style="' . $style . '" ' . $antimation . '>' . do_shortcode( $content ) . '</div>';
    }
}

add_shortcode( 'leap_three_fourth', 'leap_shortcode_three_fourth' );

//////////////////////////////////////////////////////////////////
// Toggle shortcode
//////////////////////////////////////////////////////////////////
function leap_shortcode_toggle( $atts, $content = null ) {
    extract( shortcode_atts(
    array(
        'title' => '',
        'open'  => 'no',
        'style' => 'style-1'
    ), $atts ) );

    if ( $open == 'yes' ) {
        $toggle_class = 'toggle-open';
    } else {
        $toggle_class = 'toggle';
    }
    return '<div class="' . $toggle_class . ' ' . $style . '"><h3>' . $title . '</h3><div>' . do_shortcode( $content ) . '</div></div>';
}

add_shortcode( 'leap_toggle', 'leap_shortcode_toggle' );

//////////////////////////////////////////////////////////////////
// Accordion shortcode
//////////////////////////////////////////////////////////////////
function leap_shortcode_accordion( $atts, $content = null ) {
    extract( shortcode_atts(
    array(
        'style'             => 'style-1',
        'title_color'       => '',
        'title_hover_color' => '',
        'title_bg'          => '',
        'title_hover_bg'    => '',
        'content_bg'        => ''
    ), $atts ) );

    $id = uniqid();

    $css_styles = '
		<style type="text/css" scoped>
		#leap-accordion-' . $id . '.ui-accordion .ui-accordion-header, #leap-accordion-' . $id . '.ui-accordion .ui-accordion-header .ui-accordion-header-icon:before {
			color: ' . $title_color . ' !important;
			background-color: ' . $title_bg . ';
		}
		#leap-accordion-' . $id . '.ui-accordion .ui-accordion-header:hover, #leap-accordion-' . $id . '.ui-accordion .ui-accordion-header .ui-accordion-header-icon:hover:before {
			color: ' . $title_hover_color . ' !important;
			background-color: ' . $title_hover_bg . ';
		}
		#leap-accordion-' . $id . '.ui-accordion .ui-accordion-content {
			background-color: ' . $content_bg . ';
		}
		</style>
		';

    $html = $css_styles;
    $html .= '<div id="leap-accordion-' . $id . '" class="accordion ' . $style . '">' . do_shortcode( $content ) . '</div>';
    return $html;
}

add_shortcode( 'leap_accordion', 'leap_shortcode_accordion' );

// Accordion item
function leap_shortcode_accordion_item( $atts, $content = null ) {
    extract( shortcode_atts(
    array(
        'title' => 'Title'
    ), $atts ) );

    return '<h3>' . $title . '</h3><div>' . do_shortcode( $content ) . '</div>';
}

add_shortcode( 'leap_accordion_item', 'leap_shortcode_accordion_item' );

//////////////////////////////////////////////////////////////////
// Recnet Posts shortcode
//////////////////////////////////////////////////////////////////
function leap_shortcode_recent_posts( $atts, $content = null ) {
    extract( shortcode_atts( array(
        'style'              => 'style-1',
        'posts'              => 5,
        'columns'            => 3,
        'cats'               => 'uncategorized',
        'readmore'           => 'yes',
        'orderby'            => 'post_date',
        'order'              => 'DESC',
        'excerptlength'      => apply_filters( 'excerpt_length', 55 ),
        'titlecolor'         => '',
        'metacolor'          => '',
        'textcolor'          => '',
        'morecolor'          => '',
        'animationtype'      => '',
        'animationspeed'     => '1',
        'animationdelay'     => '0',
        'animationoffset'    => '100',
        'animationiteration' => '1',
    ), $atts ) );


    if ( empty( $style ) ) {
        $style = 'style-1';
    }

    if ( empty( $columns ) || ($columns < 1 ) || ($columns >= 4 ) ) {
        $columns = 4;
    }

    if ( empty( $animationspeed ) ) {
        $animationspeed = '1';
    }

    if ( empty( $animationdelay ) ) {
        $animationdelay = '0';
    }

    if ( empty( $animationoffset ) ) {
        $animationoffset = '100';
    }
    if ( empty( $animationiteration ) ) {
        $animationiteration = '1';
    }

    $antimation       = '';
    $antimation_class = '';

    if ( $animationtype ) {
        $antimation_class .= 'leap-animate ' . $animationtype;

        $antimation .= 'data-wow-offset="' . $animationoffset . '" data-wow-duration="' . $animationspeed . 's" data-wow-delay="' . $animationdelay . 's" data-wow-iteration="' . $animationiteration . '"';
    }

    global $post;
    $orig_post = $post;

    $args = array(
        'posts_per_page' => $posts,
        'category_name'  => $cats,
        'orderby'        => $orderby,
        'order'          => $order
    );

    $myposts = get_posts( $args );


    static $leap_rcent_posts_counter = 1;

    $col_num = 12 / $columns;

    $html       = '';
    $css_styles = '';

    if ( $style != 'style-1' ) {
        $css_styles .= '<style type="text/css" scoped>
				#recent-posts-' . $leap_rcent_posts_counter . ' .post-title a {
					color: ' . $titlecolor . ';
				}
				#recent-posts-' . $leap_rcent_posts_counter . ' small.small {
					color: ' . $metacolor . ';
				}
				#recent-posts-' . $leap_rcent_posts_counter . ' .sc-rposts-content {
					color: ' . $textcolor . ';
				}
				#recent-posts-' . $leap_rcent_posts_counter . ' a.more-link {
					color: ' . $morecolor . ';
				}
			</style>';
    }


    $html .= '<div id="recent-posts-' . $leap_rcent_posts_counter . '" class="leap-recent-posts">';

    $html .= $css_styles;

    if ( $style == 'style-1' ) {
        $html .= '<div class="sc-rposts ' . $style . '">
		<ul>';
        foreach ( $myposts as $post ) : setup_postdata( $post );
            $html .= '<li>
				<a href="' . get_permalink() . '">' . get_the_title() . '</a>
			</li>';
        endforeach;
        $html .= '</ul>
		</div>';
    } elseif ( $style == 'style-2' ) {
        $html .= '<div class="sc-rposts ' . $style . '">';
        $i = 1;
        $html .= '<div class="row">';
        foreach ( $myposts as $post ) : setup_postdata( $post );

            $lastCol          = '';
            ob_start();
            comments_number( __( 'No Comments', 'wiz' ), __( 'One Comment', 'wiz' ), '% ' . __( 'Comments', 'wiz' ) );
            $comments_details = ob_get_contents();
            ob_end_clean();

            $format = get_post_format( get_the_ID() );
            if ( false === $format )
                $format = 'standard';

            $html .= '<div class="' . leap_bws_col_class( $col_num ) . '">';
            $html .= '<div class="leap-post-entry post-' . $format . ' ' . $antimation_class . '" ' . $antimation . '>
            <div class="leap-post-details">
            <div class="post-type"><a class="item-icon" href="' . get_permalink() . '"></a></div>
			<div class="leap-date">
				<small class="sc-recent-posts-date-day small">' . get_the_time( 'd' ) . '</small>
				<small class="sc-recent-posts-date-month small">' . get_the_time( 'M' ) . '</small>
			</div>
            </div>
			<div class="leap-content">
				<div class="sc-rposts-title-comment">
					<h6 class="post-title"><a href="' . get_permalink() . '">' . get_the_title() . '</a></h6>
					<span class="post-comment"><a class="comments" href="' . get_comments_link() . '"><small class="small">' . $comments_details . '</small></a></span>
				</div>
				<div class="sc-rposts-image-content">';
            $html .= '<div class="sc-rposts-content">
						' . leap_get_the_excerpt(null, $excerptlength) . '';

            $readmore_link = ' <div class="more"><a class="more-link" href="' . get_permalink( get_the_ID() ) . '"><span>' . __( 'Read More', 'leap-port' ) . '</span></a></div>';
            if ( $readmore == 'yes' ) {
                $html .= $readmore_link;
            }

            $html .= '</div>
					
				</div>
			</div>
			</div>
			</div>';
            if ( $i % $columns == 0 ) {
                $html .= '</div><div class="row">';
            }
            $i++;
        endforeach;
        $html .= '</div></div>';
    } elseif ( $style == 'style-3' ) {
        $html .= '<div class="sc-rposts ' . $style . '">';
        $i = 1;
        $html .= '<div class="row">';
        foreach ( $myposts as $post ) : setup_postdata( $post );

            ob_start();
            comments_number( __( 'No Comments', 'wiz' ), __( 'One Comment', 'wiz' ), '% ' . __( 'Comments', 'wiz' ) );
            $comments_details = ob_get_contents();
            ob_end_clean();

            $format = get_post_format( get_the_ID() );
            if ( false === $format )
                $format = 'standard';

            $html .= '<div class="' . leap_bws_col_class( $col_num ) . '">';
            $html .= '<div class="leap-post-entry post-' . $format . ' ' . $antimation_class . '" ' . $antimation . '>';
            if ( has_post_thumbnail() ) {
                $html .= '<div class="leap-overlay item-img one">
                            ' . get_the_post_thumbnail( get_the_ID(), 'leap-portfolio-1col' ) . '
                            
                            <div class="item-overlay">
                            <div class="item-img-color"></div>
                            <div class="item-details">
                            <div class="item-links">
                            <a class="item-icon" href="' . get_permalink() . '"></a>
                            </div>
                            </div>
                            </div>
                        </div>';
            }
            $html .= '<div class="sc-rposts-title-comment">
					<h6 class="post-title"><a href="' . get_permalink() . '">' . get_the_title() . '</a></h6>
					<small class="date small">' . get_the_date() . '</small>
                    <small class="separator small">|</small>
					<span class="post-comment"><a class="comments" href="' . get_comments_link() . '"><small class="small">' . $comments_details . '</small></a></span>
				</div>
				<div class="sc-rposts-image-content">
					<div class="sc-rposts-content">
						' . leap_get_the_excerpt(null, $excerptlength) . '';


            $readmore_link = ' <div class="more"><a class="more-link" href="' . get_permalink( get_the_ID() ) . '"><span>' . __( 'Read More', 'leap-port' ) . '</span></a></div>';
            if ( $readmore == 'yes' ) {
                $html .= $readmore_link;
            }

            $html .='</div>
					
				</div>
			</div>
			</div>';
            if ( $i % $columns == 0 ) {
                $html .= '</div><div class="row">';
            }
            $i++;
        endforeach;
        $html .='</div></div>';
    } elseif ( $style == 'style-4' ) {
        $html .='<div class="sc-rposts ' . $style . '">';
        $i = 1;
        $html .= '<div class="row">';
        foreach ( $myposts as $post ) : setup_postdata( $post );

            ob_start();
            comments_number( __( 'No Comments', 'wiz' ), __( 'One Comment', 'wiz' ), '% ' . __( 'Comments', 'wiz' ) );
            $comments_details = ob_get_contents();
            ob_end_clean();

            $format = get_post_format( get_the_ID() );
            if ( false === $format )
                $format = 'standard';

            $html .= '<div class="' . leap_bws_col_class( $col_num ) . '">';
            $html .='<div class="leap-post-entry post-' . $format . ' ' . $antimation_class . '" ' . $antimation . '>';
            if ( has_post_thumbnail() ) {
                $html .= '<div class="leap-overlay item-img one">
                            ' . get_the_post_thumbnail( get_the_ID(), 'leap-image-100x100' ) . '
                            
                            <div class="item-overlay">
                            <div class="item-img-color"></div>
                            <div class="item-details">
                            <div class="item-links">
                            <a class="item-icon" href="' . get_permalink() . '"></a>
                            </div>
                            </div>
                            </div>
                        </div>';
            }
            $html .='<div class="sc-rposts-container">
                    <div class="sc-rposts-title-comment">
					<h6 class="post-title"><a href="' . get_permalink() . '">' . get_the_title() . '</a></h6>
					<small class="date small">' . get_the_date() . '</small>
                    <small class="separator small">|</small>
					<span class="post-comment"><a class="comments" href="' . get_comments_link() . '"><small class="small">' . $comments_details . '</small></a></span>
				</div>
				<div class="sc-rposts-image-content">
					<div class="sc-rposts-content">
						' . leap_get_the_excerpt(null, $excerptlength) . '';
            $readmore_link = ' <div class="more"><a class="more-link" href="' . get_permalink( get_the_ID() ) . '"><span>' . __( 'Read More', 'leap-port' ) . '</span></a></div>';
            if ( $readmore == 'yes' ) {
                $html .= $readmore_link;
            }

            $html .='</div>
					
				</div>
                </div>
			</div>
			</div>';
            if ( $i % $columns == 0 ) {
                $html .= '</div><div class="row">';
            }
            $i++;
        endforeach;
        $html .='</div></div>';
    }

    $html .='</div>';

    $leap_rcent_posts_counter++;

    //$orig_post = $post;
    $post = $orig_post;

    return $html;
}

add_shortcode( 'leap_recentposts', 'leap_shortcode_recent_posts' );

//////////////////////////////////////////////////////////////////
// Iframe shortcode
//////////////////////////////////////////////////////////////////
function leap_shortcode_iframe( $atts, $content = null ) {
    extract( shortcode_atts( array(
        'width'       => '500px',
        'height'      => '300px',
        'frameborder' => 0,
        'scrolling'   => 'no',
        'url'         => '#',
    ), $atts ) );

    $css_styles = '';

    if ( $frameborder != 1 ) {
        $css_styles .= 'border:none;';
    }

    if ( $scrolling == 'no' ) {
        $css_styles .= 'overflow:hidden;';
    }

    return '<iframe src="' . $url . '" style="width:' . $width . '; height:' . $height . '; ' . $css_styles . '"></iframe>';
}

add_shortcode( 'leap_iframe', 'leap_shortcode_iframe' );

//////////////////////////////////////////////////////////////////
// Iframe shortcode
//////////////////////////////////////////////////////////////////
function leap_shortcode_lightbox( $atts, $content = null ) {
    extract( shortcode_atts( array(
        'url'   => '',
        'title' => '',
    ), $atts ) );

    return '<a href="' . $url . '" data-rel="prettyPhoto" title="' . $title . '">' . do_shortcode( $content ) . '</a>';
}

add_shortcode( 'leap_lightbox', 'leap_shortcode_lightbox' );

//////////////////////////////////////////////////////////////////
// Title shortcode
//////////////////////////////////////////////////////////////////
function leap_shortcode_title( $atts, $content = null ) {
    extract( shortcode_atts( array(
        'heading'           => '',
        'align'            => 'none',
        'font_family'        => '',
        'font_size'         => '',
        'line_height'       => '',
        'color'            => '',
        'background_color'     => '',
        'border_color'       => '',
        'style'              => 'style1',
        'strip'              => 'yes',
        'strip_height'         => '',
        'image'              => '',
        'icon'               => '',
        'margin_top'         => '',
        'margin_bottom'      => '',
        'style8_strip_height'  => '',
        'style8_strip_width'  => '',
        'style8_strip_color'  => '',
        'style8_strip_align'  => '',
        'style8_strip_top_spacing'  => '',
        'style8_strip_bottom_spacing'  => ''
    ), $atts ) );

    $id = uniqid();
    
    if ( empty( $heading ) ) {
        $heading = 'h2';
    }

    if ( empty( $style ) ) {
        $title_style = 'style1';
    } else {
        $title_style = $style;
    }

    if ( !empty( $icon ) ) {
        $icon = '<i class="'. ' fa fa-' . $icon . '"></i>';

    }

    if ( is_numeric( $font_size ) ) {
        $font_size = $font_size . 'px';
    }

    if ( is_numeric( $line_height ) ) {
        $line_height = $line_height . 'px';
    }

    if ( is_numeric( $margin_top ) ) {
        $margin_top = $margin_top . 'px';
    }
    
    if ( is_numeric( $style8_strip_height ) ) {
        $style8_strip_height = $style8_strip_height . 'px';
    }
    
    if ( is_numeric( $style8_strip_width ) ) {
        $style8_strip_width = $style8_strip_width . 'px';
    }
    
    if ( is_numeric( $style8_strip_top_spacing ) ) {
        $style8_strip_top_spacing = $style8_strip_top_spacing . 'px';
    }
    
    if ( is_numeric( $style8_strip_bottom_spacing ) ) {
        $style8_strip_bottom_spacing = $style8_strip_bottom_spacing . 'px';
    }
    
    if ( $align == 'right' ) {
        $align = 'alignright';
    } elseif ( $align == 'left' ) {
        $align = 'alignleft';
    } elseif ( $align == 'center' ) {
        $align = 'title-center';
    } else {
        $align = 'alignnone';
    }
    
    if ( $style8_strip_align == 'right' ) {
        $style8_strip_align = 'alignright';
    } elseif ( $style8_strip_align == 'left' ) {
        $style8_strip_align = 'alignleft';
    } elseif ( $style8_strip_align == 'center' ) {
        $style8_strip_align = 'title-center';
    } else {
        $style8_strip_align = 'alignnone';
    }

    if ( empty( $margin_bottom ) ) {
        $margin_bottom = '25px';
    }
    
    if ( is_numeric( $margin_bottom ) ) {
        $margin_bottom = $margin_bottom . 'px';
    }

    $css_style = '<style type="text/css" scoped>';

    $css_style .= 'div#title-' . $id . ' ' . $heading . ' {';

    if ( !empty( $font_family ) ) {
        $css_style .= 'font-family:' . leap_get_font_family($font_family) . ';';
    }

    if ( !empty( $font_size ) ) {
        $css_style .= 'font-size:' . $font_size . ';';
    }

    if ( !empty( $line_height ) ) {
        $css_style .= 'line-height:' . $line_height . ';';
    }

    if ( !empty( $color ) ) {
        $css_style .= 'color:' . $color . ';';
    }

    if ( !empty( $background_color ) ) {
        $css_style .= 'background-color:' . $background_color . ';';
    }

    $css_style .= '}';

    $css_style .= 'div#title-' . $id . ' {';

    if ( !empty( $border_color ) ) {
        $css_style .= 'border-color:' . $border_color . ';';
    }

    if ( !empty( $margin_top ) ) {
        $css_style .= 'margin-top:' . $margin_top . ';';
    }

    if ( !empty( $margin_bottom ) ) {
        $css_style .= 'margin-bottom:' . $margin_bottom . ';';
    }

    $css_style .= '}';
    $css_style .= 'div#title-' . $id . '.title-strip .title-heading:after {';

    if ( !empty( $strip_height ) ) {
        $css_style .= 'height:' . $strip_height . ';';
    }

    $css_style .= '}';
    
    
    $css_style .= 'div#title-' . $id . ' .strip {';
    if ( !empty( $style8_strip_height ) ) {
        $css_style .= 'height:' . $style8_strip_height . ';';
    }
    
    if ( !empty( $style8_strip_top_spacing ) ) {
        $css_style .= 'margin-top:' . $style8_strip_top_spacing . ';';
    }
    
    if ( !empty( $style8_strip_bottom_spacing ) ) {
        $css_style .= 'margin-bottom:' . $style8_strip_bottom_spacing . ';';
    }
    $css_style .= '}';
    
    $css_style .= 'div#title-' . $id . ' .strip:before {';
    if ( !empty( $style8_strip_height ) ) {
        $css_style .= 'height:' . $style8_strip_height . ';';
    }
    
    if ( !empty( $style8_strip_width ) ) {
        $css_style .= 'width:' . $style8_strip_width . ';';
    }
    
    if ( !empty( $style8_strip_color ) ) {
        $css_style .= 'background-color:' . $style8_strip_color . ';';
    }
    
    $css_style .= '}';
    
    
    

    $strip_class = 'no-strip';
    if ( ($strip == 'yes') && ( $title_style == 'style1' ) ) {
        $strip_class = 'title-strip';
    }


    if ( is_numeric( $image ) ) {
        $attachment_id    = absint( $image );
        $image_attributes = wp_get_attachment_image_src( $attachment_id, 'full' );
        $image            = $image_attributes[ 0 ];
    }


    if ( !empty( $image ) && ( $strip == 'yes' ) && ( $title_style == 'style1' ) ) {
        $css_style .= 'div#title-' . $id . '.title-strip .title-heading:after, div#title-' . $id . '.title-strip.title-center .title-heading:before, div#title-' . $id . '.title-strip.title-center .title-heading:after {';
        $css_style .= 'background-image:url("' . $image . '");';
        $css_style .= '}';
    }

    $css_style .= '</style>';


    $str = $css_style;
    $str .= '<div id="title-' . $id . '" class="title title-' . $title_style . ' ' . $align . ' ' . $strip_class . '">';
    $str .= '<' . $heading . ' class="title-heading">';
    if ( $style == 'style8' ):
        $str .= '<span class="strip ' . $style8_strip_align .'"></span>';
    endif;
    $str .= '' . $icon . ' ' . do_shortcode( $content ) . '';
    $str .= '</' . $heading . '>';
    $str .= '</div>';
    return $str;
}

add_shortcode( 'leap_title', 'leap_shortcode_title' );

## Tabs -------------------------------------------------- #

function leap_shortcode_tabs( $atts, $content = null ) {
    extract( shortcode_atts( array(
        'type'  => 'horizontal',
        'style' => 'style-1'
    ), $atts ) );

    $out = '<div class="leap-sc-tabs ' . $type . ' ' . $style . '">' . do_shortcode( $content ) . '</div>';
    return $out;
}

add_shortcode( 'leap_tabs', 'leap_shortcode_tabs' );

## Tab Head -------------------------------------------------- #

function leap_shortcode_tabs_head( $atts, $content = null ) {
    return '<ul class="leap-tabs-titles">' . do_shortcode( $content ) . '</ul>';
}

add_shortcode( 'leap_tabs_head', 'leap_shortcode_tabs_head' );

## Tab_title -------------------------------------------------- #

function leap_shortcode_tab_title( $atts, $content = null ) {
    return '<li><a href="#">' . do_shortcode( $content ) . '</a></li>';
}

add_shortcode( 'leap_tab_title', 'leap_shortcode_tab_title' );

## Tabs -------------------------------------------------- #

function leap_shortcode_tabs_container( $atts, $content = null ) {
    return '' . do_shortcode( $content ) . '';
}

add_shortcode( 'leap_tabs_container', 'leap_shortcode_tabs_container' );

## Tab -------------------------------------------------- #

function leap_shortcode_tab( $atts, $content = null ) {
    return '<div>' . do_shortcode( $content ) . '</div>';
}

add_shortcode( 'leap_tab', 'leap_shortcode_tab' );

//////////////////////////////////////////////////////////////////
// QR Code shortcode
//////////////////////////////////////////////////////////////////
function leap_shortcode_qr( $atts, $content = null ) {
    extract( shortcode_atts( array(
        'text'  => 'Text goes here...',
        'width' => 100,
    ), $atts ) );

    return '<img class="leap-qr-image" src="//chart.googleapis.com/chart?chl=' . urlencode( $text ) . '&amp;chs=' . $width . '&amp;cht=qr&amp;choe=UTF-8&amp;chld=L%7C0" alt="" />';
}

add_shortcode( 'leap_qr', 'leap_shortcode_qr' );

//////////////////////////////////////////////////////////////////
// Separators shortcode
//////////////////////////////////////////////////////////////////
function leap_shortcode_separator( $atts, $content = null ) {
    extract( shortcode_atts( array(
        'style'        => 'solid',
        'color'        => '',
        'width'        => '80%',
        'margintop'    => '',
        'marginbottom' => ''
    ), $atts ) );
    $id = uniqid();

    $css_styles = '
		<style type="text/css" scoped>
		#leap-separator-' . $id . '.leap-separator span {
			border-color: ' . $color . ';
			width: ' . $width . ';
		}
		#leap-separator-' . $id . '.leap-separator {
			margin-top: ' . $margintop . ';
			margin-bottom: ' . $marginbottom . ';
		}
		#leap-separator-' . $id . '.leap-top-shadow span:before {
			webkit-box-shadow: 0 0 11px ' . $color . ';
			moz-box-shadow: 0 0 11px ' . $color . ';
			box-shadow: 0 0 11px ' . $color . ';
		}
		#leap-separator-' . $id . '.leap-bottom-shadow span:before {
			webkit-box-shadow: 0 0 11px ' . $color . ';
			moz-box-shadow: 0 0 11px ' . $color . ';
			box-shadow: 0 0 11px ' . $color . ';
		}
		</style>
		';

    $html = '<div id="leap-separator-' . $id . '" class="leap-separator leap-' . $style . '">' . $css_styles . '<span></span></div>';
    return $html;
}

add_shortcode( 'leap_separator', 'leap_shortcode_separator' );

//////////////////////////////////////////////////////////////////
// Tooltip shortcode
//////////////////////////////////////////////////////////////////
function leap_shortcode_tooltip( $atts, $content = null ) {
    extract( shortcode_atts( array(
        'text'      => 'Text goes here...',
        'placement' => 'top'
    ), $atts ) );

    if ( empty( $text ) ) {
        $text = 'Text goes here...';
    }

    if ( empty( $placement ) ) {
        $placement = 'top';
    }

    return '<a href="javascript:void(0)" data-toggle="tooltip" data-placement="' . $placement . '" data-original-title="' . $text . '">' . do_shortcode( $content ) . '</a>';
}

add_shortcode( 'leap_tooltip', 'leap_shortcode_tooltip' );

//////////////////////////////////////////////////////////////////
// Testimonials
//////////////////////////////////////////////////////////////////
function leap_shortcode_testimonials( $atts, $content = null ) {
    extract( shortcode_atts( array(
        'backgroundcolor' => '',
        'bordercolor'     => '',
        'namecolor'       => '',
        'companycolor'    => '',
        'controls'        => 'yes',
        'timeout'        => '4000'
    ), $atts ) );

    $id = uniqid();

    $str = '';
    
    if( empty($timeout) ) {
        $timeout = '4000';
    }

    $css_styles = '
	<style type="text/css" scoped>
		#testimonials-' . $id . ' .testimonials .testimonial .testimonial-content:before {
			border-top-color: ' . $bordercolor . ';
		}
		#testimonials-' . $id . ' .testimonials .testimonial .testimonial-content {
			border-color: ' . $bordercolor . ';
			background-color: ' . $backgroundcolor . ';
		}
		#testimonials-' . $id . ' .testimonials .testimonial .testimonial-content:after {
			border-top-color: ' . $backgroundcolor . ';
		}
		#testimonials-' . $id . ' .testimonials .testimonial .company-details .person-name {
			color: ' . $namecolor . ';
		}
		#testimonials-' . $id . ' .testimonials .testimonial .company-details small.small  {
			color: ' . $companycolor . ';
		}
	</style>
	';

    $str .= '<div id="testimonials-' . $id . '" class="leap-testimonials" data-timeout="' . $timeout . '">';
    $str .= $css_styles;
    $str .= '<div class="testimonials">';
    $str .= do_shortcode( $content );
    $str .= '</div>';
    if ( $controls == 'yes' ):
        $str .= '<div class="controls"><a class="prev" href="javascript:void(0)">' . __( "Previous", "LeapPort" ) . '</a><span></span><a class="next" href="javascript:void(0)">' . __( "Next", "LeapPort" ) . '</a></div>';
    endif;
    $str .= '</div>';
    return $str;
}

add_shortcode( 'leap_testimonials', 'leap_shortcode_testimonials' );

//////////////////////////////////////////////////////////////////
// Testimonial
//////////////////////////////////////////////////////////////////
function leap_shortcode_testimonial( $atts, $content = null ) {
    extract( shortcode_atts( array(
        'image'   => 'http://placehold.it/75x75',
        'size'    => '75x75',
        'name'    => 'My Name',
        'company' => '',
        'link'    => '#',
        'target'  => '_blank',
    ), $atts ) );

    if ( empty( $size ) ) {
        $size = '75x75';
    }

    $size_x = stripos( $size, 'x' );
    if ( $size_x !== false ) {
        $size         = explode( 'x', $size );
        $image_width  = ( empty( $size[ 0 ] ) ) ? 0 : (int) $size[ 0 ];
        $image_height = ( empty( $size[ 1 ] ) ) ? 0 : (int) $size[ 1 ];
    } else {
        $image_width  = ( empty( $size[ 0 ] ) ) ? 0 : (int) $size[ 0 ];
        $image_height = ( empty( $size[ 1 ] ) ) ? 0 : (int) $size[ 1 ];
    }

    if ( is_numeric( $image ) ) {
        $attachment_id    = absint( $image );
        $image_attributes = wp_get_attachment_image_src( $attachment_id, $size );
        $image            = $image_attributes[ 0 ];
    }

    $str = '<div class="testimonial">';
    $str .= '<div class="testimonial-content">';
    $str .= do_shortcode( '' . $content . '' );
    $str .= '</div>';
    if ( !empty( $name ) ):
        $str .= '<div class="company-details">';
        if ( !empty( $image ) ) :
            $str .= '<div class="person-image"><img alt="' . esc_attr( $name ) . '" src="' . esc_url( $image ) . '" width="' . $image_width . '" height="' . $image_height . '" /></div>';
        endif;
        $str .= '<div class="person-details">';
        $str .= '<h4 class="person-name">' . esc_html( $name ) . '</h4>';
        if ( !empty( $company ) ) {
            if ( !empty( $link ) ) {
                $str .= '<a href="' . esc_url( $link ) . '" target="' . esc_attr( $target ) . '">';
            }
            $str .= '<small class="small">' . esc_html( $company ) . '</small>';
            if ( !empty( $link ) ) {
                $str .= '</a>';
            }
        }
        $str .= '</div>';
        $str .= '</div>';
    endif;
    $str .= '</div>';

    return $str;
}

add_shortcode( 'leap_testimonial', 'leap_shortcode_testimonial' );
//////////////////////////////////////////////////////////////////
// Testimonial 2
//////////////////////////////////////////////////////////////////
function leap_shortcode_testimonials_2( $atts, $content = null ) {
    $atts = shortcode_atts( array(
        'image'                      => 'http://placehold.it/75x75',
        'size'                       => '75x75',
        'person_image_shape'         => 'circle',
        'image_border_width'         => '',
        'image_border_color'         => '',
        'name'                       => '',
        'company'                    => '',
        'link'                       => '#',
        'linktarget'                     => '_blank',
        'testimonial_margin_left'    => '',
        'testimonial_margin_right'   => '',
        'quote_icons_size'           => '',
        'quote_icons_color'          => '',
        'person_name_font_family'    => '',
        'person_name_heading'        => 'h4',
        'person_name_color'          => '',
        'company_name_font_family'   => '',
        'company_name_size'          => '',
        'separator_color'            => '',
        'company_name_color'         => ''
    ), $atts );
    
    static $counter = 1;

    if ( empty( $atts['size'] ) ) {
        $atts['size'] = '75x75';
    } 
    
    $size_x = stripos( $atts['size'], 'x' );
    $attachment_id    = absint( $atts['image'] );
    $image_attributes = wp_get_attachment_image_src( $attachment_id, $atts['size'] );
    if ( $size_x !== false ) {
        $size         = explode( 'x', $atts['size'] );
        $image_width  = ( empty( $size[ 0 ] ) ) ? 0 : (int) $size[ 0 ];
        $image_height = ( empty( $size[ 1 ] ) ) ? 0 : (int) $size[ 1 ];
    } else {
        $image_width  = $image_attributes[ 1 ];
        $image_height = $image_attributes[ 2 ];
    }
 
    if ( is_numeric( $atts['image'] ) ) {
        $attachment_id    = absint( $atts['image'] );
        $image_attributes = wp_get_attachment_image_src( $attachment_id, $atts['size'] );
        $image            = $image_attributes[ 0 ];
    }
    
    if ( is_numeric( $atts['image_border_width'] ) ) {
        $atts['image_border_width'] = $atts['image_border_width'] . 'px';
    }
    
    if ( is_numeric( $atts['quote_icons_size'] ) ) {
        $atts['quote_icons_size'] = $atts['quote_icons_size'] . 'px';
    }
    
    if ( is_numeric( $atts['company_name_size'] ) ) {
        $atts['company_name_size'] = $atts['company_name_size'] . 'px';
    }
    
    if ( is_numeric( $atts['testimonial_margin_right'] ) ) {
        $atts['testimonial_margin_right'] = $atts['testimonial_margin_right'] . 'px';
    }
    
    if ( is_numeric( $atts['testimonial_margin_left'] ) ) {
        $atts['testimonial_margin_left'] = $atts['testimonial_margin_left'] . 'px';
    }
   
    
    $css_style = '<style type="text/css" scoped>' . "\n";  
        $css_style .= '#testimonials2-' . $counter . ' .testimonial-text {' . "\n";
        if ( !empty( $atts['testimonial_margin_left'] ) ) {
            $css_style .= 'margin-left:' . $atts['testimonial_margin_left'] . ';' . "\n";
        }
        if ( !empty( $atts['testimonial_margin_right'] ) ) {
            $css_style .= 'margin-right:' . $atts['testimonial_margin_right'] . ';' . "\n";
        }
        $css_style .= '}' . "\n";
        $css_style .= '#testimonials2-' . $counter . ' .testimonial-text-container > .fa {' . "\n";
        if ( !empty( $atts['quote_icons_size'] ) ) {
            $css_style .= 'font-size:' . $atts['quote_icons_size'] . ';' . "\n";
        }
        if ( !empty( $atts['quote_icons_color'] ) ) {
            $css_style .= 'color:' . $atts['quote_icons_color'] . ';' . "\n";
        }
        $css_style .= '}' . "\n";
        $css_style .= '#testimonials2-' . $counter . ' .person-name {' . "\n";
        if ( !empty( $atts['person_name_font_family'] ) ) {
            $css_style .= 'font-family:' . leap_get_font_family($atts['person_name_font_family']) . ';' . "\n";
        }
        if ( !empty( $atts['person_name_color'] ) ) {
            $css_style .= 'color:' . $atts['person_name_color'] . ';' . "\n";
        }
        $css_style .= '}' . "\n";
        $css_style .= '#testimonials2-' . $counter . ' .company-name {' . "\n";
        if ( !empty( $atts['company_name_font_family'] ) ) {
            $css_style .= 'font-family:' . leap_get_font_family($atts['company_name_font_family']) . ';' . "\n";
        }
        if ( !empty( $atts['company_name_size'] ) ) {
            $css_style .= 'font-size:' . $atts['company_name_size'] . ';' . "\n";
        }
        if ( !empty( $atts['company_name_color'] ) ) {
            $css_style .= 'color:' . $atts['company_name_color'] . ';' . "\n";
        }
        $css_style .= '}' . "\n";
        
        $css_style .= '#testimonials2-' . $counter . ' .person-image img {' . "\n";
        if ( !empty( $atts['image_border_color'] ) ) {
            $css_style .= 'border-color:' . $atts['image_border_color'] . ';' . "\n";
        }
        if ( !empty( $atts['image_border_width'] ) ) {
            $css_style .= 'border-width:' . $atts['image_border_width'] . ';' . "\n";
        }
        $css_style .= '}' . "\n";
        $css_style .= '#testimonials2-' . $counter . ' .person-details .sep {' . "\n";
        if ( !empty( $atts['separator_color'] ) ) {
            $css_style .= 'background-color:' . $atts['separator_color'] . ';' . "\n";
        }
        $css_style .= '}' . "\n";  
	$css_style .= '</style>';
            
            


    $str = "<div id='testimonials2-{$counter}' class='leap-testimonials-2' >{$css_style}
    <div class='testimonial'>";
        if ( !empty( $image ) ) {
            $str .= "<div class='person-image'><img class='" . esc_attr($atts['person_image_shape']) . "' alt='" . esc_attr($atts['name']) . "' src='" . esc_url( $image ) . "' width='{$image_width}' height='{$image_height}' />
                </div>";
        }
        $str .= "<div class='testimonial-text-container'> 
            <i class='fa fa-quote-left'> </i>
            <div class='testimonial-text'>" . do_shortcode($content) . "</div>
            <i class='fa fa-quote-right'> </i>
        </div>
        <div class='person-details'>
        
            <div class='inner-details'> ";
                if ( !empty($atts['name'])  ) {
                    $str .= "<{$atts['person_name_heading']} class='person-name'>" . ($atts['name']) . "</{$atts['person_name_heading']}>";
                }
                if ( !empty($atts['name']) && !empty($atts['company']) ) {
                    $str .= "<span class='sep'></span>";
                }
                if ( !empty($atts['company']) ) {
                    if ( !empty($atts['link']) ) {
                        $str .= "<a href='" . esc_url($atts['link']) . "' target='" . esc_attr($atts['linktarget']) . "'>";
                }
                    $str .= "<span class='company-name'>" . esc_html($atts['company']) . "</span>";
                    if ( !empty($atts['link']) ) {
                       $str .= "</a>";
                }
                }
              
    $str .= "</div>
    </div>
    </div>
    </div>";
    
    $counter++;
    
    return $str;
    
    }
    
add_shortcode( 'leap_testimonials_2', 'leap_shortcode_testimonials_2' );

//////////////////////////////////////////////////////////////////
// Progress bars shortcode
//////////////////////////////////////////////////////////////////
function leap_shortcode_progress_bar( $atts, $content = null ) {
    extract( shortcode_atts( array(
        'color'      => '#337ab7',
        'labelcolor' => '#ffffff',
        'height'     => '20px',
        'bgcolor'    => '#f5f5f5',
        'striped'    => '',
        'animated'   => '',
        'percentage' => '25',
        'label'      => ''
    ), $atts ) );


    if ( $striped == 'yes' ) {
        $striped = 'progress-bar-striped';
    }

    if ( $animated == 'yes' ) {
        $animated = 'active';
    }

    $str = '';

    $id = uniqid();

    $css_style = '<style type="text/css" scoped>
		#prog-' . $id . ' .progress-bar {
			background-color: ' . esc_attr( $color ) . ';
			line-height: ' . esc_attr( $height ) . ';
			color: ' . esc_attr( $labelcolor ) . ';
		}
		#prog-' . $id . '.progress {
			background-color: ' . esc_attr( $bgcolor ) . ';
			height: ' . esc_attr( $height ) . ';
		}
	</style>';

    $str .= '<div id="prog-' . $id . '" class="leap-progress progress">';
    $str .= $css_style;
    $str .= '	<div class="progress-bar ' . esc_attr( $striped ) . ' ' . esc_attr( $animated ) . '"  role="progressbar" aria-valuenow="' . esc_attr( $percentage ) . '" aria-valuemin="0" aria-valuemax="100" style="width: ' . esc_attr( $percentage ) . '%">';
    $str .= esc_html( $label );
    $str .= '	</div>';
    $str .= '</div>';

    return $str;
}

add_shortcode( 'leap_progress_bar', 'leap_shortcode_progress_bar' );

//////////////////////////////////////////////////////////////////
// Alert Boxes shortcode
//////////////////////////////////////////////////////////////////
function leap_shortcode_alert_box( $atts, $content = null ) {
    extract( shortcode_atts( array(
        'type'  => 'alert-warning',
        'icon'  => 'yes',
        'close' => 'yes',
        'title' => 'Title Goes here',
    ), $atts ) );

    $icon_class = 'alert-icon-no';
    if ( $icon == 'yes' ) {
        $icon_class = 'alert-icon-yes';
    }

    $str = '<div class="alert ' . $type . ' alert-block ' . $icon_class . '"  role="alert">';
    if ( $close == 'yes' ) {
        $str .= '<button type="button" class="close" data-dismiss="alert">&times;</button>';
    }
    if ( $icon == 'yes' ) {
        $str .= '<div class="icon"></div>';
    }
    $str .= '<h4>' . $title . '</h4>';
    $str .= '<div class ="alert-message">';
    $str .= do_shortcode( $content );
    $str .= '</div>';
    $str .= '</div>';

    return $str;
}

add_shortcode( 'leap_alert_box', 'leap_shortcode_alert_box' );

//////////////////////////////////////////////////////////////////
// FontAwesome Icons
//////////////////////////////////////////////////////////////////
function leap_shortcode_fontawesome( $atts, $content = null ) {
    extract( shortcode_atts( array(
        'icon'            => 'chevron-right',
        'type'            => 'normal',
        'size'            => 'normal',
        'iconcolor'       => '',
        'backgroundcolor' => '',
        'bordercolor'     => '',
    ), $atts ) );


    if ( $type == 'circle' ) {
        $type = 'fa-circle';
    } elseif ( $type == 'square' ) {
        $type = 'fa-stop';
    } elseif ( $type == 'rounded' ) {
        $type = 'fa-square';
    } else {
        $type = 'normal';
    }

    if ( empty( $size ) || ($size == 'normal') ) {
        $size = '';
    } else {
        $size = 'fa-' . $size;
    }

    $iconcolor_style = '';
    if ( $iconcolor ) {
        $iconcolor_style = 'color:' . $iconcolor . ' !important;';
    }

    if ( $type == 'normal' ) {
        $html = '<i style="' . $iconcolor_style . ' " class="leap-fa-icon fa fa-' . $icon . ' ' . $size . '"></i>';
    } else {
        $type_style = 'color:' . $backgroundcolor . ' !important; text-shadow:-1px 0 ' . $bordercolor . ', 0 1px ' . $bordercolor . ', 1px 0 ' . $bordercolor . ', 0 -1px ' . $bordercolor . ' !important;';
        $html       = '<span class="fa-stack ' . $size . '"><i style="' . $type_style . '"  class="fa ' . $type . ' fa-stack-2x"></i><i style="' . $iconcolor_style . '" class="fa fa-' . $icon . ' fa-stack-1x"></i></span>';
    }

    return $html;
}

add_shortcode( 'leap_fontawesome', 'leap_shortcode_fontawesome' );

//////////////////////////////////////////////////////////////////
// Person
//////////////////////////////////////////////////////////////////
function leap_shortcode_person( $atts, $content = null ) {
    extract( shortcode_atts( array(
        'name'       => '',
        'namecolor'  => '',
        'picture'    => '',
        'size'       => '75x75',
        'type'       => 'polaroid',
        'title'      => '',
        'titlecolor' => '',
        'facebook'   => '',
        'twitter'    => '',
        'linkedin'   => '',
        'dribbble'   => '',
        'googlep'    => '',
        'email'      => '',
        'linktarget' => '_self',
        'center'     => 'no'
    ), $atts ) );

    if ( empty( $type ) ) {
        $type = 'polaroid';
    }

    if ( empty( $linktarget ) ) {
        $linktarget = '_self';
    }

    if ( empty( $size ) ) {
        $size = '75x75';
    }

    $size_x = stripos( $size, 'x' );
    if ( $size_x !== false ) {
        $size         = explode( 'x', $size );
        $image_width  = ( empty( $size[ 0 ] ) ) ? 0 : (int) $size[ 0 ];
        $image_height = ( empty( $size[ 1 ] ) ) ? 0 : (int) $size[ 1 ];
    } else {
        $image_width  = $image_attributes[ 1 ];
        $image_height = $image_attributes[ 2 ];
    }

    if ( is_numeric( $picture ) ) {
        $attachment_id    = absint( $picture );
        $image_attributes = wp_get_attachment_image_src( $attachment_id, $size );
        $picture          = $image_attributes[ 0 ];
    }

    $person_center = '';
    if ( $center == 'yes' ) {
        $person_center = 'text-center';
    }

    $id = uniqid();

    $str = '';

    $css_styles = '
	<style type="text/css" scoped>
		#person-' . $id . '.person .person-name {
			color: ' . $namecolor . ';
		}
		#person-' . $id . '.person .person-title {
			color: ' . $titlecolor . ';
		}
	</style>
	';


    $str .= '<div id="person-' . $id . '" class="person ' . $person_center . '">';
    $str .= $css_styles;
    if ( $picture ) {
        $str .= '<div class="person-img-icons img-' . $type . '">';
        $str .= '<img class="person-img img-' . $type . '" src="' . $picture . '" alt="' . $name . '" width="" height="" />';
        if ( $facebook || $twitter || $linkedin || $dribbble || $googlep || $email ) {
            $str .= '<div class="person-social-container">';
            $str .= '<div class="person-social-icons">';
            if ( $facebook ) {
                $str .= '<span class="social-icon"><a title="FaceBook" href="' . $facebook . '" target="' . $linktarget . '" class="leap-tooltip facebook">Facebook</a></span>';
            }
            if ( $twitter ) {
                $str .= '<span class="social-icon"><a title="Twitter" href="' . $twitter . '" target="' . $linktarget . '" class="leap-tooltip twitter">Twitter</a></span>';
            }
            if ( $linkedin ) {
                $str .= '<span class="social-icon"><a title="LinkedIn" href="' . $linkedin . '" target="' . $linktarget . '" class="leap-tooltip linkedin">LinkedIn</a></span>';
            }
            if ( $dribbble ) {
                $str .= '<span class="social-icon"><a title="Dribbble" href="' . $dribbble . '" target="' . $linktarget . '" class="leap-tooltip dribbble">Dribbble</a></span>';
            }
            if ( $googlep ) {
                $str .= '<span class="social-icon"><a title="Google Plus" href="' . $googlep . '" target="' . $linktarget . '" class="leap-tooltip googleplus">Google Plus</a></span>';
            }
            if ( $email ) {
                $str .= '<span class="social-icon"><a title="Email" href="mailto:' . $email . '" class="leap-tooltip email">Email</a></span>';
            }
            $str .= '</div>';
            $str .= '</div>';
        }
        $str .= '</div>';
    } else {
        $str .= '<div class="person-social-icons no-image">';
        if ( $facebook ) {
            $str .= '<span class="social-icon"><a title="FaceBook" href="' . $facebook . '" target="' . $linktarget . '" class="leap-tooltip facebook">Facebook</a></span>';
        }
        if ( $twitter ) {
            $str .= '<span class="social-icon"><a title="Twitter" href="' . $twitter . '" target="' . $linktarget . '" class="leap-tooltip twitter">Twitter</a></span>';
        }
        if ( $linkedin ) {
            $str .= '<span class="social-icon"><a title="LinkedIn" href="' . $linkedin . '" target="' . $linktarget . '" class="leap-tooltip linkedin">LinkedIn</a></span>';
        }
        if ( $dribbble ) {
            $str .= '<span class="social-icon"><a title="Dribbble" href="' . $dribbble . '" target="' . $linktarget . '" class="leap-tooltip dribbble">Dribbble</a></span>';
        }
        if ( $googlep ) {
            $str .= '<span class="social-icon"><a title="Google Plus" href="' . $googlep . '" target="' . $linktarget . '" class="leap-tooltip googleplus">Google Plus</a></span>';
        }
        if ( $email ) {
            $str .= '<span class="social-icon"><a title="Email" href="mailto:' . $email . '" class="leap-tooltip email">Email</a></span>';
        }
        $str .= '</div>';
    }
    if ( $name || $title || $content ) {
        $str .= '<div class="person-desc">';
        $str .= '<div class="person-author clearfix">';
        $str .= '<div class="person-author-wrapper"><h4 class="person-name">' . $name . '</h4>';
        $str .= '<small class="person-title small">' . $title . '</small></div>';
        $str .= '</div>';
        $str .= '<div class="person-content">' . do_shortcode( $content ) . '</div>';
        $str .= '</div>';
    }
    $str .= '</div>';

    return $str;
}

add_shortcode( 'leap_person', 'leap_shortcode_person' );
//////////////////////////////////////////////////////////////////
// Person 2
//////////////////////////////////////////////////////////////////
function leap_shortcode_person_2( $atts, $content = null ) {
    $atts = shortcode_atts( array(
        'picture'    => '',
        'hover_image_effect'    => 'zoom-in',
        'size'       => 'full',
        'name'       => '',
        'name_color'       => '',
        'name_heading'       => 'h2',
        'title'      => '',
        'title_color'       => '',
        'title_font_size'       => '',
        'facebook'   => '',
        'twitter'    => '',
        'linkedin'   => '',
        'dribbble'   => '',
        'googlep'    => '',
        'email'      => '',
        'social_color'       => '',
        'social_hover_color'       => '',
        'content_background_color'       => '',
        'border_bottom_width'       => ''
    ), $atts );
    
    static $counter = 1;

    if ( empty( $atts['size'] ) ) {
        $atts['size'] = 'full';
    }
    
    $size_x = stripos( $atts['size'], 'x' );
    $attachment_id    = absint( $atts['picture'] );
    $image_attributes = wp_get_attachment_image_src( $attachment_id, $atts['size'] );
    if ( $size_x !== false ) {
        $size         = explode( 'x', $atts['size'] );
        $image_width  = ( empty( $size[ 0 ] ) ) ? 0 : (int) $size[ 0 ];
        $image_height = ( empty( $size[ 1 ] ) ) ? 0 : (int) $size[ 1 ];
    } else {
        $image_width  = $image_attributes[ 1 ];
        $image_height = $image_attributes[ 2 ];
    }

    if ( is_numeric( $atts['picture'] ) ) {
        $attachment_id    = absint( $atts['picture'] );
        $image_attributes = wp_get_attachment_image_src( $attachment_id, $atts['size'] );
        $atts['picture']          = $image_attributes[ 0 ];
    }
    
    if( empty( $atts['name_heading'] ) ) {
        $atts['name_heading'] = 'h2';
    }
    
    if( !empty( $atts['title_font_size'] ) ) {
        $atts['title_font_size'] = intval($atts['title_font_size']) . 'px';
    }
    if ( is_numeric( $atts['border_bottom_width'] ) ) {
        $atts['border_bottom_width'] = $atts['border_bottom_width'] . 'px';
    }
    
   $css_style = '<style type="text/css" scoped>' . "\n";

    $css_style .='#leap-person2-' . $counter . ' .person-name {' . "\n";
      if ( !empty( $atts['name_color']) ) { 
        $css_style .= 'color:' . $atts['name_color'] . ';' . "\n";

		}
       $css_style .= '}' . "\n";
       $css_style .='#leap-person2-' . $counter . ' .person-title {' . "\n";

        if ( !empty( $atts['title_color']) ) { 
        $css_style .= 'color:' . $atts['title_color'] . ';' . "\n";
        }
        if ( !empty( $atts['title_font_size']) ) { 

        $css_style .= ' font-size:' . $atts['title_font_size'] . ';' . "\n";

        }
        $css_style .= '}' . "\n";
        $css_style .='#leap-person2-' . $counter . ' .person-social-icons a i {' . "\n";
           if ( !empty( $atts['social_color']) ) { 
         $css_style .= 'color:' . $atts['social_color'] . ';' . "\n";

           }
         $css_style .= '}' . "\n";
         $css_style .='#leap-person2-' . $counter . ' .person-social-icons a:hover i {' . "\n";
          if ( !empty( $atts['social_hover_color']) ) { 
         $css_style .= 'color:' . $atts['social_hover_color'] . ';' . "\n";
           }
        $css_style .= '}' . "\n";
        $css_style .='#leap-person2-' . $counter . ' .person-data {' . "\n";
       if ( !empty( $atts['content_background_color']) ) { 
        $css_style .= 'background-color:' . $atts['content_background_color'] . ';' . "\n";
       }
        $css_style .= '}' . "\n";
                    
        $css_style .='#leap-person2-' . $counter . ' .person-img {' . "\n";
      if ( !empty( $atts['content_background_color']) ) { 
        $css_style .= 'border-bottom-color:' . $atts['content_background_color'] . ';' . "\n";
       }
       $css_style .= '}' . "\n";
       $css_style .='#leap-person2-' . $counter . ' .person-data {' . "\n";
       if ( !empty( $atts['border_bottom_width']) ) { 
       $css_style .= 'bottom:' . $atts['border_bottom_width'] . ' !important;' . "\n";
         }
       $css_style .= '}' . "\n";
       $css_style .= '</style>';
    
    $str = "<div id='leap-person2-{$counter}' class='person2 {$atts['hover_image_effect']}'> {$css_style}

            <div class='person-img'>
                <img src='{$atts['picture']}' alt='" . esc_attr($atts['name']) . "' width='{$image_width}' height='{$image_height}'/>
            </div>
            <div class='person-data'>
            <div class='person-data-container'>
                <{$atts['name_heading']} class='person-name'>" . esc_html($atts['name']) . "</{$atts['name_heading']}>
                <h5 class='person-title'>" . esc_html($atts['title']) . "</h5>
                <div class='description'>" . do_shortcode($content) . "</div>
                <div class='person-social-icons'>";
                
                if ( !empty($atts['facebook'])  ) {
                    $str .= "<a href='". esc_url($atts['facebook']) ."' target='_blank'><i class='fa fa-facebook'></i></a>";
                }
                if ( !empty($atts['twitter'])  ) {
                    $str .= "<a href='". esc_url($atts['twitter']) ."' target='_blank'><i class='fa fa-twitter'></i></a>";
                }
                if ( !empty($atts['linkedin'])  ) {
                    $str .= "<a href='". esc_url($atts['linkedin']) ."' target='_blank'><i class='fa fa-linkedin'></i></a>";
                }
                if ( !empty($atts['dribbble'])  ) {
                    $str .= "<a href='". esc_url($atts['dribbble']) ."' target='_blank'><i class='fa fa-dribbble'></i></a>";
                }
                if ( !empty($atts['googlep'])  ) {
                    $str .= "<a href='". esc_url($atts['googlep']) ."' target='_blank'><i class='fa fa-google-plus'></i></a>";
                }
                if ( !empty($atts['email'])  ) {
                    $str .= "<a href='". esc_attr($atts['email']) ."' target='_blank'><i class='fa fa-envelope'></i></a>";
                }     
                $str .= "</div>
            </div>
            </div>
        </div>";
    $counter++;
    
    return $str;
}

add_shortcode( 'leap_person_2', 'leap_shortcode_person_2' );



//////////////////////////////////////////////////////////////////
// Flickr
//////////////////////////////////////////////////////////////////
function leap_shortcode_flickr( $atts, $content = null ) {
    extract( shortcode_atts( array(
        'account_id' => '',
        'number'     => 5,
        'orderby'    => 'latest',
    ), $atts ) );

    $out = '<div class="flickr-wrapper">
	<script type="text/javascript" src="http://www.flickr.com/badge_code_v2.gne?count=' . $number . '&amp;display=' . $orderby . '&amp;size=s&amp;layout=x&amp;source=user&amp;user=' . $account_id . '"></script>
	</div>';

    return $out;
}

add_shortcode( 'leap_flickr', 'leap_shortcode_flickr' );

//////////////////////////
function leap_shortcode_rss( $atts ) {
    extract( shortcode_atts( array(
        'number' => '5',
        'feed'   => 'http://wordpress.org/news/feed/',
        'date'   => 'yes',
    ), $atts ) );

    $content = base_rss_feed( $number, $feed, $date );
    return $content;
}

add_shortcode( 'leap_rss', 'leap_shortcode_rss' );

//////////////////////////////////////////////////////////////////
// Clients container
//////////////////////////////////////////////////////////////////
function leap_shortcode_clients( $atts, $content = null ) {
    $html = '<div class="list_carousel responsive"><ul class="clients-slider">';
    $html .= do_shortcode( $content );
    $html .= '</ul><div class="cfs-nav"><span class="cfs-prev">' . __( "Previous", "LeapPort" ) . '</span><span class="cfs-next">' . __( "Next", "LeapPort" ) . '</span></div></div>';
    return $html;
}

add_shortcode( 'leap_clients', 'leap_shortcode_clients' );


//////////////////////////////////////////////////////////////////
// Client
//////////////////////////////////////////////////////////////////
add_shortcode( 'leap_client', 'leap_shortcode_client' );

function leap_shortcode_client( $atts, $content = null ) {
    extract( shortcode_atts( array(
        'image'      => 'http://placehold.it/75x75',
        'link'       => '#',
        'linktarget' => '_self',
    ), $atts ) );


    if ( empty( $linktarget ) ) {
        $linktarget = '_self';
    }

    if ( is_numeric( $image ) ) {
        $attachment_id    = absint( $image );
        $image_attributes = wp_get_attachment_image_src( $attachment_id, 'full' );
        $image            = $image_attributes[ 0 ];
    }

    $html = '<li>';
    $html .= '<a href="' . esc_url( $link ) . '" target="' . esc_attr( $linktarget ) . '"><img src="' . esc_url( $image ) . '" alt="" /></a>';
    $html .= '</li>';
    return $html;
}

//////////////////////////////////////////////////////////////////
// Pricing table
//////////////////////////////////////////////////////////////////
function leap_shortcode_pricing_table( $atts, $content = null ) {
    extract( shortcode_atts( array(
        'headerbackgroundcolor'  => '',
        'headertextcolor'        => '',
        'pricingbackgroundcolor' => '',
        'pricingtextcolor'       => '',
        'pricetextcolor'         => '',
        'oddbackgroundcolor'     => '',
        'oddtextcolor'           => '',
        'evenbackgroundcolor'    => '',
        'eventextcolor'          => '',
        'footerbackgroundcolor'  => '',
        'footertextcolor'        => '',
        'columnbordercolor'      => '',
        'dividercolor'           => ''
    ), $atts ) );

    static $leap_pricing_table_counter = 1;

    $str = '';

    $css_styles = "<style type='text/css' scoped>
		#pricing-table-{$leap_pricing_table_counter}.leap-pricing-table ul li.title-row {";
    if ( $headerbackgroundcolor ) {
        $css_styles .= "background-color:{$headerbackgroundcolor} !important;";
    }
    if ( $headertextcolor ) {
        $css_styles .= "color: {$headertextcolor} !important;";
    }
    $css_styles .= "}";

    if ( $pricingbackgroundcolor ) {
        $css_styles .= "#pricing-table-{$leap_pricing_table_counter}.leap-pricing-table ul li.pricing-row {
			background-color:{$pricingbackgroundcolor} !important;
		}";
    }

    if ( $pricingtextcolor ) {
        $css_styles .= "#pricing-table-{$leap_pricing_table_counter}.leap-pricing-table .pricing-row .price strong, #pricing-table-{$leap_pricing_table_counter}.leap-pricing-table .pricing-row .price em.time {
			color: {$pricingtextcolor} !important;
		}";
    }

    if ( $pricetextcolor ) {
        $css_styles .= "#pricing-table-{$leap_pricing_table_counter} .price em.exact_price, #pricing-table-{$leap_pricing_table_counter} .price sup {
			color: {$pricetextcolor} !important;
		}";
    }

    $css_styles .= "#pricing-table-{$leap_pricing_table_counter}.leap-pricing-table ul li.normal-row {";
    if ( $evenbackgroundcolor ) {
        $css_styles .= "background-color:{$evenbackgroundcolor} !important;";
    }
    if ( $eventextcolor ) {
        $css_styles .= "color: {$eventextcolor} !important;";
    }
    $css_styles .="}";


    if ( $oddbackgroundcolor ) {
        $css_styles .= "#pricing-table-{$leap_pricing_table_counter}.leap-pricing-table ul li.normal-row:nth-child(2n+1) {
			background-color:{$oddbackgroundcolor} !important;
			color: {$oddtextcolor} !important;
		}";
    }

    $css_styles .= "#pricing-table-{$leap_pricing_table_counter}.leap-pricing-table ul li.footer-row {";
    if ( $footerbackgroundcolor ) {
        $css_styles .= "background-color:{$footerbackgroundcolor} !important;";
    }
    if ( $footertextcolor ) {
        $css_styles .= "color: {$footertextcolor} !important;";
    }
    $css_styles .= "}";


    if ( $columnbordercolor ) {
        $css_styles .= "#pricing-table-{$leap_pricing_table_counter}.leap-pricing-table .column > ul {
			border: 1px solid {$columnbordercolor} !important;
		}";
    }

    if ( $dividercolor ) {
        $css_styles .= "#pricing-table-{$leap_pricing_table_counter}.leap-pricing-table ul li.normal-row {
			border-bottom: 1px solid {$dividercolor} !important;
		}";
    }

    $css_styles .= "</style>";

    if ( $atts[ 'type' ] == '2' ) {
        $type = 'sep';
    } elseif ( $atts[ 'type' ] == '1' ) {
        $type = 'full';
    } else {
        $type = 'third';
    }
    $str .= '<div id="pricing-table-' . $leap_pricing_table_counter . '" class="' . $type . '-boxed-pricing leap-pricing-table">';
    $str .= $css_styles;
    $str .= do_shortcode( $content );
    $str .= '</div><div class="clear"></div>';

    $leap_pricing_table_counter++;

    return $str;
}

add_shortcode( 'leap_pricing_table', 'leap_shortcode_pricing_table' );
//////////////////////////////////////////////////////////////////
// Pricing Column
//////////////////////////////////////////////////////////////////
add_shortcode( 'leap_pricing_column', 'leap_shortcode_pricing_column' );

function leap_shortcode_pricing_column( $atts, $content = null ) {
    extract( shortcode_atts( array(
        'featured' => 'no'
    ), $atts ) );

    if ( $featured == 'yes' ) {
        $featured = 'featured';
    } else {
        $featured = '';
    }
    $str = '<div class="column ' . $featured . '">';
    $str .= '<ul>';
    if ( $atts[ 'title' ] ):
        $str .= '<li class="title-row">' . $atts[ 'title' ] . '</li>';
    endif;
    $str .= do_shortcode( $content );
    $str .= '</ul>';
    $str .= '</div>';

    return $str;
}

//////////////////////////////////////////////////////////////////
// Pricing Row
//////////////////////////////////////////////////////////////////
add_shortcode( 'leap_pricing_price', 'leap_shortcode_pricing_price' );

function leap_shortcode_pricing_price( $atts, $content = null ) {
    $str = '';
    $str .= '<li class="pricing-row">';
    if ( isset( $atts[ 'currency' ] ) && !empty( $atts[ 'currency' ] ) && isset( $atts[ 'price' ] ) && !empty( $atts[ 'price' ] ) ) {
        $class = '';
        $price = explode( '.', $atts[ 'price' ] );
        if ( $price[ 1 ] ) {
            $class .= 'price-with-decimal';
        }
        $str .= '<div class="price ' . $class . '">';
        $str .= '<strong>' . $atts[ 'currency' ] . '</strong>';
        $str .= '<em class="exact_price">' . $price[ 0 ] . '</em>';
        if ( $price[ 1 ] ) {
            $str .= '<sup>' . $price[ 1 ] . '</sup>';
        }
        if ( $atts[ 'time' ] ) {
            $str .= '<em class="time">' . $atts[ 'time' ] . '</em>';
        }
        $str .= '</div>';
    } else {
        $str .= do_shortcode( $content );
    }
    $str .= '</li>';

    return $str;
}

//////////////////////////////////////////////////////////////////
// Pricing Row
//////////////////////////////////////////////////////////////////
add_shortcode( 'leap_pricing_row', 'leap_shortcode_pricing_row' );

function leap_shortcode_pricing_row( $atts, $content = null ) {
    $str = '';
    $str .= '<li class="normal-row">';
    $str .= do_shortcode( $content );
    $str .= '</li>';

    return $str;
}

//////////////////////////////////////////////////////////////////
// Pricing Footer
//////////////////////////////////////////////////////////////////
add_shortcode( 'leap_pricing_footer', 'leap_shortcode_pricing_footer' );

function leap_shortcode_pricing_footer( $atts, $content = null ) {
    $str = '';
    $str .= '<li class="footer-row">';
    $str .= do_shortcode( $content );
    $str .= '</li>';

    return $str;
}

//////////////////////////////////////////////////////////////////
// Full Width
//////////////////////////////////////////////////////////////////
add_shortcode( 'leap_fullwidth', 'leap_shortcode_fullwidth' );

function leap_shortcode_fullwidth( $atts, $content = null ) {
    extract( shortcode_atts( array(
        'backgroundcolor'      => '',
        'backgroundimage'      => '',
        'backgroundrepeat'     => '',
        'backgroundposition'   => '',
        'backgroundattachment' => '',
        'parallax'             => '',
        'bordersize'           => '0px',
        'bordercolor'          => '',
        'borderstyle'          => '',
        'paddingtop'           => '20px',
        'paddingbottom'        => '20px',
        'contentpaddingleft'   => '',
        'contentpaddingright'  => '',
        'class'                => '',
        'id'                   => '',
        'animationtype'        => '',
        'animationspeed'       => '1',
        'animationdelay'       => '0',
        'animationoffset'      => '100',
        'animationiteration'   => '1',
    ), $atts ) );

    if ( empty( $animationspeed ) ) {
        $animationspeed = '1';
    }

    if ( empty( $animationdelay ) ) {
        $animationdelay = '0';
    }

    if ( empty( $animationoffset ) ) {
        $animationoffset = '100';
    }
    if ( empty( $animationiteration ) ) {
        $animationiteration = '1';
    }

    $antimation       = '';
    $antimation_class = '';

    if ( $animationtype ) {
        $antimation_class .= 'leap-animate ' . $animationtype;

        $antimation .= 'data-wow-offset="' . $animationoffset . '" data-wow-duration="' . $animationspeed . 's" data-wow-delay="' . $animationdelay . 's" data-wow-iteration="' . $animationiteration . '"';
    }

    $style = '';
    if ( $backgroundattachment ) {
        $style .= 'background-attachment: ' . $backgroundattachment . ';';
    }
    if ( $backgroundcolor ) {
        $style .= 'background-color: ' . $backgroundcolor . ';';
    }

    if ( is_numeric( $backgroundimage ) ) {
        $attachment_id    = absint( $backgroundimage );
        $image_attributes = wp_get_attachment_image_src( $attachment_id, 'full' );
        $backgroundimage  = $image_attributes[ 0 ];
    }

    if ( $backgroundimage ) {
        $style .= 'background-image: url(' . $backgroundimage . ');';
    }
    if ( $backgroundrepeat ) {
        $style .= 'background-repeat: ' . $backgroundrepeat . ';';
    }
    if ( $backgroundposition ) {
        $style .= 'background-position: ' . $backgroundposition . ';';
    }
    if ( $bordersize ) {
        $style .= 'border-top: ' . $bordersize . ';';
        $style .= 'border-bottom: ' . $bordersize . ';';
    }
    if ( $bordercolor ) {
        $style .= 'border-color: ' . $bordercolor . ';';
    }
    if ( $borderstyle ) {
        $style .= 'border-style: ' . $borderstyle . ';';
    }
    if ( $paddingtop ) {
        $style .= 'padding-top: ' . $paddingtop . ';';
    }
    if ( $paddingbottom ) {
        $style .= 'padding-bottom: ' . $paddingbottom . ';';
    }

    $content_style = '';
    if ( $contentpaddingleft ) {
        $content_style .= 'padding-left: ' . $contentpaddingleft . ';';
    }
    if ( $contentpaddingright ) {
        $content_style .= 'padding-right: ' . $contentpaddingright . ';';
    }

    $parallax_data  = '';
    $parallax_class = '';
    if ( $parallax == 'yes' ) {
        $parallax_class = 'leap-parallax';
    }


    $out = '<div id="' . $id . '" class="leap-full-width-container ' . $parallax_class . ' ' . $class . ' ' . $antimation_class . '" ' . $antimation . ' style="' . $style . '" ><div style="' . $content_style . '" class="' . apply_filters( 'leap_container_class', 'container-fluid' ) . '">' . do_shortcode( $content ) . '</div></div>';

    return $out;
}

//////////////////////////////////////////////////////////////////
// Image
//////////////////////////////////////////////////////////////////
add_shortcode( 'leap_image', 'leap_shortcode_image' );

function leap_shortcode_image( $atts ) {
    extract( shortcode_atts( array(
        'image'              => '',
        'imagealt'           => '',
        'width'              => '',
        'height'             => '',
        'align'              => 'none',
        'lightbox'           => 'no',
        'bordersize'         => '0px',
        'bordercolor'        => '',
        'borderstyle'        => 'solid',
        'padding'            => '0px',
        'margintop'          => '',
        'marginright'        => '',
        'marginbottom'       => '',
        'marginleft'         => '',
        'backgroundcolor'    => '',
        'class'              => '',
        'animationtype'      => '',
        'animationspeed'     => '1',
        'animationdelay'     => '0',
        'animationoffset'    => '100',
        'animationiteration' => '1',
    ), $atts ) );

    if ( is_numeric( $image ) ) {
        $attachment_id    = absint( $image );
        $image_attributes = wp_get_attachment_image_src( $attachment_id, 'full' );
        $image            = $image_attributes[ 0 ];
    }

    if ( empty( $animationspeed ) ) {
        $animationspeed = '1';
    }

    if ( empty( $animationdelay ) ) {
        $animationdelay = '0';
    }

    if ( empty( $animationoffset ) ) {
        $animationoffset = '100';
    }
    if ( empty( $animationiteration ) ) {
        $animationiteration = '1';
    }

    $antimation       = '';
    $antimation_class = '';

    if ( $animationtype ) {
        $antimation_class .= 'leap-animate ' . $animationtype;

        $antimation .= 'data-wow-offset="' . $animationoffset . '" data-wow-duration="' . $animationspeed . 's" data-wow-delay="' . $animationdelay . 's" data-wow-iteration="' . $animationiteration . '"';
    }

    static $leap_image_counter = 1;

    if ( $align == 'right' ) {
        $align = 'alignright';
    } elseif ( $align == 'left' ) {
        $align = 'alignleft';
    } elseif ( $align == 'center' ) {
        $align = 'aligncenter';
    } else {
        $align = 'alignnone';
    }

    $style = '';

    if ( $bordersize ) {
        $style .= 'border-width: ' . $bordersize . ';';
    }
    if ( $bordercolor ) {
        $style .= 'border-color: ' . $bordercolor . ';';
    }
    if ( $borderstyle ) {
        $style .= 'border-style: ' . $borderstyle . ';';
    }
    if ( $padding ) {
        $style .= 'padding: ' . $padding . ';';
    }
    if ( $margintop ) {
        $style .= 'margin-top: ' . $margintop . ';';
    }
    if ( $marginright ) {
        $style .= 'margin-right: ' . $marginright . ';';
    }
    if ( $marginbottom ) {
        $style .= 'margin-bottom: ' . $marginbottom . ';';
    }
    if ( $marginleft ) {
        $style .= 'margin-left: ' . $marginleft . ';';
    }
    if ( $backgroundcolor ) {
        $style .= 'background-color: ' . $backgroundcolor . ';';
    }
    if ( $width ) {
        $style .= 'width: ' . $width . ';';
    }
    if ( $height ) {
        $style .= 'height: ' . $height . ';';
    }


    $out = '';
    $out .= '<span id="leap-image-' . $leap_image_counter . '" class="leap-image ' . $class . ' ' . $align . '" >';
    if ( $lightbox == 'yes' ) {
        $out .= '<a data-rel="prettyPhoto" href="' . $image . '">';
    }
    $out .= '<img class="' . $antimation_class . '" src="' . $image . '" alt="' . $imagealt . '" style="' . $style . '" ' . $antimation . '>';
    if ( $lightbox == 'yes' ) {
        $out .= '</a>';
    }
    $out .= '</span>';

    $leap_image_counter++;

    return $out;
}

//////////////////////////////////////////////////////////////////
// Blog
//////////////////////////////////////////////////////////////////
add_shortcode( 'leap_blog', 'leap_shortcode_blog' );

function leap_shortcode_blog( $atts, $content = null ) {
    extract( shortcode_atts( array(
        'layout'          => 'grid',
        'rightleft_image_height' => '570',
        'number_posts'    => get_option( 'posts_per_page' ),
        'cats'            => 'uncategorized',
        'excerpt'         => 'yes',
        'excerptlength'   => apply_filters( 'excerpt_length', 55 ),
        'meta_author'     => 'yes',
        'meta_categories' => 'yes',
        'meta_comments'   => 'yes',
        'meta_date'       => 'yes',
        'meta_tags'       => 'yes',
        'paging'          => 'yes',
        'share_buttons'   => 'yes'
    ), $atts ) );

    $blog_layout = $layout;

    if ( is_front_page() ) {
        $paged = (get_query_var( 'page' )) ? get_query_var( 'page' ) : 1;
    } else {
        $paged = (get_query_var( 'paged' )) ? get_query_var( 'paged' ) : 1;
    }

    $args     = array(
        'posts_per_page' => $number_posts,
        'category_name'  => $cats,
        'paged'          => $paged
    );
    global $wp_query;
    $temp     = $wp_query;
    $wp_query = null;
    $wp_query = new WP_Query( $args );

    static $instance = 0;
    $instance++;
    
    if( !empty( $rightleft_image_height ) ) {
        $rightleft_image_height = intval($rightleft_image_height) . 'px';
    }
    
    $css_styles = '
	<style type="text/css" scoped>
		#leap-blog-' . $instance . ' .blog-rightleft-image .entry-header .default-featured-image, #leap-blog-' . $instance . ' .archive-rightleft-image .entry-header .default-featured-image, #leap-blog-' . $instance . ' .blog-rightleft-image .entry-header .featured-image, .archive-rightleft-image .entry-header .featured-image {
			height: ' . $rightleft_image_height . ';
		}
	</style>
	';
    
    $html = '<div id="leap-blog-'. $instance .'" class="blog-wrapper">';
    $html .= $css_styles;
    $html .= '<div class="entry-layout blog-' . $layout . '">';
    if ( $wp_query->have_posts() ) {
        while ( $wp_query->have_posts() ) {
            $wp_query->the_post();
            ob_start();
            ?>
<?php
$post_format_class = '';               
// Audio
if ( get_post_format() == 'audio' ) {
    $leap_format_audio_embed = get_post_meta( get_the_ID(), '_format_audio_embed', true );
    $format_content          = do_shortcode( $leap_format_audio_embed );
    if ( $format_content ) {
        $post_format_class= "has-audio";
    }
    // Video
} elseif ( get_post_format() == 'video' ) {
    $leap_format_video_embed = get_post_meta( get_the_ID(), '_format_video_embed', true );
    $format_content          = do_shortcode( $leap_format_video_embed );
    if ( $format_content ) {
        $post_format_class= "has-video";
    }
    // Gallery
} elseif ( get_post_format() == 'gallery' ) {
    $leap_format_gallery = get_post_meta( get_the_ID(), '_format_gallery', true );
    $format_content      = do_shortcode( $leap_format_gallery );
    if ( $format_content ) {
        $post_format_class= "has-gallery";
    }
    // Link
} elseif ( get_post_format() == 'link' ) {
    $leap_format_link_title = esc_html( get_post_meta( get_the_ID(), '_format_link_title', true ) );
    $leap_format_link_url   = esc_url( get_post_meta( get_the_ID(), '_format_link_url', true ) );
    if ( $leap_format_link_title && $leap_format_link_url ) {
        $post_format_class= "has-link";
    }
    // Quote
} elseif ( get_post_format() == 'quote' ) {
    $leap_format_quote = get_post_meta( get_the_ID(), '_format_quote', true );
    $format_content    = do_shortcode( $leap_format_quote );
    if ( $format_content ) {
        $post_format_class= "has-quote";
    }
}
?>
            <?php
            $format_content = '';
            // Audio
            if ( get_post_format() == 'audio' ) {
                $leap_format_audio_embed = get_post_meta( get_the_ID(), '_format_audio_embed', true );
                $format_content          = do_shortcode( $leap_format_audio_embed );
                // Video
            } elseif ( get_post_format() == 'video' ) {
                $leap_format_video_embed = get_post_meta( get_the_ID(), '_format_video_embed', true );
                $format_content          = do_shortcode( $leap_format_video_embed );
                // Gallery
            } elseif ( get_post_format() == 'gallery' ) {
                $leap_format_gallery = get_post_meta( get_the_ID(), '_format_gallery', true );
                $format_content      = do_shortcode( $leap_format_gallery );
                // Link
            } elseif ( get_post_format() == 'link' ) {
                $leap_format_link_title = esc_html( get_post_meta( get_the_ID(), '_format_link_title', true ) );
                $leap_format_link_url   = esc_url( get_post_meta( get_the_ID(), '_format_link_url', true ) );
                $format_content = '<h5><i class="fa fa-link"></i> ' . esc_html__( 'Visit URL:', 'leap-port' ) . ' <a target="_blank" href="' . $leap_format_link_url . '">' . $leap_format_link_title . '</a></h5>';
                // Quote
            } elseif ( get_post_format() == 'quote' ) {
                $leap_format_quote = get_post_meta( get_the_ID(), '_format_quote', true );
                $format_content    = do_shortcode( $leap_format_quote );
            }
            ?>

            <?php if ( 'rightleft-image' == $blog_layout ) { ?>

                <div id="post-<?php the_ID(); ?>" <?php post_class($post_format_class); ?>>
                    <div class="entry-wrapper">
                        <div class="entry-header">
                            <?php
                            $large_image_url = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'large' );
                            
                            $blog_image_size = 'leap-portfolio-1col';

                            if ( $blog_layout == 'grid' ) {
                                //$blog_image_size = array(567, 'auto');
                                $blog_image_size = 'leap-portfolio-grid';
                            } elseif ( $blog_layout == 'large' ) {
                                $blog_image_size = 'leap-portfolio-1col';
                            } elseif ( $blog_layout == 'large-modern' ) {
                                $blog_image_size = 'leap-portfolio-1col';
                            } elseif ( $blog_layout == 'postformat' ) {
                                $blog_image_size = 'leap-portfolio-1col';
                            } elseif ( $blog_layout == 'rightleft-image' ) {
                                $blog_image_size = 'leap-570x570';
                            } elseif ( $blog_layout == 'small' ) {
                                $blog_image_size = 'leap-portfolio-2col';
                            }
                            
                            if ( !post_password_required() ) { ?>
                                <div class="entry-head">
                                    <div class="post-img">
                                        <div class="leap-overlay item-img">
                                            <?php echo leap_get_the_post_thumbnail_background( get_the_ID(), $blog_image_size ); ?>
                                            <div class="item-overlay">
                                                <div class="item-img-color"></div>
                                                <div class="item-details">
                                                    <div class="item-links">
                                                        <a class="item-link" href="<?php the_permalink() ?>" title="<?php the_title_attribute(); ?>"><?php esc_html_e( 'Link', 'wiz' ) ?></a>
                                                        <a class="enlarge" data-rel="prettyPhoto" href="<?php echo $large_image_url[ 0 ]; ?>" title="<?php the_title_attribute(); ?>">
                                                            <?php echo __( 'Enlarge', 'leap-port' ); ?>
                                                        </a>
                                                    </div>
                                                </div>
                                            </div>

                                        </div>
                                    </div>
                                    <?php if( $format_content && in_array( get_post_format(), array('video', 'audio') ) ) { ?>
                                        <div class="post-format-content"><?php echo $format_content; ?></div>
                                    <?php } ?>
                                </div>
                            <?php } ?>
                        </div>
                            <?php
                            if ( get_post_format() == 'audio' ) {
                                $post_format_class = 'audio';
                            } elseif ( get_post_format() == 'video' ) {
                                $post_format_class = 'video';
                            } elseif ( get_post_format() == 'aside' ) {
                                $post_format_class = 'aside';
                            } elseif ( get_post_format() == 'chat' ) {
                                $post_format_class = 'chat';
                            } elseif ( get_post_format() == 'gallery' ) {
                                $post_format_class = 'gallery';
                            } elseif ( get_post_format() == 'image' ) {
                                $post_format_class = 'image';
                            } elseif ( get_post_format() == 'link' ) {
                                $post_format_class = 'links';
                            } elseif ( get_post_format() == 'quote' ) {
                                $post_format_class = 'quote';
                            } elseif ( get_post_format() == 'status' ) {
                                $post_format_class = 'status';
                            } else {
                                $post_format_class = 'standard';
                            }
                            ?>
                        <div class="entry-content">
                                <div class="entry-info">
                                    <?php
                                    if ( get_post_format() == 'quote' ) {
                                        $leap_format_quote = get_post_meta( get_the_ID(), '_format_quote', true );
                                        $format_content    = do_shortcode( $leap_format_quote );
                                        if ( $format_content ) {
                                            echo '<div class="post-quote"><a href="' . get_the_permalink() . '">' . $format_content . '</a></div>';
                                        }
                                    } elseif ( get_post_format() == 'link' ) {
                                        ?>
                                        <h2 class="entry-title"><a href="<?php the_permalink() ?>" title="<?php the_title_attribute(); ?>"><?php esc_html_e( get_the_title() ); ?></a></h2> 
                                        <?php
                                        $leap_format_link_title = esc_html( get_post_meta( get_the_ID(), '_format_link_title', true ) );
                                        $leap_format_link_url   = esc_url( get_post_meta( get_the_ID(), '_format_link_url', true ) );
                                        if ( $leap_format_link_title && $leap_format_link_url ) {
                                            echo '<div class="post-link"><a target="_blank" href="' . $leap_format_link_url . '">' . $leap_format_link_title . '</a></div>';
                                        }
                                    } else {
                                        ?>
                                        <h2 class="entry-title"><a href="<?php the_permalink() ?>" title="<?php the_title_attribute(); ?>"><?php esc_html_e( get_the_title() ); ?></a></h2>
                                    <?php } ?>

                                    <div class="entry-meta"><?php
                                        $meta_settings = array();
                                        if ( $meta_author == 'yes' ) {
                                            $meta_settings[] = 'author';
                                        }
                                        if ( $meta_categories == 'yes' ) {
                                            $meta_settings[] = 'categories';
                                        }
                                        if ( $meta_comments == 'yes' ) {
                                            $meta_settings[] = 'comments';
                                        }
                                        if ( $meta_date == 'yes' ) {
                                            $meta_settings[] = 'date';
                                        }
                                        leap_entry_meta( $meta_settings );
                                        ?></div>
                                </div>

                            <?php if ( get_the_content() ) { ?>
                                <div class="post-content">
                                    <?php
                                    if ( $excerpt == 'yes' ) {
                                        echo leap_get_the_excerpt(null, $excerptlength);
                                    } else {
                                        the_content( '<span>' . __( 'Read More', 'leap-port' ) . '</span>' );
                                        wp_link_pages( array(
                                            'before'         => '<div class="pagination pagination-page"><strong>' . esc_html__( 'Pages', 'wiz' ) . ':</strong><ul class="clearfix">',
                                            'after'          => '</ul></div>',
                                            'next_or_number' => 'number',
                                            'link_before'    => '<span>',
                                            'link_after'     => '</span>'
                                        ) );
                                    }
                                    ?>
                                </div>
                            <?php } ?>
                            <?php
                            if ( $meta_tags == 'yes' ) {
                                $tag_list = get_the_tag_list( '', __( ', ', 'leap-port' ) );
                                if ( $tag_list ) {
                                    echo '<div class="entry-tags"><small class="small"><i class="fa fa-tags"></i> ' . $tag_list . '</small></div>';
                                }
                            }
                            ?>

                            <?php
                            if ( $share_buttons == 'yes' ) {
                                get_template_part( 'includes/share-buttons' );
                            }
                            ?>

                        </div>

                        <div class="entry-footer">
                            
                        </div> 
                    </div>
                </div>

            <?php } else { ?>
                <div id="post-<?php the_ID(); ?>" <?php post_class( $post_format_class ); ?>>
                    <div class="entry-wrapper">
                        <div class="entry-header">
                            <?php
                            if ( ($blog_layout != 'classic') && !post_password_required() ) {
                                // Audio
                                if ( get_post_format() == 'audio' ) {
                                    $leap_format_audio_embed = get_post_meta( get_the_ID(), '_format_audio_embed', true );
                                    $format_content          = do_shortcode( $leap_format_audio_embed );
                                    if ( $format_content ) {
                                        echo '<div class="entry-head"><div class="post-audio">' . $format_content . '</div></div>';
                                    }
                                    // Video
                                } elseif ( get_post_format() == 'video' ) {
                                    $leap_format_video_embed = get_post_meta( get_the_ID(), '_format_video_embed', true );
                                    $format_content          = do_shortcode( $leap_format_video_embed );
                                    if ( $format_content ) {
                                        echo '<div class="entry-head"><div class="post-video">' . $format_content . '</div></div>';
                                    }
                                    // Gallery
                                } elseif ( get_post_format() == 'gallery' ) {
                                    $leap_format_gallery = get_post_meta( get_the_ID(), '_format_gallery', true );
                                    $format_content      = do_shortcode( $leap_format_gallery );
                                    if ( $format_content ) {
                                        echo '<div class="entry-head"><div class="post-gallery">' . $format_content . '</div></div>';
                                    }
                                    // Link
                                } elseif ( get_post_format() == 'link' && !in_array( $blog_layout, array( 'large-modern', 'rightleft-image' ) ) ) {
                                    $leap_format_link_title = esc_html( get_post_meta( get_the_ID(), '_format_link_title', true ) );
                                    $leap_format_link_url   = esc_url( get_post_meta( get_the_ID(), '_format_link_url', true ) );
                                    if ( $leap_format_link_title && $leap_format_link_url ) {
                                        echo '<div class="entry-head"><div class="post-link"><h5><i class="fa fa-link"></i> ' . esc_html__( 'Visit URL:', 'leap-port' ) . ' <a target="_blank" href="' . $leap_format_link_url . '">' . $leap_format_link_title . '</a></h5></div></div>';
                                    }
                                    // Quote
                                } elseif ( get_post_format() == 'quote' && !in_array( $blog_layout, array( 'large-modern', 'rightleft-image' ) ) ) {
                                    $leap_format_quote = get_post_meta( get_the_ID(), '_format_quote', true );
                                    $format_content    = do_shortcode( $leap_format_quote );
                                    if ( $format_content ) {
                                        echo '<div class="entry-head"><div class="post-quote">' . $format_content . '</div></div>';
                                    }
                                    // Others
                                } else {
                                    if ( has_post_thumbnail() ) {
                                        $large_image_url = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'large' );

                                        $blog_image_size = 'leap-portfolio-1col';

                                        if ( $blog_layout == 'grid' ) {
                                            //$blog_image_size = array(567, 'auto');
                                            $blog_image_size = 'leap-portfolio-grid';
                                        } elseif ( $blog_layout == 'large' ) {
                                            $blog_image_size = 'leap-portfolio-1col';
                                        } elseif ( $blog_layout == 'large-modern' ) {
                                            $blog_image_size = 'leap-portfolio-1col';
                                        } elseif ( $blog_layout == 'postformat' ) {
                                            $blog_image_size = 'leap-portfolio-1col';
                                        } elseif ( $blog_layout == 'rightleft-image' ) {
                                            $blog_image_size = 'leap-570x570';
                                        } elseif ( $blog_layout == 'small' ) {
                                            $blog_image_size = 'leap-portfolio-2col';
                                        }
                                        ?>
                                        <div class="entry-head">				
                                            <div class="post-img">
                                                <div class="leap-overlay item-img">
                                                    <?php echo get_the_post_thumbnail( get_the_ID(), $blog_image_size ); ?>
                                                    <div class="item-overlay">
                                                        <div class="item-img-color"></div>
                                                        <div class="item-details">
                                                            <div class="item-links">
                                                                <a class="item-link" href="<?php the_permalink() ?>" title="<?php the_title_attribute(); ?>"><?php esc_html_e( 'Link', 'wiz' ) ?></a>
                                                                <a class="enlarge" data-rel="prettyPhoto" href="<?php echo $large_image_url[ 0 ]; ?>" title="<?php the_title_attribute(); ?>">
                                                                    <?php echo __( 'Enlarge', 'leap-port' ); ?>
                                                                </a>
                                                            </div>
                                                        </div>
                                                    </div>

                                                </div>
                                            </div>
                                        </div>
                                        <?php
                                    }
                                }
                            }
                            ?>
                            <?php //Post title    ?>
                            <?php
                            if ( get_post_format() == 'audio' ) {
                                $post_format_class = 'audio';
                            } elseif ( get_post_format() == 'video' ) {
                                $post_format_class = 'video';
                            } elseif ( get_post_format() == 'aside' ) {
                                $post_format_class = 'aside';
                            } elseif ( get_post_format() == 'chat' ) {
                                $post_format_class = 'chat';
                            } elseif ( get_post_format() == 'gallery' ) {
                                $post_format_class = 'gallery';
                            } elseif ( get_post_format() == 'image' ) {
                                $post_format_class = 'image';
                            } elseif ( get_post_format() == 'link' ) {
                                $post_format_class = 'links';
                            } elseif ( get_post_format() == 'quote' ) {
                                $post_format_class = 'quote';
                            } elseif ( get_post_format() == 'status' ) {
                                $post_format_class = 'status';
                            } else {
                                $post_format_class = 'standard';
                            }
                            ?>
                            <?php if ( !in_array( $blog_layout, array( 'large-modern', 'rightleft-image' ) ) ) { ?>
                                <div class="entry-info">
                                    <?php if ( $blog_layout == 'postformat' ) { ?>
                                        <div class="post-icon"><a class="dashicons dashicons-format-<?php echo $post_format_class; ?>" title="<?php echo get_post_format_string( get_post_format() ); ?>" href="<?php echo esc_url( get_post_format_link( get_post_format() ) ); ?>"></a></div>
                                    <?php } ?>

                                    <h2 class="entry-title"><a href="<?php the_permalink() ?>" title="<?php the_title_attribute(); ?>"><?php esc_html_e( get_the_title() ); ?></a></h2>

                                    <div class="entry-meta"><?php
                                        $meta_settings = array();
                                        if ( $meta_author == 'yes' ) {
                                            $meta_settings[] = 'author';
                                        }
                                        if ( $meta_categories == 'yes' ) {
                                            $meta_settings[] = 'categories';
                                        }
                                        if ( $meta_comments == 'yes' ) {
                                            $meta_settings[] = 'comments';
                                        }
                                        if ( $meta_date == 'yes' ) {
                                            $meta_settings[] = 'date';
                                        }
                                        leap_entry_meta( $meta_settings );
                                        ?></div>
                                </div>
                            <?php } ?>
                        </div>

                        <div class="entry-content">

                            <?php if ( in_array( $blog_layout, array( 'large-modern', 'rightleft-image' ) ) ) { ?>

                                <div class="entry-info">
                                    <?php if ( $blog_layout == 'large-modern' ) { ?>
                                        <div class="post-icon"><a class="dashicons dashicons-format-<?php echo $post_format_class; ?>" title="<?php echo get_post_format_string( get_post_format() ); ?>" href="<?php echo esc_url( get_post_format_link( get_post_format() ) ); ?>"></a></div>
                                    <?php } ?>

                                    <?php
                                    if ( get_post_format() == 'quote' ) {
                                        $leap_format_quote = get_post_meta( get_the_ID(), '_format_quote', true );
                                        $format_content    = do_shortcode( $leap_format_quote );
                                        if ( $format_content ) {
                                            echo '<div class="post-quote"><a href="' . get_the_permalink() . '">' . $format_content . '</a></div>';
                                        }
                                    } elseif ( get_post_format() == 'link' ) {
                                        ?>
                                        <h2 class="entry-title"><a href="<?php the_permalink() ?>" title="<?php the_title_attribute(); ?>"><?php esc_html_e( get_the_title() ); ?></a></h2> 
                                        <?php
                                        $leap_format_link_title = esc_html( get_post_meta( get_the_ID(), '_format_link_title', true ) );
                                        $leap_format_link_url   = esc_url( get_post_meta( get_the_ID(), '_format_link_url', true ) );
                                        if ( $leap_format_link_title && $leap_format_link_url ) {
                                            echo '<div class="post-link"><a target="_blank" href="' . $leap_format_link_url . '">' . $leap_format_link_title . '</a></div>';
                                        }
                                    } else {
                                        ?>
                                        <h2 class="entry-title"><a href="<?php the_permalink() ?>" title="<?php the_title_attribute(); ?>"><?php esc_html_e( get_the_title() ); ?></a></h2>
                                    <?php } ?>

                                    <div class="entry-meta"><?php
                                        $meta_settings = array();
                                        if ( $meta_author == 'yes' ) {
                                            $meta_settings[] = 'author';
                                        }
                                        if ( $meta_categories == 'yes' ) {
                                            $meta_settings[] = 'categories';
                                        }
                                        if ( $meta_comments == 'yes' ) {
                                            $meta_settings[] = 'comments';
                                        }
                                        if ( $meta_date == 'yes' ) {
                                            $meta_settings[] = 'date';
                                        }
                                        leap_entry_meta( $meta_settings );
                                        ?></div>
                                </div>

                            <?php } ?>

                            <?php
                            //Featured image 
                            if ( $blog_layout == 'classic' && !post_password_required() ) {
                                // Audio
                                if ( get_post_format() == 'audio' ) {
                                    $leap_format_audio_embed = get_post_meta( get_the_ID(), '_format_audio_embed', true );
                                    $format_content          = do_shortcode( $leap_format_audio_embed );
                                    if ( $format_content ) {
                                        echo '<div class="post-format post-audio">' . $format_content . '</div>';
                                    }
                                    // Video
                                } elseif ( get_post_format() == 'video' ) {
                                    $leap_format_video_embed = get_post_meta( get_the_ID(), '_format_video_embed', true );
                                    $format_content          = do_shortcode( $leap_format_video_embed );
                                    if ( $format_content ) {
                                        echo '<div class="post-format post-video">' . $format_content . '</div>';
                                    }
                                    // Gallery
                                } elseif ( get_post_format() == 'gallery' ) {
                                    $leap_format_gallery = get_post_meta( get_the_ID(), '_format_gallery', true );
                                    $format_content      = do_shortcode( $leap_format_gallery );
                                    if ( $format_content ) {
                                        echo '<div class="post-format post-gallery">' . $format_content . '</div>';
                                    }
                                    // Link
                                } elseif ( get_post_format() == 'link' ) {
                                    $leap_format_link_title = esc_html( get_post_meta( get_the_ID(), '_format_link_title', true ) );
                                    $leap_format_link_url   = esc_url( get_post_meta( get_the_ID(), '_format_link_url', true ) );
                                    if ( $leap_format_link_title && $leap_format_link_url ) {
                                        echo '<div class="post-format post-link"><h5><i class="fa fa-link"></i> ' . esc_html__( 'Visit URL:', 'leap-port' ) . ' <a target="_blank" href="' . $leap_format_link_url . '">' . $leap_format_link_title . '</a></h5></div>';
                                    }
                                    // Quote
                                } elseif ( get_post_format() == 'quote' ) {
                                    $leap_format_quote = get_post_meta( get_the_ID(), '_format_quote', true );
                                    $format_content    = do_shortcode( $leap_format_quote );
                                    if ( $format_content ) {
                                        echo '<div class="post-format post-quote">' . $format_content . '</div>';
                                    }
                                    // Standard
                                } else {
                                    if ( has_post_thumbnail() ) {
                                        $large_image_url = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'large' );
                                        ?>
                                        <div class="post-format post-img">
                                            <div class="leap-overlay item-img">
                                                <?php echo get_the_post_thumbnail( get_the_ID(), 'leap-portfolio-cat' ); ?>
                                                <div class="item-overlay">
                                                    <div class="item-img-color"></div>
                                                    <div class="item-details">
                                                        <div class="item-links">
                                                            <a class="item-link" href="<?php the_permalink() ?>" title="<?php the_title_attribute(); ?>"><?php esc_html_e( 'Link', 'wiz' ) ?></a>
                                                            <a class="enlarge" data-rel="prettyPhoto[posts_gal]" href="<?php echo $large_image_url[ 0 ]; ?>" title="<?php the_title_attribute(); ?>">
                                                                <?php echo __( 'Enlarge', 'leap-port' ); ?>
                                                            </a>
                                                        </div>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>
                                        <?php
                                    }
                                }
                            }
                            ?>
                            <?php $the_content = get_the_content(); ?>
                            <?php if ( !empty( $the_content ) ) { ?>
                                <div class="post-content">
                                    <?php
                                    if ( $excerpt == 'yes' ) {
                                        echo leap_get_the_excerpt(null, $excerptlength);
                                    } else {
                                        the_content( '<span>' . __( 'Read More', 'leap-port' ) . '</span>' );
                                        wp_link_pages( array(
                                            'before'         => '<div class="pagination pagination-page"><strong>' . esc_html__( 'Pages', 'wiz' ) . ':</strong><ul class="clearfix">',
                                            'after'          => '</ul></div>',
                                            'next_or_number' => 'number',
                                            'link_before'    => '<span>',
                                            'link_after'     => '</span>'
                                        ) );
                                    }
                                    ?>
                                </div>
                            <?php } ?>
                            <?php
                            if ( $meta_tags == 'yes' && in_array( $blog_layout, array( 'large-modern', 'rightleft-image' ) ) ) {
                                $tag_list = get_the_tag_list( '', __( ', ', 'leap-port' ) );
                                if ( $tag_list ) {
                                    echo '<div class="entry-tags"><small class="small"><i class="fa fa-tags"></i> ' . $tag_list . '</small></div>';
                                }
                            }
                            ?>

                            <?php
                            if ( $share_buttons == 'yes' && $blog_layout == 'rightleft-image' ) {
                                get_template_part( 'includes/share-buttons' );
                            }
                            ?>

                        </div>

                        <div class="entry-footer">
                            <?php
                            if ( $meta_tags == 'yes' && !in_array( $blog_layout, array( 'large-modern', 'rightleft-image' ) ) ) {
                                $tag_list = get_the_tag_list( '', __( ', ', 'leap-port' ) );
                                if ( $tag_list ) {
                                    echo '<div class="entry-tags"><small class="small"><i class="fa fa-tags"></i> ' . $tag_list . '</small></div>';
                                }
                            }

                            if ( $share_buttons == 'yes' && $blog_layout != 'rightleft-image' ) {
                                get_template_part( 'includes/share-buttons' );
                            }
                            ?>
                        </div> 
                    </div>
                </div>
            <?php } ?>






            <?php
            $html .= ob_get_contents();
            ob_end_clean();
        }
    }
    $html .= '</div>';
    $html .= '</div>';
    if ( $paging == 'yes' ) {

        if ( function_exists( 'leap_page_navi' ) ) {
            ob_start();
            leap_page_navi();
            $html .= ob_get_contents();
            ob_end_clean();
        }
    }

    $wp_query = null;
    $wp_query = $temp;

    wp_reset_postdata();

    return $html;
}

function leap_shortcode_gap( $atts ) {
    extract( shortcode_atts( array( 'height' => '20px', ), $atts ) );
    $html = '<div style="height: ' . $height . '; clear:both;"></div>';
    return $html;
}

add_shortcode( 'leap_gap', 'leap_shortcode_gap' );

function leap_shortcode_google_map( $atts, $content = null ) {
    extract( shortcode_atts( array(
        'width'    => '100%',
        'height'   => '350px',
        'lat'      => '',
        'lng'      => '',
        'zoom'     => 13,
        'map_type' => 'roadmap',
        'title'    => '',
    ), $atts ) );

    $id = uniqid();
    ?>

    <script>
        var myCenter_<?php echo $id; ?> = new google.maps.LatLng(<?php echo $lat; ?>, <?php echo $lng; ?> );

        function initialize_<?php echo $id ?>() {
            var mapProp = {
                center: myCenter_<?php echo $id; ?>,
                zoom: <?php echo $zoom; ?>,
                mapTypeId: google.maps.MapTypeId.<?php echo strtoupper( $map_type ); ?>,
                scrollwheel: false
            };

            var map = new google.maps.Map( document.getElementById( "googleMap-<?php echo $id ?>" ), mapProp );

            var marker = new google.maps.Marker( {
                position: myCenter_<?php echo $id; ?>,
                title: "<?php echo $title; ?>"
            } );

            marker.setMap( map );

            var infowindow = new google.maps.InfoWindow( {
                content: "<?php echo do_shortcode( $content ); ?>"
            } );

            google.maps.event.addListener( marker, 'click', function () {
                infowindow.open( map, marker );
            } );
        }

        google.maps.event.addDomListener( window, 'load', initialize_<?php echo $id ?> );
    </script>


    <div id="googleMap-<?php echo $id ?>" style="width:<?php echo $width; ?>; height:<?php echo $height; ?>;"></div>


    <?php
    //return $html;
}

add_shortcode( 'leap_google_map', 'leap_shortcode_google_map' );

//////////////////////////////////////////////////////////////////
// Recent Works
//////////////////////////////////////////////////////////////////

function leap_shortcode_recent_portfolio_slider( $atts ) {
    extract( shortcode_atts( array(
        'cats' => array(),
        'num'  => '10',
    ), $atts ) );

    if ( empty( $num ) ) {
        $num = 10;
    }

    if ( !empty( $cats ) ) {
        $cats = explode( ',', $cats );
    }

    $args = array(
        'post_type'      => 'leap-portfolio',
        'post_status'    => 'publish',
        'posts_per_page' => $num,
    );
    if ( $cats ) {
        $args[ 'tax_query' ][] = array(
            'taxonomy' => 'leap-portfolio-category',
            'field'    => 'slug',
            'terms'    => $cats
        );
    }

    $output               = '';
    $leap_portfolio_query = new WP_Query( $args );
    if ( $leap_portfolio_query->have_posts() ) {
        $output = '<div class="list_carousel responsive"><ul class="portfolio-slider">';
        while ( $leap_portfolio_query->have_posts() ) {
            $leap_portfolio_query->the_post();
            if ( has_post_thumbnail() ) {
                $output .= '<li>';
                $output .= '<div class="leap-overlay item-img">';
                $output .= get_the_post_thumbnail( get_the_ID(), 'leap-related-thumbnail' );
                $large_image_url = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'large' );
                $output .= '<div class="item-overlay">';
                $output .= '<div class="item-img-color"></div>';
                $output .= '<div class="item-details">';
                $output .= '<h4 class="item-title"><a href="' . get_permalink() . '" title="' . the_title_attribute( 'echo=0' ) . '">' . get_the_title() . '</a></h4>';
                $output .= '<div class="item-links">';
                $output .= '<a class="item-link" href="' . get_permalink() . '" title="' . the_title_attribute( 'echo=0' ) . '">link</a>';
                $output .= '<a class="enlarge" data-rel="prettyPhoto[sc_portfolio_gal]" href="' . $large_image_url[ 0 ] . '" title="' . the_title_attribute( 'echo=0' ) . '">enlarge</a>';
                $output .= '</div>';
                $output .= '</div>';
                $output .= '</div>';
                $output .= '</div>';
                $output .= '</li>';
            }
        }
        $output .= '</ul><div class="cfs-nav"><span class="cfs-prev">' . __( "Previous", "LeapPort" ) . '</span><span class="cfs-next">' . __( "Next", "LeapPort" ) . '</span></div></div>';
        wp_reset_postdata();
    }
    return $output;
}

add_shortcode( 'leap_portfolio_slider', 'leap_shortcode_recent_portfolio_slider' );

//////////////////////////////////////////////////////////////////
// Portfolio
//////////////////////////////////////////////////////////////////
function leap_shortcode_portfolio( $atts, $content = null ) {
    extract( shortcode_atts( array(
        'layout'                 => 'grid',
        'cats'                   => array(),
        'num'                    => '10',
        'without_featured_image' => 'yes',
        'order'                  => 'DESC',
        'orderby'                => 'date',
        'filter'                 => 'yes',
        'titles'                 => 'yes',
        'categories'             => 'yes',
        'descriptions'           => 'yes',
        'excerptlength'          => apply_filters( 'excerpt_length', 55 ),
        'readmore_button'        => 'yes',
        'visit_button'           => 'yes',
        'paging'                 => 'yes',
        'separator'              => 'yes'
    ), $atts ) );

    if ( empty( $layout ) ) {
        $layout = 'grid';
    }
    if ( empty( $cats ) ) {
        $cats = array();
    }
    if ( empty( $num ) ) {
        $num = 10;
    }
    if ( empty( $without_featured_image ) ) {
        $without_featured_image = 'yes';
    }
    if ( empty( $order ) ) {
        $order = 'DESC';
    }
    if ( empty( $orderby ) ) {
        $orderby = 'title';
    }
    if ( empty( $filter ) ) {
        $filter = 'yes';
    }
    if ( empty( $titles ) ) {
        $titles = 'yes';
    }
    if ( empty( $categories ) ) {
        $categories = 'yes';
    }
    if ( empty( $descriptions ) ) {
        $descriptions = 'yes';
    }
    if ( empty( $readmore_button ) ) {
        $readmore_button = 'yes';
    }
    if ( empty( $visit_button ) ) {
        $visit_button = 'yes';
    }
    if ( empty( $paging ) ) {
        $paging = 'yes';
    }
    if ( empty( $separator ) ) {
        $separator = 'yes';
    }

    if ( !empty( $cats ) ) {
        $cats = explode( ',', $cats );
    }

    $_thumbnail_id = array();
    if ( $without_featured_image == 'no' ) {
        $_thumbnail_id = array(
            'key'     => '_thumbnail_id',
            'compare' => 'EXISTS'
        );
    }

    $portfolio_categories = get_terms( 'leap-portfolio-category' );

    $output = '';

    if ( $portfolio_categories && $filter != 'no' ) :

        $output .= '<ul class="portfolio-tabs">';
        $output .= '<li class="active"><a data-filter="*" href="#">' . __("All", "leap-port") . '</a></li>';
        foreach ( $portfolio_categories as $portfolio_category ):
            if ( $cats && !empty( $cats ) ):
                if ( in_array( $portfolio_category->slug, $cats ) ):
                    $output .= '<li><a data-filter=".portfolio-id-' . $portfolio_category->term_id . '" href="#">' . $portfolio_category->name . '</a></li>';
                endif;
            else:
                $output .= '<li><a data-filter=".portfolio-id-' . $portfolio_category->term_id . '" href="#">' . $portfolio_category->name . '</a></li>';
            endif;
        endforeach;
        $output .= '</ul>';
    endif;


    if ( is_front_page() ) {
        $paged = (get_query_var( 'page' )) ? get_query_var( 'page' ) : 1;
    } else {
        $paged = (get_query_var( 'paged' )) ? get_query_var( 'paged' ) : 1;
    }

    $args = array(
        'post_type'      => 'leap-portfolio',
        'paged'          => $paged,
        'posts_per_page' => $num,
        'orderby'        => $orderby,
        'order'          => $order,
        'meta_query'     => array( $_thumbnail_id )
    );
    if ( $cats ) {
        $args[ 'tax_query' ][] = array(
            'taxonomy' => 'leap-portfolio-category',
            'field'    => 'slug',
            'terms'    => $cats
        );
    }

    $output .= '<div class="portfolio-wrapper">';
    $output .= '<div class="entry-layout portfolio-' . $layout . '">';

    global $wp_query;
    $temp     = $wp_query;
    $wp_query = null;
    $wp_query = new WP_Query( $args );
    while ( $wp_query->have_posts() ): $wp_query->the_post();
        $item_classes = array();
        $item_cats    = get_the_terms( $wp_query->post->ID, 'leap-portfolio-category' );
        if ( $item_cats ):
            foreach ( $item_cats as $item_cat ) {
                $item_classes[] = 'portfolio-id-'.$item_cat->term_id;
            }
        endif;

        $item_all_classes = get_post_class( $item_classes );

        $output .= '<div id="post-' . $wp_query->post->ID . '" class="' . implode( ' ', $item_all_classes ) . '">';


        $output .= '<div class="entry-wrapper">';

        $large_image_url = wp_get_attachment_image_src( get_post_thumbnail_id( $wp_query->post->ID ), 'large' );
        $output .= '<div class="entry-header">';
        $output .= '<div class="entry-head">';
        $output .= '<div class="entry-img">';
        $output .= '<div class="leap-overlay item-img">
			' . get_the_post_thumbnail( $wp_query->post->ID, "leap-portfolio-" . $layout ) . '
			<div class="item-overlay">
			<div class="item-img-color"></div>
			<div class="item-details">
				<div class="item-links">
					<a class="item-link" href="' . get_permalink() . '" title="' . the_title_attribute( 'echo=0' ) . '">link</a>
					<a class="enlarge" data-rel="prettyPhoto[sc_portfolio_grid_gal]" href="' . $large_image_url[ 0 ] . '" title="' . the_title_attribute( 'echo=0' ) . '">
						enlarge
					</a>
				</div>
					<h4 class="item-title"><a href="' . get_permalink() . '" title="' . the_title_attribute( 'echo=0' ) . '">' . get_the_title() . '</a></h4>

					<p class="item-category">' . get_the_term_list( $wp_query->post->ID, 'leap-portfolio-category', '', ', ', '' ) . '</p>
			</div>
			</div>
		</div>';
        $output .= '</div>';
        $output .= '</div>';

        $output .= '<div class="entry-info">';
        if ( $titles == 'yes' ) {
            $output .= '<h2 class="entry-title"><a href="' . get_permalink() . '" rel="bookmark" title="' . the_title_attribute( 'echo=0' ) . '">' . get_the_title() . '</a></h2>';
        }

        if ( $categories == 'yes' ) {
            $output .= '<div class="entry-meta">';
            $output .= '<small class="entry-category small"><i class="fa fa-align-left"></i> ' . get_the_term_list( $wp_query->post->ID, 'leap-portfolio-category', '', ', ', '' ) . '</small>';
            $output .= '</div>';
        }

        $output .= '</div>';

        $output .= '</div>';



        $output .= '<div class="entry-content">';
        if ( $descriptions == 'yes' ) {
            $output .='<div class="post-content">' . leap_get_the_excerpt(null, $excerptlength) . '</div>';
        }
        $output .='</div>';

        $output .='<div class="entry-footer">';
        $output .='<div class="portfolio-buttons">';
        if ( $readmore_button == 'yes' ) {
            $output .='<a class="project-more btn btn-default btn-leap" href="' . get_permalink() . '" rel="bookmark" title="' . the_title_attribute( 'echo=0' ) . '" >' . __( "Read More", "wiz" ) . '</a>';
        }

        $project_link          = get_post_meta( get_the_ID(), 'project_link', true );
        $leap_project_url      = (isset( $project_link[ 'url' ] )) ? esc_url( $project_link[ 'url' ] ) : '';
        $leap_project_url_text = (isset( $project_link[ 'text' ] )) ? esc_html( $project_link[ 'text' ] ) : '';
        if ( empty( $leap_project_url_text ) ) {
            $leap_project_url_text = __( "Visit Project", "wiz" );
        }

        if ( (!empty( $project_link[ 'url' ] )) && ($visit_button == 'yes') ) {
            $output .='<a class="project-url btn btn-default btn-leap" href="' . $leap_project_url . '">' . $leap_project_url_text . '</a>';
        }
        $output .='</div>';
        $output .='</div>';

        if ( $separator == 'yes' ) {
            $output .='<div class="portfolio-sep"></div>';
        }

        $output .= '</div>';
        $output .= '</div>';
    endwhile;
    $output .= '</div>';
    $output .= '</div>';


    if ( function_exists( 'leap_page_navi' ) && ($paging == 'yes') ) {
        ob_start();
        leap_page_navi();
        $output .= ob_get_contents();
        ob_end_clean();
    }

    $wp_query = null;
    $wp_query = $temp;
    wp_reset_postdata();

    return $output;
}

add_shortcode( 'leap_portfolio', 'leap_shortcode_portfolio' );


//////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////
// Add buttons to tinyMCE
//////////////////////////////////////////////////////////////////
add_action( 'init', 'add_button' );
add_action( 'init', 'add_button_2' );

function add_button() {
    if ( current_user_can( 'edit_posts' ) && current_user_can( 'edit_pages' ) ) {
        add_filter( 'mce_external_plugins', 'add_plugin' );
        add_filter( 'mce_buttons_3', 'register_button' );
    }
}

function add_button_2() {
    if ( current_user_can( 'edit_posts' ) && current_user_can( 'edit_pages' ) ) {
        add_filter( 'mce_external_plugins', 'add_plugin_2' );
        add_filter( 'mce_buttons_4', 'register_button_2' );
    }
}

function register_button( $buttons ) {
    array_push(
    $buttons, "AddVideo", "AddSoundcloud", "AddButton", "AddDropcap", "AddHighlight", "AddQuote", "AddIconbox", "AddImagebox", "AddTagline", "AddOnehalf", "AddOnethird", "AddTwothird", "AddOnefourth", "AddThreefourth", "AddToggle", "AddAccordion", "AddRecentposts", "AddIframe", "AddLightbox", "AddTitle"
    );
    return $buttons;
}

function register_button_2( $buttons ) {
    array_push(
    $buttons, "AddTabs", "AddQRCode", "AddSeparator", "AddList", "AddTooltip", "AddTestimonials", "AddProgressBar", "AddAlertBox", "AddFontawesome", "AddPerson", "AddFlickr", "AddRss", "AddTable", "AddClients", "AddPricingTable", "AddFullWidth", "AddBlog", "AddGap", "AddGooglefont", "AddImage", "AddPortfolioSlider", "AddPortfolio"
    );
    return $buttons;
}

function add_plugin( $plugin_array ) {
    $plugin_array[ 'leap13ShortCodes' ] = JS_PATH;
    return $plugin_array;
}

function add_plugin_2( $plugin_array ) {
    $plugin_array[ 'leap13ShortCodes' ] = JS_PATH;
    return $plugin_array;
}

function leap_gallery_shortcode( $attr ) {
    $post = get_post();

    static $instance = 0;
    $instance++;

    if ( !empty( $attr[ 'ids' ] ) ) {
        // 'ids' is explicitly ordered, unless you specify otherwise.
        if ( empty( $attr[ 'orderby' ] ) )
            $attr[ 'orderby' ] = 'post__in';
        $attr[ 'include' ] = $attr[ 'ids' ];
    }

    // Allow plugins/themes to override the default gallery template.
    $output = apply_filters( 'post_gallery', '', $attr );
    if ( $output != '' )
        return $output;

    // We're trusting author input, so let's at least make sure it looks like a valid orderby statement
    if ( isset( $attr[ 'orderby' ] ) ) {
        $attr[ 'orderby' ] = sanitize_sql_orderby( $attr[ 'orderby' ] );
        if ( !$attr[ 'orderby' ] )
            unset( $attr[ 'orderby' ] );
    }

    extract( shortcode_atts( array(
        'order'      => 'ASC',
        'orderby'    => 'menu_order ID',
        'id'         => $post ? $post->ID : 0,
        'itemtag'    => 'dl',
        'icontag'    => 'dt',
        'captiontag' => 'dd',
        'columns'    => 3,
        'size'       => 'thumbnail',
        'include'    => '',
        'exclude'    => '',
        'link'       => '',
        'ids'        => ''
    ), $attr, 'gallery' ) );

    $id      = intval( $id );
    if ( 'RAND' == $order )
        $orderby = 'none';

    if ( !empty( $include ) ) {
        $_attachments = get_posts( array( 'include' => $include, 'post_status' => 'inherit', 'post_type' => 'attachment', 'post_mime_type' => 'image', 'order' => $order, 'orderby' => $orderby ) );

        $attachments = array();
        foreach ( $_attachments as $key => $val ) {
            $attachments[ $val->ID ] = $_attachments[ $key ];
        }
    } elseif ( !empty( $exclude ) ) {
        $attachments = get_children( array( 'post_parent' => $id, 'exclude' => $exclude, 'post_status' => 'inherit', 'post_type' => 'attachment', 'post_mime_type' => 'image', 'order' => $order, 'orderby' => $orderby ) );
    } else {
        $attachments = get_children( array( 'post_parent' => $id, 'post_status' => 'inherit', 'post_type' => 'attachment', 'post_mime_type' => 'image', 'order' => $order, 'orderby' => $orderby ) );
    }

    if ( empty( $attachments ) )
        return '';

    if ( is_feed() ) {
        $output = "\n";
        foreach ( $attachments as $att_id => $attachment )
            $output .= wp_get_attachment_link( $att_id, $size, true ) . "\n";
        return $output;
    }


    $output .= '<script type="text/javascript">
		( function ( $ ) {
			"use strict";
        jQuery(window).load(function() {
          // The slider being synced must be initialized first
          jQuery("#sc-carousel-' . $instance . '").flexslider({
            animation: "slide",
            controlNav: false,
            animationLoop: false,
            slideshow: false,
            itemWidth: 80,
            itemMargin: 20,
            asNavFor: "#sc-slider-' . $instance . '"
          });

          jQuery("#sc-slider-' . $instance . '").flexslider({
            animation: "fade",
            controlNav: false,
            animationLoop: false,
            slideshow: false,
            sync: "#sc-carousel-' . $instance . '"
          });
        });
		} )( jQuery );
        </script>';

    $output .= '<div id="sc-slider-' . $instance . '" class="flexslider sc-slider"><ul class="slides">';
    $post_gal_id = uniqid();
    foreach ( $attachments as $id => $attachment ) {
        $image_attributes = wp_get_attachment_image_src( $id, 'leap-slider' );
        if ( $image_attributes ) {
            $large_image_url = wp_get_attachment_image_src( $id, 'large' );
            $output .= '<li>
				<div class="leap-overlay item-img one">
					<img src="' . $image_attributes[ 0 ] . '" width="' . $image_attributes[ 1 ] . '" height="' . $image_attributes[ 2 ] . '">
					<div class="item-overlay">
                    <div class="item-img-color"></div>
						<div class="item-details">
		                    <div class="item-links">
								<a class="enlarge" data-rel="prettyPhoto[post_gal_' . $post_gal_id . ']" href="' . $large_image_url[ 0 ] . '" title="' . the_title_attribute( "echo=0" ) . '">
									enlarge
								</a>
								
		                    </div>
						</div>
					</div>
		
				</div>
			</li>';
        }
    }

    $output .= '</ul></div>';

    return $output;
}

add_shortcode( 'gallery', 'leap_gallery_shortcode' );
