<?php

add_action( 'init', 'leap_portfolio_post_type', 5 );

function leap_portfolio_post_type() {
    register_post_type( 'leap-portfolio', array(
        'labels'        => array(
            'name'               => apply_filters( 'leap_port_portfolio_name', __( 'Portfolio', 'leap-port' ) ),
            'all_items'          => __( 'All Posts', 'leap-port' ),
            'add_new'            => __( 'Add New', 'leap-port' ),
            'add_new_item'       => __( 'Add New', 'leap-port' ),
            'edit'               => __( 'Edit', 'leap-port' ),
            'edit_item'          => __( 'Edit', 'leap-port' ),
            'new_item'           => __( 'New', 'leap-port' ),
            'view'               => __( 'View', 'leap-port' ),
            'view_item'          => __( 'View', 'leap-port' ),
            'search_items'       => __( 'Search', 'leap-port' ),
            'not_found'          => __( 'No Posts found', 'leap-port' ),
            'not_found_in_trash' => __( 'No Posts found in Trash', 'leap-port' ),
            'parent'             => __( 'Parent', 'leap-port' )
        ),
        'public'        => true,
        'menu_position' => 20,
        'supports'      => array( 'title', 'editor', 'thumbnail' ),
        'rewrite'       => array( 'slug' => apply_filters( 'leap_port_portfolio_slug', 'leap-portfolio-project' ) ),
        'can_export'    => true,
        'has_archive'   => true
    )
    );

    register_taxonomy(
    'leap-portfolio-category', 'leap-portfolio', array(
        'rewrite'           => array(
            'slug'         => apply_filters( 'leap_port_portfolio_category_slug', 'category' ),
            'hierarchical' => true
        ),
        'labels'            => array(
            'name'          => __( 'Portfolio Categories', 'leap-port' ),
            'menu_name'     => __( 'Categories', 'leap-port' ),
            'add_new_item'  => __( 'Add New Category', 'leap-port' ),
            'new_item_name' => __( 'New Category Name', 'leap-port' )
        ),
        'show_ui'           => true,
        'show_tagcloud'     => true,
        'hierarchical'      => true,
        'show_admin_column' => true,
        'show_in_nav_menus' => true
    )
    );

    register_taxonomy(
    'leap-portfolio-tag', 'leap-portfolio', array(
        'rewrite'           => array(
            'slug'         => apply_filters( 'leap_port_portfolio_tag_slug', 'leap-portfolio-tag' ),
            'hierarchical' => false
        ),
        'labels'            => array(
            'name'          => __( 'Portfolio Tags', 'leap-port' ),
            'menu_name'     => __( 'Tags', 'leap-port' ),
            'add_new_item'  => __( 'Add New Tag', 'leap-port' ),
            'new_item_name' => __( 'New Tag Name', 'leap-port' )
        ),
        'show_ui'           => true,
        'show_tagcloud'     => true,
        'hierarchical'      => false,
        'show_admin_column' => true,
        'show_in_nav_menus' => true
    )
    );
}

add_filter( 'template_include', 'leap_portfolio_template_include', 1 );

function leap_portfolio_template_include( $template_path ) {
    if ( get_post_type() == 'leap-portfolio' ) {
        if ( is_single() ) {
            // checks if the file exists in the theme first,
            if ( $theme_file = locate_template( array( 'single-leap-portfolio.php' ) ) ) {
                $template_path = $theme_file;
            }
        } elseif ( is_archive() ) {
            if ( $theme_file = locate_template( array( 'archive-leap-portfolio.php' ) ) ) {
                $template_path = $theme_file;
            }
        }
    }
    return $template_path;
}
