(window["webpackJsonp"] = window["webpackJsonp"] || []).push([["vendors~WilCountdown"],{

/***/ "./node_modules/@chenfengyuan/vue-countdown/dist/vue-countdown.js":
/*!************************************************************************!*\
  !*** ./node_modules/@chenfengyuan/vue-countdown/dist/vue-countdown.js ***!
  \************************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

eval("/*!\n * vue-countdown v1.1.5\n * https://fengyuanchen.github.io/vue-countdown\n *\n * Copyright 2018-present Chen Fengyuan\n * Released under the MIT license\n *\n * Date: 2020-02-25T01:19:32.769Z\n */\n\n(function (global, factory) {\n   true ? module.exports = factory() :\n  undefined;\n}(this, (function () { 'use strict';\n\n  var MILLISECONDS_SECOND = 1000;\n  var MILLISECONDS_MINUTE = 60 * MILLISECONDS_SECOND;\n  var MILLISECONDS_HOUR = 60 * MILLISECONDS_MINUTE;\n  var MILLISECONDS_DAY = 24 * MILLISECONDS_HOUR;\n  var EVENT_VISIBILITY_CHANGE = 'visibilitychange';\n  var index = {\n    name: 'countdown',\n    data: function data() {\n      return {\n        /**\n         * It is counting down.\n         * @type {boolean}\n         */\n        counting: false,\n\n        /**\n         * The absolute end time.\n         * @type {number}\n         */\n        endTime: 0,\n\n        /**\n         * The remaining milliseconds.\n         * @type {number}\n         */\n        totalMilliseconds: 0\n      };\n    },\n    props: {\n      /**\n       * Starts the countdown automatically when initialized.\n       */\n      autoStart: {\n        type: Boolean,\n        default: true\n      },\n\n      /**\n       * Emits the countdown events.\n       */\n      emitEvents: {\n        type: Boolean,\n        default: true\n      },\n\n      /**\n       * The interval time (in milliseconds) of the countdown progress.\n       */\n      interval: {\n        type: Number,\n        default: 1000,\n        validator: function validator(value) {\n          return value >= 0;\n        }\n      },\n\n      /**\n       * Generate the current time of a specific time zone.\n       */\n      now: {\n        type: Function,\n        default: function _default() {\n          return Date.now();\n        }\n      },\n\n      /**\n       * The tag name of the component's root element.\n       */\n      tag: {\n        type: String,\n        default: 'span'\n      },\n\n      /**\n       * The time (in milliseconds) to count down from.\n       */\n      time: {\n        type: Number,\n        default: 0,\n        validator: function validator(value) {\n          return value >= 0;\n        }\n      },\n\n      /**\n       * Transforms the output props before render.\n       */\n      transform: {\n        type: Function,\n        default: function _default(props) {\n          return props;\n        }\n      }\n    },\n    computed: {\n      /**\n       * Remaining days.\n       * @returns {number} The computed value.\n       */\n      days: function days() {\n        return Math.floor(this.totalMilliseconds / MILLISECONDS_DAY);\n      },\n\n      /**\n       * Remaining hours.\n       * @returns {number} The computed value.\n       */\n      hours: function hours() {\n        return Math.floor(this.totalMilliseconds % MILLISECONDS_DAY / MILLISECONDS_HOUR);\n      },\n\n      /**\n       * Remaining minutes.\n       * @returns {number} The computed value.\n       */\n      minutes: function minutes() {\n        return Math.floor(this.totalMilliseconds % MILLISECONDS_HOUR / MILLISECONDS_MINUTE);\n      },\n\n      /**\n       * Remaining seconds.\n       * @returns {number} The computed value.\n       */\n      seconds: function seconds() {\n        return Math.floor(this.totalMilliseconds % MILLISECONDS_MINUTE / MILLISECONDS_SECOND);\n      },\n\n      /**\n       * Remaining milliseconds.\n       * @returns {number} The computed value.\n       */\n      milliseconds: function milliseconds() {\n        return Math.floor(this.totalMilliseconds % MILLISECONDS_SECOND);\n      },\n\n      /**\n       * Total remaining days.\n       * @returns {number} The computed value.\n       */\n      totalDays: function totalDays() {\n        return this.days;\n      },\n\n      /**\n       * Total remaining hours.\n       * @returns {number} The computed value.\n       */\n      totalHours: function totalHours() {\n        return Math.floor(this.totalMilliseconds / MILLISECONDS_HOUR);\n      },\n\n      /**\n       * Total remaining minutes.\n       * @returns {number} The computed value.\n       */\n      totalMinutes: function totalMinutes() {\n        return Math.floor(this.totalMilliseconds / MILLISECONDS_MINUTE);\n      },\n\n      /**\n       * Total remaining seconds.\n       * @returns {number} The computed value.\n       */\n      totalSeconds: function totalSeconds() {\n        return Math.floor(this.totalMilliseconds / MILLISECONDS_SECOND);\n      }\n    },\n    render: function render(createElement) {\n      return createElement(this.tag, this.$scopedSlots.default ? [this.$scopedSlots.default(this.transform({\n        days: this.days,\n        hours: this.hours,\n        minutes: this.minutes,\n        seconds: this.seconds,\n        milliseconds: this.milliseconds,\n        totalDays: this.totalDays,\n        totalHours: this.totalHours,\n        totalMinutes: this.totalMinutes,\n        totalSeconds: this.totalSeconds,\n        totalMilliseconds: this.totalMilliseconds\n      }))] : this.$slots.default);\n    },\n    watch: {\n      $props: {\n        deep: true,\n        immediate: true,\n\n        /**\n         * Update the countdown when props changed.\n         */\n        handler: function handler() {\n          this.totalMilliseconds = this.time;\n          this.endTime = this.now() + this.time;\n\n          if (this.autoStart) {\n            this.start();\n          }\n        }\n      }\n    },\n    methods: {\n      /**\n       * Starts to countdown.\n       * @public\n       * @emits Countdown#start\n       */\n      start: function start() {\n        if (this.counting) {\n          return;\n        }\n\n        this.counting = true;\n\n        if (this.emitEvents) {\n          /**\n           * Countdown start event.\n           * @event Countdown#start\n           */\n          this.$emit('start');\n        }\n\n        if (document.visibilityState === 'visible') {\n          this.continue();\n        }\n      },\n\n      /**\n       * Continues the countdown.\n       * @private\n       */\n      continue: function _continue() {\n        var _this = this;\n\n        if (!this.counting) {\n          return;\n        }\n\n        var delay = Math.min(this.totalMilliseconds, this.interval);\n\n        if (delay > 0) {\n          if (window.requestAnimationFrame) {\n            var init;\n            var prev;\n\n            var step = function step(now) {\n              if (!init) {\n                init = now;\n              }\n\n              if (!prev) {\n                prev = now;\n              }\n\n              var range = now - init;\n\n              if (range >= delay // Avoid losing time about one second per minute (now - prev ≈ 16ms) (#43)\n              || range + (now - prev) / 2 >= delay) {\n                _this.progress();\n              } else {\n                _this.requestId = requestAnimationFrame(step);\n              }\n\n              prev = now;\n            };\n\n            this.requestId = requestAnimationFrame(step);\n          } else {\n            this.timeoutId = setTimeout(function () {\n              _this.progress();\n            }, delay);\n          }\n        } else {\n          this.end();\n        }\n      },\n\n      /**\n       * Pauses the countdown.\n       * @private\n       */\n      pause: function pause() {\n        if (window.requestAnimationFrame) {\n          cancelAnimationFrame(this.requestId);\n        } else {\n          clearTimeout(this.timeoutId);\n        }\n      },\n\n      /**\n       * Progresses to countdown.\n       * @private\n       * @emits Countdown#progress\n       */\n      progress: function progress() {\n        if (!this.counting) {\n          return;\n        }\n\n        this.totalMilliseconds -= this.interval;\n\n        if (this.emitEvents && this.totalMilliseconds > 0) {\n          /**\n           * Countdown progress event.\n           * @event Countdown#progress\n           */\n          this.$emit('progress', {\n            days: this.days,\n            hours: this.hours,\n            minutes: this.minutes,\n            seconds: this.seconds,\n            milliseconds: this.milliseconds,\n            totalDays: this.totalDays,\n            totalHours: this.totalHours,\n            totalMinutes: this.totalMinutes,\n            totalSeconds: this.totalSeconds,\n            totalMilliseconds: this.totalMilliseconds\n          });\n        }\n\n        this.continue();\n      },\n\n      /**\n       * Aborts the countdown.\n       * @public\n       * @emits Countdown#abort\n       */\n      abort: function abort() {\n        if (!this.counting) {\n          return;\n        }\n\n        this.pause();\n        this.counting = false;\n\n        if (this.emitEvents) {\n          /**\n           * Countdown abort event.\n           * @event Countdown#abort\n           */\n          this.$emit('abort');\n        }\n      },\n\n      /**\n       * Ends the countdown.\n       * @public\n       * @emits Countdown#end\n       */\n      end: function end() {\n        if (!this.counting) {\n          return;\n        }\n\n        this.pause();\n        this.totalMilliseconds = 0;\n        this.counting = false;\n\n        if (this.emitEvents) {\n          /**\n           * Countdown end event.\n           * @event Countdown#end\n           */\n          this.$emit('end');\n        }\n      },\n\n      /**\n       * Updates the count.\n       * @private\n       */\n      update: function update() {\n        if (this.counting) {\n          this.totalMilliseconds = Math.max(0, this.endTime - this.now());\n        }\n      },\n\n      /**\n       * visibility change event handler.\n       * @private\n       */\n      handleVisibilityChange: function handleVisibilityChange() {\n        switch (document.visibilityState) {\n          case 'visible':\n            this.update();\n            this.continue();\n            break;\n\n          case 'hidden':\n            this.pause();\n            break;\n        }\n      }\n    },\n    mounted: function mounted() {\n      document.addEventListener(EVENT_VISIBILITY_CHANGE, this.handleVisibilityChange);\n    },\n    beforeDestroy: function beforeDestroy() {\n      document.removeEventListener(EVENT_VISIBILITY_CHANGE, this.handleVisibilityChange);\n      this.pause();\n    }\n  };\n\n  return index;\n\n})));\n\n\n//# sourceURL=webpack:///./node_modules/@chenfengyuan/vue-countdown/dist/vue-countdown.js?");

/***/ })

}]);