(window["webpackJsonp"] = window["webpackJsonp"] || []).push([[1],{

/***/ "./assets/dev/js/mixins/TimeHelper.js":
/*!********************************************!*\
  !*** ./assets/dev/js/mixins/TimeHelper.js ***!
  \********************************************/
/*! exports provided: TimeHelper, BusinessHourHelper */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"TimeHelper\", function() { return TimeHelper; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"BusinessHourHelper\", function() { return BusinessHourHelper; });\n/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/defineProperty */ \"./node_modules/@babel/runtime/helpers/defineProperty.js\");\n/* harmony import */ var _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0__);\n\n\nfunction ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }\n\nfunction _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _babel_runtime_helpers_defineProperty__WEBPACK_IMPORTED_MODULE_0___default()(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }\n\nvar TimeHelper = {\n  data: function data() {\n    return {\n      validDateFormat: [\"YYY-MM-DD\", \"MM-DD-YYYY\", \"MM-DD-YYY\", \"DD/MM/YYY\", \"YY/MM/DD\", \"MM/DD/YY\", \"MM/DD/YYYY\", \"DD/MM/YYYY\", \"YYYY/MM/DD H:m\", \"YYY-MM-DD H:m\", \"MM-DD-YYYY H:m\", \"DD/MM/YY H:m\", \"YYY-MM-DD H:m\"]\n    };\n  },\n  computed: {\n    dateFormat: function dateFormat() {\n      return this.parseDateFormat(WILOKE_GLOBAL.dateFormat);\n    },\n    timeFormat: function timeFormat() {\n      var timeFormat = WILOKE_INLINE_GLOBAL.timeFormat.toLowerCase();\n      return timeFormat.replace(\"g\", \"hh\").replace(\"i\", \"mm\").replace(\"a\", \"A\");\n    }\n  },\n  methods: {\n    isValidDateFormat: function isValidDateFormat(dateFormat) {\n      return this.validDateFormat.some(function (item) {\n        return item === dateFormat;\n      });\n    },\n    parsePurgeDateFormat: function parsePurgeDateFormat(dateFormat) {\n      return dateFormat.toLowerCase().replace(\"dd/mm/yyyy\", \"DD/MM/YYYY\").replace(\"yyyy-mm-dd\", \"YYYY-MM-DD\").replace(\"yyyy-dd-mm\", \"YYYY-DD-MM\").replace(\"dd-mm-yyyy\", \"DD-YYYY-MM\").replace(\"j f y\", \"DD-MM-YYYY\").replace(\"f j y\", \"MM-DD-YYYY\").replace(\"f. j y\", \"MM-DD-YYYY\").replace(\"j. f y\", \"DD-MM-YYYY\").replace(\"j f y\", \"DD-MM-YYYY\").replace(\"f j, y\", \"MM-DD-YYYY\").replace(\"j f, y\", \"DD-MM-YYYY\").replace(\"y-m-d\", \"YYYY-MM-DD\").replace(\"m/d/y\", \"MM/DD/YYYY\").replace(\"d/m/y\", \"DD/MM/YYYY\").replace(\"y/m/d\", \"YYYY/MM/DD\").replace(\"y/d/m\", \"YYYY/DD/MM\").replace(\"yyyy\", \"YYYY\").replace(\"yy\", \"YY\");\n    },\n    parseDateFormat: function parseDateFormat(dateFormat) {\n      var _this = this;\n\n      if (this.isValidDateFormat(dateFormat)) {\n        return dateFormat;\n      }\n\n      var regex = /([^hH]+)(hh:mm|h:m)/gi;\n\n      if (dateFormat.match(regex)) {\n        return dateFormat.replace(regex, function (match, rawDateFormat, timeFormat) {\n          var date = _this.parsePurgeDateFormat(rawDateFormat);\n\n          return \"\".concat(date).concat(timeFormat);\n        });\n      } else {\n        return this.parsePurgeDateFormat(dateFormat);\n      }\n    },\n    date: function date(timeZone) {\n      try {\n        var date = !timeZone ? new Date() : new Date().toLocaleString(\"en-US\", {\n          timeZone: timeZone\n        });\n        return new Date(date);\n      } catch (e) {\n        return false;\n      }\n    },\n    getLocaleTimeString: function getLocaleTimeString(timeZone, hourCycle, isRemoveSecond) {\n      // h24, h12\n      var format = {\n        hour: \"2-digit\",\n        minute: \"2-digit\",\n        hourCycle: hourCycle\n      };\n\n      if (!!isRemoveSecond === false) {\n        format = _objectSpread(_objectSpread({}, format), {}, {\n          second: \"2-digit\"\n        });\n      }\n\n      if (timeZone) {\n        format = _objectSpread(_objectSpread({}, format), {}, {\n          timeZone: timeZone\n        });\n      }\n\n      try {\n        return new Date().toLocaleTimeString(\"en-US\", format);\n      } catch (e) {\n        return false;\n      }\n    },\n    getHours: function getHours(timeZone, format, isRemoveSecond) {\n      format = !format ? \"h24\" : format;\n      var current = this.getLocaleTimeString(timeZone, format, isRemoveSecond);\n\n      if (current === false) {\n        current = this.getLocaleTimeString(null, format, isRemoveSecond);\n      }\n\n      return current;\n    },\n    getDay: function getDay(timeZone) {\n      var date = this.date(timeZone);\n\n      if (!date) {\n        return false;\n      }\n\n      return date.getDay();\n    },\n    getLocalString: function getLocalString(timeZone) {\n      var date = this.date(timeZone);\n\n      if (!date) {\n        return false;\n      }\n\n      return date.toLocaleString();\n    }\n  }\n}; // this method requires TimeHelpers\n\nvar BusinessHourHelper = {\n  data: function data() {\n    return {\n      dayKeys: [\"sunday\", \"monday\", \"tuesday\", \"wednesday\", \"thursday\", \"friday\", \"saturday\"],\n      businessHourToday: {},\n      businessHourStatus: {\n        always_open: {\n          status: \"always_open\",\n          text: this.$options.filters.filterTranslation(\"Always Open\", \"always_open\"),\n          \"class\": \"color-secondary\"\n        },\n        open: {\n          status: \"open\",\n          text: this.$options.filters.filterTranslation(\"Open\", \"open\"),\n          \"class\": \"color-secondary\"\n        },\n        close: {\n          status: \"close\",\n          text: this.$options.filters.filterTranslation(\"Closed\", \"closed\"),\n          \"class\": \"color-quaternary\"\n        },\n        closures: {\n          status: \"close\",\n          text: this.$options.filters.filterTranslation(\"\", \"businessClosures\"),\n          \"class\": \"color-quaternary\"\n        }\n      }\n    };\n  },\n  methods: {\n    todayKey: function todayKey(timeZone) {\n      var todayKey = this.getDay(timeZone);\n\n      if (todayKey === false) {\n        todayKey = this.getDay();\n      }\n\n      return this.dayKeys[todayKey];\n    },\n    previousDayKey: function previousDayKey(timeZone) {\n      var todayIndex = this.getDay(timeZone);\n      var todayKey = this.dayKeys[todayIndex];\n\n      if (todayKey === \"sunday\") {\n        return \"saturday\";\n      }\n\n      return this.dayKeys[todayIndex - 1];\n    },\n    convertTimeToNumber: function convertTimeToNumber(time) {\n      var timestamp;\n\n      if (!time) {\n        timestamp = parseInt(time, 10);\n      } else {\n        var parsedTime = time.replace(\":\", \"\").replace(\":\", \"\");\n        timestamp = parseInt(parsedTime, 10);\n      }\n\n      if (isNaN(timestamp)) {\n        return 0;\n      }\n\n      return timestamp;\n    },\n    isTurnOffBusinessHour: function isTurnOffBusinessHour(businessHour) {\n      return businessHour.isOpen === \"no\" || isNaN(businessHour.firstOpenHour) || isNaN(businessHour.firstOpenHour);\n    },\n    isAlwaysOpen: function isAlwaysOpen(businessHour) {\n      return businessHour.firstCloseHour === businessHour.firstOpenHour && businessHour.firstOpenHour === 240000;\n    },\n    covertBusinessHourToNumber: function covertBusinessHourToNumber(businessHour) {\n      return _objectSpread(_objectSpread({}, businessHour), {}, {\n        firstOpenHour: this.convertTimeToNumber(businessHour.firstOpenHour, true),\n        firstCloseHour: this.convertTimeToNumber(businessHour.firstCloseHour, true),\n        secondOpenHour: this.convertTimeToNumber(businessHour.secondOpenHour, true),\n        secondCloseHour: this.convertTimeToNumber(businessHour.secondCloseHour, true)\n      });\n    },\n    findLastBusinessHour: function findLastBusinessHour(businessHour) {\n      var lastOpen = businessHour.secondOpenHour === 0 ? businessHour.firstOpenHour : businessHour.secondOpenHour;\n      var lastClose = businessHour.secondCloseHour === 0 ? businessHour.firstCloseHour : businessHour.secondCloseHour;\n      return {\n        lastOpen: lastOpen,\n        lastClose: lastClose\n      };\n    },\n    getCurrentBusinessHourStatus: function getCurrentBusinessHourStatus(businessHours) {\n      if (!!businessHours === false || !businessHours.mode || businessHours.mode === \"no_hours_available\") {\n        this.businessHourToday = false;\n      } else if (businessHours.mode === \"always_open\") {\n        this.businessHourToday = _objectSpread({}, this.businessHourStatus.always_open);\n      } else if (businessHours.mode === \"business_closures\") {\n        this.businessHourToday = _objectSpread({}, this.businessHourStatus.closures);\n      } else {\n        var todayBusinessHour = _objectSpread({}, businessHours.operating_times[this.todayKey(businessHours.timezone)]);\n\n        if (_.isEmpty(todayBusinessHour)) {\n          this.businessHourToday = false;\n          return true;\n        }\n\n        if (todayBusinessHour.firstCloseHour === \"00:00:00\") {\n          todayBusinessHour = _objectSpread(_objectSpread({}, todayBusinessHour), {}, {\n            firstCloseHour: \"23:59:59\"\n          });\n        }\n\n        if (todayBusinessHour.secondCloseHourUTC === \"00:00:00\") {\n          todayBusinessHour = _objectSpread(_objectSpread({}, todayBusinessHour), {}, {\n            secondCloseHourUTC: \"23:59:59\"\n          });\n        }\n\n        todayBusinessHour = this.covertBusinessHourToNumber(todayBusinessHour);\n\n        if (this.isTurnOffBusinessHour(todayBusinessHour)) {\n          this.businessHourToday = _objectSpread({}, this.businessHourStatus.close);\n          return true;\n        }\n\n        if (this.isAlwaysOpen(todayBusinessHour)) {\n          this.businessHourToday = _objectSpread({}, this.businessHourStatus.always_open);\n          return true;\n        }\n\n        var currentHour = this.convertTimeToNumber(this.getHours(businessHours.timezone, \"h24\"));\n        var lastCloseHour = todayBusinessHour.firstCloseHour;\n        var lastOpenHour = todayBusinessHour.firstOpenHour;\n\n        if (currentHour >= todayBusinessHour.firstOpenHour && currentHour <= todayBusinessHour.firstCloseHour) {\n          this.businessHourToday = _objectSpread({}, this.businessHourStatus.open);\n          return true;\n        }\n\n        if (todayBusinessHour.secondCloseHour !== todayBusinessHour.secondOpenHour && !isNaN(todayBusinessHour.secondOpenHour) && !isNaN(todayBusinessHour.secondCloseHour)) {\n          lastCloseHour = todayBusinessHour.secondOpenHour;\n          lastOpenHour = todayBusinessHour.secondOpenHour;\n\n          if (currentHour >= todayBusinessHour.secondOpenHour && currentHour <= todayBusinessHour.secondCloseHour) {\n            this.businessHourToday = _objectSpread({}, this.businessHourStatus.open);\n            return true;\n          }\n        } // This is special case: Some businesses may close over middle night. We allows maximum 07:10 AM, so the business hour must smaller than 05:00:00 AM\n\n\n        if (currentHour > lastOpenHour && currentHour < 235959 && lastCloseHour <= 71000) {\n          this.businessHourToday = _objectSpread({}, this.businessHourStatus.open);\n          return true;\n        }\n\n        var prevDayBusinessHour = _objectSpread({}, businessHours.operating_times[this.previousDayKey(businessHours.timezone)]);\n\n        prevDayBusinessHour = this.covertBusinessHourToNumber(prevDayBusinessHour);\n\n        if (this.isTurnOffBusinessHour(prevDayBusinessHour)) {\n          this.businessHourToday = _objectSpread({}, this.businessHourStatus.close);\n          return true;\n        }\n\n        var prevDayLastBusinessHour = this.findLastBusinessHour(prevDayBusinessHour);\n\n        if (prevDayLastBusinessHour.lastClose > 71000) {\n          this.businessHourToday = _objectSpread({}, this.businessHourStatus.close);\n          return true;\n        }\n\n        console.log(currentHour, currentHour < prevDayLastBusinessHour.lastClose, prevDayLastBusinessHour, this.previousDayKey(businessHours.timezone));\n\n        if (currentHour < prevDayLastBusinessHour.lastClose) {\n          this.businessHourToday = _objectSpread({}, this.businessHourStatus.open);\n          return true;\n        }\n\n        this.businessHourToday = _objectSpread({}, this.businessHourStatus.close);\n        return true;\n      }\n    }\n  }\n};\n\n\n//# sourceURL=webpack:///./assets/dev/js/mixins/TimeHelper.js?");

/***/ })

}]);