<?php

BoldThemes_Customize_Default::$data['body_font'] = 'Roboto';
BoldThemes_Customize_Default::$data['heading_supertitle_font'] = 'Roboto';
BoldThemes_Customize_Default::$data['heading_font'] = 'Roboto';
BoldThemes_Customize_Default::$data['heading_subtitle_font'] = 'Roboto';
BoldThemes_Customize_Default::$data['menu_font'] = 'Roboto';

BoldThemes_Customize_Default::$data['accent_color'] = '#FFAE02';
BoldThemes_Customize_Default::$data['alternate_color'] = '#0529A3';
BoldThemes_Customize_Default::$data['logo_height'] = '80';

BoldThemes_Customize_Default::$data['template_skin'] = 'light';
BoldThemes_Customize_Default::$data['buttons_shape'] = 'hard-rounded';
// BoldThemes_Customize_Default::$data['heading_style'] = 'default';

BoldThemes_Customize_Default::$data['sidebar_use_dash'] = true;
BoldThemes_Customize_Default::$data['blog_use_dash'] = true;
BoldThemes_Customize_Default::$data['pf_use_dash'] = true;

BoldThemes_Customize_Default::$data['boxed_menu'] = false;
BoldThemes_Customize_Default::$data['sticky_header'] = true;


if ( function_exists( 'bt_bb_remove_params' ) ) {
	bt_bb_remove_params( "bt_bb_section", 'layout' );
	bt_bb_remove_params( "bt_bb_section", 'background_overlay' );
}

if ( function_exists( 'bt_bb_add_params' ) ) {

	bt_bb_add_params( 'bt_bb_section', array(

		array( 'param_name' => 'layout', 'type' => 'dropdown', 'default' => 'boxed_1200', 'heading' => __( 'Layout', 'wheelco' ), 'group' => __( 'General', 'wheelco' ), 'weight' => 0, 'preview' => true,
			'value' => array(
				__( 'Boxed (800px)', 'wheelco' ) => 'boxed_800',
				__( 'Boxed (900px)', 'wheelco' ) => 'boxed_900',
				__( 'Boxed (1000px)', 'wheelco' ) => 'boxed_1000',
				__( 'Boxed (1100px)', 'wheelco' ) => 'boxed_1100',
				__( 'Boxed (1200px)', 'wheelco' ) => 'boxed_1200',
				__( 'Boxed (1300px)', 'wheelco' ) => 'boxed_1300',
				__( 'Boxed (1400px)', 'wheelco' ) => 'boxed_1400',
				__( 'Boxed (1500px)', 'wheelco' ) => 'boxed_1500',
				__( 'Boxed (1600px)', 'wheelco' ) => 'boxed_1600',
				__( 'Boxed right (1200px)', 'wheelco' ) => 'boxed_right_1200',
				__( 'Boxed left (1200px)', 'wheelco' ) => 'boxed_left_1200',
				__( 'Wide', 'wheelco' ) => 'wide'
			)
		),

		array( 'param_name' => 'background_overlay', 'type' => 'dropdown', 'heading' => __( 'Background overlay', 'wheelco' ), 'group' => __( 'Design', 'wheelco' ), 'weight' => 4, 
			'value' => array(
				__( 'No overlay', 'wheelco' )    => '',
				__( 'Light stripes', 'wheelco' ) => 'light_stripes',
				__( 'Dark stripes', 'wheelco' )  => 'dark_stripes',
				__( 'Light solid', 'wheelco' )	  => 'light_solid',
				__( 'Dark solid', 'wheelco' )	  => 'dark_solid',
				__( 'Light gradient', 'wheelco' )	  => 'light_gradient',
				__( 'Dark gradient', 'wheelco' )	  => 'dark_gradient',
				__( 'Accent gradient', 'wheelco' )	  => 'accent_gradient',
				__( 'Alternate gradient', 'wheelco' )	  => 'alternate_gradient'
			)
		),

		array( 'param_name' => 'top_negative_margin', 'type' => 'dropdown', 'heading' => __( 'Top negative margin', 'wheelco' ), 'preview' => true,
			'value' => array(
				__( 'No margin', 'wheelco' ) => '',
				__( 'Extra small', 'wheelco' ) => 'extra_small',
				__( 'Small', 'wheelco' ) => 'small',		
				__( 'Normal', 'wheelco' ) => 'normal',
				__( 'Medium', 'wheelco' ) => 'medium',
				__( 'Large', 'wheelco' ) => 'large',
				__( 'Extra large', 'wheelco' ) => 'extra_large'
			)
		),

		array( 'param_name' => 'bottom_negative_margin', 'type' => 'dropdown', 'heading' => __( 'Bottom negative margin', 'wheelco' ), 'preview' => true,
			'value' => array(
				__( 'No margin', 'wheelco' ) => '',
				__( 'Extra small', 'wheelco' ) => 'extra_small',
				__( 'Small', 'wheelco' ) => 'small',		
				__( 'Normal', 'wheelco' ) => 'normal',
				__( 'Medium', 'wheelco' ) => 'medium',
				__( 'Large', 'wheelco' ) => 'large',
				__( 'Extra large', 'wheelco' ) => 'extra_large'
			)
		),

		array( 'param_name' => 'highlighted', 'type' => 'dropdown', 'heading' => __( 'Highlighted section', 'wheelco' ), 'group' => __( 'Design', 'wheelco' ), 'preview' => true,
			'value' => array(
				__( 'No', 'wheelco' ) => 'no',
				__( 'Outline', 'wheelco' ) => 'outline'
			)
		)
	) );
}

function load_and_go_bt_bb_section_class( $class, $atts ) {

	if ( isset( $atts['top_negative_margin'] ) && $atts['top_negative_margin'] != '' ) {
		$class[] = 'bt_bb_top_negative_margin' . '_' . $atts['top_negative_margin'];
	}
	
	if ( isset( $atts['bottom_negative_margin'] ) && $atts['bottom_negative_margin'] != '' ) {
		$class[] = 'bt_bb_bottom_negative_margin' . '_' . $atts['bottom_negative_margin'];
	}

	if ( isset( $atts['highlighted'] ) && $atts['highlighted'] != '' ) {
		$class[] = 'bt_bb_highlighted' . '_' . $atts['highlighted'];
	}

	return $class;
}
add_filter( 'bt_bb_section_class', 'load_and_go_bt_bb_section_class', 10, 2 );

// NEW PARAM: COUNTER WEIGHT

if ( function_exists( 'bt_bb_add_params' ) ) {
	bt_bb_add_params( 'bt_bb_counter', array(
		array( 
			'param_name' => 'font_weight', 
			'type' 		=> 'dropdown', 
			'default' 	=> 'normal', 
			'heading' 	=> __( 'Weight', 'wheelco' ), 
			'group' 	=> __( 'General', 'wheelco' ), 
			'weight' 	=> 3, 
			'preview' 	=> true,
			'value' 	=> array(
				__( 'Light', 'wheelco' ) => 'light',
				__( 'Normal', 'wheelco' ) => 'normal',
				__( 'Bold', 'wheelco' ) => 'bold',
			)
		)
	) );
}

function load_and_go_bt_bb_counter_class( $class, $atts ) {
	if ( isset( $atts['font_weight'] ) && $atts['font_weight'] != '' ) {
		$class[] = 'bt_bb_font_weight_' . $atts['font_weight'];
	}
	return $class;
}
add_filter( 'bt_bb_counter_class', 'load_and_go_bt_bb_counter_class', 10, 2 );

// NEW PARAM: COLUMN HIGHLIGHT

if ( function_exists( 'bt_bb_add_params' ) ) {
	bt_bb_add_params( 'bt_bb_column', array(
		array( 'param_name' => 'highlighted',
			'type' => 'dropdown',
			'heading' => __( 'Highlighted column', 'wheelco' ),
			'group' => __( 'Design', 'wheelco' ),
			'preview' => true,
			'value' => array(
				__( 'No', 'wheelco' ) => 'no',
				__( 'Outline', 'wheelco' ) => 'outline',
				__( 'Shadow', 'wheelco' ) => 'shadow'
			)
		)
	) );
}

function load_and_go_bt_bb_column_class( $class, $atts ) {
	if ( isset( $atts['highlighted'] ) && $atts['highlighted'] != '' ) {
		$class[] = 'bt_bb_highlighted' . '_' . $atts['highlighted'];
	}
	return $class;
}
add_filter( 'bt_bb_column_class', 'load_and_go_bt_bb_column_class', 10, 2 );

// NEW PARAM: COLUMN INNER HIGHLIGHT

if ( function_exists( 'bt_bb_add_params' ) ) {
	bt_bb_add_params( 'bt_bb_column_inner', array(
		array( 'param_name' => 'highlighted',
			'type' => 'dropdown',
			'heading' => __( 'Highlighted column', 'wheelco' ),
			'group' => __( 'Design', 'wheelco' ),
			'preview' => true,
			'value' => array(
				__( 'No', 'wheelco' ) => 'no',
				__( 'Yes', 'wheelco' ) => 'outline'
			)
		)
	) );
}

function load_and_go_bt_bb_column_inner_class( $class, $atts ) {
	if ( isset( $atts['highlighted'] ) && $atts['highlighted'] != '' ) {
		$class[] = 'bt_bb_highlighted' . '_' . $atts['highlighted'];
	}
	return $class;
}
add_filter( 'bt_bb_column_inner_class', 'load_and_go_bt_bb_column_inner_class', 10, 2 );

// NEW PARAM: CONTENT SLIDER ITEM HIGHLIGHT

if ( function_exists( 'bt_bb_add_params' ) ) {
	bt_bb_add_params( 'bt_bb_content_slider_item', array(
		array( 'param_name' => 'highlighted',
			'type' => 'dropdown',
			'heading' => __( 'Highlighted slider item', 'wheelco' ),
			'group' => __( 'General', 'wheelco' ),
			'preview' => true,
			'value' => array(
				__( 'No', 'wheelco' ) => 'no',
				__( 'Outline', 'wheelco' ) => 'outline'
			)
		)
	) );
}

function load_and_go_bt_bb_content_slider_item_class( $class, $atts ) {
	if ( isset( $atts['highlighted'] ) && $atts['highlighted'] != '' ) {
		$class[] = 'bt_bb_highlighted' . '_' . $atts['highlighted'];
	}
	return $class;
}
add_filter( 'bt_bb_content_slider_item_class', 'load_and_go_bt_bb_content_slider_item_class', 10, 2 );

// PARAM: ICON SIZE

if ( function_exists( 'bt_bb_remove_params' ) ) {
	bt_bb_remove_params( 'bt_bb_icon', 'size' );
}

if ( function_exists( 'bt_bb_add_params' ) ) {
	bt_bb_add_params( 'bt_bb_icon', array(
		array( 'param_name' => 'size', 
			'type' => 'dropdown', 
			'heading' => __( 'Size', 'wheelco' ), 
			'preview' => true,
			'value' => array(
				__( 'Small', 'wheelco' ) => 'small',
				__( 'Extra small', 'wheelco' ) => 'xsmall',
				__( 'Normal', 'wheelco' ) => 'normal',
				__( 'Large', 'wheelco' ) => 'large',
				__( 'Extra large', 'wheelco' ) => 'xlarge',
				__( 'Huge', 'wheelco' ) => 'huge'
			)
		),
	) );
}