<?php

class bt_bb_service extends BT_BB_Element {

	function handle_shortcode( $atts, $content ) {
		extract( shortcode_atts( apply_filters( 'bt_bb_extract_atts', array(
			'icon'         => '',
			'supertitle'   => '',
			'title'        => '',
			'text'         => '',
			'url'          => '',
			'target'       => '',
			'color_scheme' => '',
			'style'        => '',
			'size'         => '',
			'title_size'   => '',
			'shape'        => '',
			'align'        => ''
		) ), $atts, $this->shortcode ) );

		$class = array( $this->shortcode );

		if ( $el_class != '' ) {
			$class[] = $el_class;
		}

		$id_attr = '';
		if ( $el_id != '' ) {
			$id_attr = ' ' . 'id="' . $el_id . '"';
		}

		$style_attr = '';
		if ( $el_style != '' ) {
			$style_attr = ' ' . 'style="' . $el_style . '"';
		}
		
		if ( $color_scheme != '' ) {
			$class[] = $this->prefix . 'color_scheme_' . bt_bb_get_color_scheme_id( $color_scheme );
		}		

		if ( $style != '' ) {
			$class[] = $this->prefix . 'style' . '_' . $style;
		}

		if ( $size != '' ) {
			$class[] = $this->prefix . 'size' . '_' . $size;
		}

		if ( $title_size != '' ) {
			$class[] = $this->prefix . 'title_size' . '_' . $title_size;
		}

		if ( $shape != '' ) {
			$class[] = $this->prefix . 'shape' . '_' . $shape;
		}
		
		if ( $align != '' ) {
			$class[] = $this->prefix . 'align' . '_' . $align;
		}
		
		if ( $url != '' ) {
			$title = '<a href="' . $url . '" target="' . $target . '">' . $title . '</a>';
		} 

		$icon = bt_bb_icon::get_html( $icon, '', $url, $target );
		
		$class = apply_filters( $this->shortcode . '_class', $class, $atts );

		$output = $icon;

		$output .= '<div class="' . $this->shortcode . '_content">';
			$output .= '<div class="' . $this->shortcode . '_content_title">';
				if ( $supertitle != '' ) $output .= '<div class="' . $this->shortcode . '_content_supertitle">' . $supertitle . '</div>';
				$output .= '<div class="' . $this->shortcode . '_content_title_inner">' . $title . '</div>';
			$output .= '</div>';	
			$output .= '<div class="' . $this->shortcode . '_content_text">' . nl2br( $text ) . '</div>';
		$output .= '</div>';

		$output = '<div' . $id_attr . ' class="' . implode( ' ', $class ) . '"' . $style_attr . '>' . $output . '</div>';

		$output = apply_filters( 'bt_bb_general_output', $output, $atts );
		$output = apply_filters( $this->shortcode . '_output', $output, $atts );

		return $output;

	}

	function map_shortcode() {

		if ( function_exists('boldthemes_get_icon_fonts_bb_array') ) {
			$icon_arr = boldthemes_get_icon_fonts_bb_array();
		} else {
			$icon_arr = array( 'Font Awesome' => bt_bb_fa_icons(), 'S7' => bt_bb_s7_icons() );
		}

		$color_scheme_arr = bt_bb_get_color_scheme_param_array();

		bt_bb_map( $this->shortcode, array( 'name' => __( 'Service', 'wheelco' ), 'description' => __( 'Icon with text', 'wheelco' ), 'icon' => $this->prefix_backend . 'icon' . '_' . $this->shortcode,
			'params' => array(
				array( 'param_name' => 'icon', 'type' => 'iconpicker', 'heading' => __( 'Icon', 'wheelco' ), 'value' => $icon_arr, 'preview' => true ),
				array( 'param_name' => 'supertitle', 'type' => 'textfield', 'heading' => __( 'Supertitle', 'wheelco' ), 'preview' => true ),
				array( 'param_name' => 'title', 'type' => 'textfield', 'heading' => __( 'Title', 'wheelco' ), 'preview' => true ),
				array( 'param_name' => 'text', 'type' => 'textarea', 'heading' => __( 'Text', 'wheelco' ) ),
				array( 'param_name' => 'url', 'type' => 'textfield', 'heading' => __( 'URL', 'wheelco' ) ),
				array( 'param_name' => 'target', 'type' => 'dropdown', 'heading' => __( 'Target', 'wheelco' ),
					'value' => array(
						__( 'Self (open in same tab)', 'wheelco' ) => '_self',
						__( 'Blank (open in new tab)', 'wheelco' ) => '_blank',
					)
				),
				array( 'param_name' => 'align', 'type' => 'dropdown', 'heading' => __( 'Icon alignment', 'wheelco' ),
					'value' => array(
						__( 'Inherit', 'wheelco' ) => 'inherit',
						__( 'Left', 'wheelco' ) => 'left',
						__( 'Right', 'wheelco' ) => 'right'
					)
				),
				array( 'param_name' => 'size', 'type' => 'dropdown', 'heading' => __( 'Icon size', 'wheelco' ), 'preview' => true, 'group' => __( 'Design', 'wheelco' ),
					'value' => array(
						__( 'Small', 'wheelco' ) => 'small',
						__( 'Extra small', 'wheelco' ) => 'xsmall',
						__( 'Normal', 'wheelco' ) => 'normal',
						__( 'Large', 'wheelco' ) => 'large',
						__( 'Extra large', 'wheelco' ) => 'xlarge'
					)
				),
				array( 'param_name' => 'title_size', 'type' => 'dropdown', 'heading' => __( 'Title size', 'wheelco' ), 'preview' => true, 'group' => __( 'Design', 'wheelco' ),
					'value' => array(
						__( 'Normal + Bold', 'wheelco' ) => 'normal_bold',
						__( 'Normal', 'wheelco' ) => 'normal',
						__( 'Large', 'wheelco' ) => 'large',
						__( 'Large + Bold', 'wheelco' ) => 'large_bold'
					)
				),
				array( 'param_name' => 'color_scheme', 'type' => 'dropdown', 'heading' => __( 'Color scheme', 'wheelco' ), 'value' => $color_scheme_arr, 'preview' => true, 'group' => __( 'Design', 'wheelco' ) ),
				array( 'param_name' => 'style', 'type' => 'dropdown', 'heading' => __( 'Icon style', 'wheelco' ), 'preview' => true, 'group' => __( 'Design', 'wheelco' ),
					'value' => array(
						__( 'Outline', 'wheelco' ) => 'outline',
						__( 'Filled', 'wheelco' ) => 'filled',
						__( 'Borderless', 'wheelco' ) => 'borderless'
					)
				),
				array( 'param_name' => 'shape', 'type' => 'dropdown', 'heading' => __( 'Icon shape', 'wheelco' ), 'group' => __( 'Design', 'wheelco' ),
					'value' => array(
						__( 'Circle', 'wheelco' ) => 'circle',
						__( 'Square', 'wheelco' ) => 'square',
						__( 'Rounded Square', 'wheelco' ) => 'round'
					)
				)
			)
		) );
	}
}