<?php
/**
 * Description tab
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/tabs/description.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 2.0.0
 */

defined( 'ABSPATH' ) || exit;

global $post;

$heading = apply_filters( 'woocommerce_product_description_heading', __( 'Description', 'woocommerce' ) );

$title_type = 'h2';
$title_tabs = get_option( 'wescle_woo_tab_title', [] );
if ( $title_tabs && isset( $title_tabs['description']['heading_tag'] ) ) {
    $title_type = $title_tabs['description']['heading_tag'];
}
?>

<?php if ( $heading ) : ?>
    <?php printf( '<%1$s>' . esc_html( $heading ) . '</%1$s>', $title_type ); ?>
<?php endif; ?>

<?php the_content(); ?>
