<?php
/**
 * Related Products
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/related.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see         https://docs.woocommerce.com/document/template-structure/
 * @package     WooCommerce\Templates
 * @version     3.9.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$title      = '';
$title_type = 'div';
$text       = '';

if ( ! isset( $action_args['args']['key_block'] ) || ! $action_args['args']['key_block'] ) {
	$key_block  = 'related';
	$title      = get_theme_mod( 'product_related_title', Helper::get_default_theme_data( 'product_related_title' ) );
	$title_type = get_theme_mod( 'product_related_title_type', 'div' );

}
else {
	$key_block = $action_args['args']['key_block'];

	if ( 'viewed' == $key_block ) {
		$title      = get_theme_mod( 'product_viewed_title', Helper::get_default_theme_data( 'product_viewed_title' ) );
		$title_type = get_theme_mod( 'product_viewed_title_type', 'div' );
	}
}

$isset_slider  = true;
$section_class = 'goods-slider-section';
$slider_class  = 'goods-slider-section__slider';
if ( 'related' === $key_block ) {
	if ( false === get_theme_mod( 'product_related_slider', true ) ) {
		$isset_slider = false;
	}
}
if ( 'viewed' === $key_block ) {
	if ( false === get_theme_mod( 'product_viewed_slider', true ) ) {
		$isset_slider = false;
	}
}

if ( ! $isset_slider ) {
	$section_class = 'goods-slider-section goods-noslider';
	$slider_class  = 'goods-slider-section__grid';
}

if ( $related_products ) : ?>
    <div class="<?php echo $section_class; ?>" id="goods-slider-<?php echo $key_block; ?>" data-slides="4">
        <div class="container">
            <div class="slider-wrapper">
                <div class="goods-slider-section__header">
                    <div class="goods-slider-section__about">
						<?php
						if ( $title ) {
							printf( '<%1$s class="goods-slider-section__title title title_divider">' . $title . '</%1$s>', $title_type );
						}
						?>
						<?php if ( $text ) { ?>
                            <div class="goods-slider-section__text"><?php echo $text; ?></div>
						<?php } ?>
                    </div>
					<?php if ( $isset_slider ) { ?>
                        <div class="goods-slider-section__buttons slider-buttons">
                            <button class="slider-buttons__item slider-buttons__item_prev" type="button">
                                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(180deg); -webkit-transform: rotate(180deg); transform: rotate(180deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 42 42">
                                    <path fill-rule="evenodd" d="M11 38.32L28.609 21L11 3.68L13.72 1L34 21.01L13.72 41z" fill="white"></path>
                                </svg>
                            </button>
                            <button class="slider-buttons__item slider-buttons__item_next" type="button">
                                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 42 42">
                                    <path fill-rule="evenodd" d="M11 38.32L28.609 21L11 3.68L13.72 1L34 21.01L13.72 41z" fill="white"></path>
                                </svg>
                            </button>
                        </div>
					<?php } ?>
                </div>
                <div class="<?php echo $slider_class; ?> goods-slider-<?php echo $key_block; ?>__slider" data-dots="false" data-arrows="true">
					<?php foreach ( $related_products as $related_product ) : ?>

						<?php
						$post_object = get_post( $related_product->get_id() );

						setup_postdata( $GLOBALS['post'] =& $post_object ); // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited, Squiz.PHP.DisallowMultipleAssignments.Found

						get_template_part( 'template-parts/section/woo-products', 'item', [ 'isset_slider' => $isset_slider ] );
						?>

					<?php endforeach; ?>
                </div>
            </div>
        </div>
    </div>
<?php
endif;

wp_reset_postdata();
