<?php
/**
 * Single Product Meta
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/meta.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see         https://docs.woocommerce.com/document/template-structure/
 * @package     WooCommerce\Templates
 * @version     3.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

global $product;
?>
<div class="product_meta">

	<?php do_action( 'woocommerce_product_meta_start' ); ?>

	<?php if ( wc_product_sku_enabled() && ( $product->get_sku() || $product->is_type( 'variable' ) ) ) : ?>

        <span class="sku_wrapper"><?php esc_html_e( 'SKU:', 'woocommerce' ); ?> <span class="sku"><?php echo ( $sku = $product->get_sku() ) ? $sku : esc_html__( 'N/A', 'woocommerce' ); ?></span></span>

	<?php endif; ?>

	<?php if ( get_theme_mod( 'product_meta_category', true ) ) { ?>
		<?php echo wc_get_product_category_list( $product->get_id(), ', ', '<span class="posted_in">' . _n( 'Category:', 'Categories:', count( $product->get_category_ids() ), 'woocommerce' ) . ' ', '</span>' ); ?>
	<?php } ?>

	<?php if ( get_theme_mod( 'product_meta_tag', true ) ) { ?>
		<?php echo wc_get_product_tag_list( $product->get_id(), ', ', '<span class="tagged_as">' . _n( 'Tag:', 'Tags:', count( $product->get_tag_ids() ), 'woocommerce' ) . ' ', '</span>' ); ?>
	<?php } ?>

	<?php
	$brand_taxonomy = get_theme_mod( 'woo_brands_taxonomy' );
	if ( $brand_taxonomy ) {
		$terms_brand = get_the_terms( $product->get_id(), $brand_taxonomy );
		if ( $terms_brand ) {
			echo '<div class="brands__grid">';
			foreach ( $terms_brand as $term ) {
				$image_html = get_brand_image_html( $term );
				if ( ! $image_html ) {
					continue;
				}
				?>
                <a class="brands-item" href="<?php echo get_term_link( $term ); ?>">
                    <div class="brands-item__image">
						<?php echo $image_html; ?>
                    </div>
                </a>
				<?php
			}
			echo '</div>';
		}
	}
	?>

	<?php do_action( 'woocommerce_product_meta_end' ); ?>

</div>
