<?php
/**
 * Pagination - Show numbered pagination for catalog pages
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/loop/pagination.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.3.1
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$total   = isset( $total ) ? $total : wc_get_loop_prop( 'total_pages' );
$current = isset( $current ) ? $current : wc_get_loop_prop( 'current_page' );
$base    = isset( $base ) ? $base : esc_url_raw( str_replace( 999999999, '%#%', remove_query_arg( 'add-to-cart', get_pagenum_link( 999999999, false ) ) ) );
$format  = isset( $format ) ? $format : '';

if ( $total <= 1 ) {
	return;
}
?>
<nav class="woocommerce-pagination">
	<?php
	$paginate_links = paginate_links(
		apply_filters(
			'woocommerce_pagination_args',
			array( // WPCS: XSS ok.
				'base'      => $base,
				'format'    => $format,
				'add_args'  => false,
				'current'   => max( 1, $current ),
				'total'     => $total,
				'prev_text' => '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(180deg); -webkit-transform: rotate(180deg); transform: rotate(180deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 42 42"><path fill-rule="evenodd" d="M11 38.32L28.609 21L11 3.68L13.72 1L34 21.01L13.72 41z" fill="white"></path></svg>',
				'next_text' => '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 42 42"><path fill-rule="evenodd" d="M11 38.32L28.609 21L11 3.68L13.72 1L34 21.01L13.72 41z" fill="white"></path></svg>',
				'type'      => 'array',
				'end_size'  => 3,
				'mid_size'  => 3,
			)
		)
	);

	if ( $paginate_links && is_array( $paginate_links ) ) {
		if ( $total > 4 ) {
			$c       = $current;
			$allowed = [
				' current',
				'prev ',
				'next ',
				sprintf( '/page/%d/', $c - 2 ),
				sprintf( '/page/%d/', $c - 1 ),
				sprintf( '/page/%d/', $c + 1 ),
				sprintf( '/page/%d/', $c + 2 ),
			];
			if ( $c == 2 || $c == 3 ) {
				$allowed[] = '>1<';
			}
			$paginate_links = array_filter(
				$paginate_links,
				function ( $value ) use ( $allowed ) {
					foreach ( (array) $allowed as $tag ) {
						if ( false !== strpos( $value, $tag ) ) {
							return true;
						}
					}

					return false;
				}
			);
		}

		$pagination = '<ul class="pagination__list page-numbers">';

		foreach ( $paginate_links as $paginate_link ) {
			$paginate_link = str_replace( 'page-numbers', 'pagination__link', $paginate_link );
			$paginate_link = str_replace( 'prev ', 'prev pagination__link_prev ', $paginate_link );
			$paginate_link = str_replace( 'next ', 'next pagination__link_next ', $paginate_link );
			$paginate_link = str_replace( ' current', ' pagination__link_current ', $paginate_link );
			$paginate_link = str_replace( '/page/1/', '', $paginate_link );

			$pagination .= '<li class="pagination__item">';
			$pagination .= $paginate_link;
			$pagination .= '</li>';
		}
		$pagination .= '</ul>';

		echo $pagination;
	}
	else {
		echo $paginate_links;
	}
	?>
</nav>
