<?php
/**
 * The template for displaying product content within loops
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.6.0
 *
 * @var $product WC_Product
 */

defined( 'ABSPATH' ) || exit;

global $product;

// Ensure visibility.
if ( empty( $product ) || ! $product->is_visible() ) {
	return;
}

$link              = $product->get_permalink();
$is_show_category  = get_theme_mod( 'product_category_enabled', true );
$text_view_product = get_theme_mod( 'view_product', Helper::get_default_theme_data( 'view_product' ) );
$text_quick_view   = get_theme_mod( 'quick_view', Helper::get_default_theme_data( 'quick_view' ) );
?>
<div <?php wc_product_class( 'goods-body__col', $product ); ?>>
    <div class="product-cart">
        <div class="product-cart__grid">
            <div class="product-cart__grid-inner">
                <div class="product-cart__body">
                    <figure>
						<?php wescle_loop_badges_product(); ?>
                        <div class="product-cart__image">
                            <a href="<?php echo $product->get_permalink(); ?>"><?php woocommerce_template_loop_product_thumbnail(); ?></a>
                        </div>
                        <div class="product-cart__quick-view">
                            <a href="<?php echo $product->get_permalink(); ?>">
                                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" role="img" width="1em" height="1em" preserveAspectRatio="xMidYMid meet" viewBox="0 0 1024 1024">
                                    <path d="M574 665.4a8.03 8.03 0 0 0-11.3 0L446.5 781.6c-53.8 53.8-144.6 59.5-204 0c-59.5-59.5-53.8-150.2 0-204l116.2-116.2c3.1-3.1 3.1-8.2 0-11.3l-39.8-39.8a8.03 8.03 0 0 0-11.3 0L191.4 526.5c-84.6 84.6-84.6 221.5 0 306s221.5 84.6 306 0l116.2-116.2c3.1-3.1 3.1-8.2 0-11.3L574 665.4zm258.6-474c-84.6-84.6-221.5-84.6-306 0L410.3 307.6a8.03 8.03 0 0 0 0 11.3l39.7 39.7c3.1 3.1 8.2 3.1 11.3 0l116.2-116.2c53.8-53.8 144.6-59.5 204 0c59.5 59.5 53.8 150.2 0 204L665.3 562.6a8.03 8.03 0 0 0 0 11.3l39.8 39.8c3.1 3.1 8.2 3.1 11.3 0l116.2-116.2c84.5-84.6 84.5-221.5 0-306.1zM610.1 372.3a8.03 8.03 0 0 0-11.3 0L372.3 598.7a8.03 8.03 0 0 0 0 11.3l39.6 39.6c3.1 3.1 8.2 3.1 11.3 0l226.4-226.4c3.1-3.1 3.1-8.2 0-11.3l-39.5-39.6z"
                                          fill="currentColor"></path>
                                </svg>
                                <span><?php echo $text_view_product; ?></span>
                            </a>
							<?php if ( get_theme_mod( 'product_quick_view_enabled' ) ) { ?>
                                <a href="#" data-id="<?php echo $product->get_id(); ?>" class="link__quick-view">
                                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 36 36">
                                        <path class="clr-i-solid clr-i-solid-path-1" d="M33.62 17.53c-3.37-6.23-9.28-10-15.82-10S5.34 11.3 2 17.53l-.28.47l.26.48c3.37 6.23 9.28 10 15.82 10s12.46-3.72 15.82-10l.26-.48zm-15.82 8.9C12.17 26.43 7 23.29 4 18c3-5.29 8.17-8.43 13.8-8.43S28.54 12.72 31.59 18c-3.05 5.29-8.17 8.43-13.79 8.43z" fill="#626262"></path>
                                        <circle class="clr-i-solid clr-i-solid-path-2" cx="18.09" cy="18.03" r="4.5" fill="#626262"></circle>
                                    </svg>
                                    <span><?php echo $text_quick_view; ?></span>
                                </a>
							<?php } ?>
                        </div>
                    </figure>
                </div>
				<?php if ( $is_show_category ) { ?>
                    <div class="product-cart__categories">
						<?php echo str_replace( '<a', '<a class="category"', wc_get_product_category_list( $product->get_id(), ' ', '', '' ) ); ?>
                    </div>
				<?php } ?>
				<?php if ( get_theme_mod( 'product_price_before_title', false ) ) { ?>
					<?php do_action( 'woocommerce_before_shop_loop_price' ); ?>
                    <div class="price product-cart__price">
						<?php echo $product->get_price_html(); ?>
                    </div>
					<?php do_action( 'woocommerce_shop_loop_price' ); ?>
				<?php } ?>
				<?php do_action( 'woocommerce_before_shop_loop_item_title' ); ?>
                <div class="product-cart__name"><a href="<?php echo $link; ?>"><?php echo get_the_title(); ?></a></div>
				<?php do_action( 'woocommerce_shop_loop_item_title' ); ?>
                <div class="product-cart__about">
                    <div class="product-cart__about-text">
						<?php
						$length_excerpt = apply_filters( 'wescle_product_excerpt_length', 600 );
						if ( $product->get_short_description() ) {
							echo wpautop( $product->get_short_description() );
						}
						else {
							echo wpautop( Helper::short_string( wp_strip_all_tags( $product->get_description() ), $length_excerpt ) );
						}
						?>
						<?php
						if ( $product->get_short_description() || $product->get_description() ) {
							$text_open  = Helper::get_text_label( 'open' );
							$text_close = Helper::get_text_label( 'close' );
							?>
                            <button class="btn_expand js-hide" type="button" data-text-open="<?php echo $text_open; ?>" data-text-close="<?php echo $text_close; ?>" data-height="200">
                                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 24 24">
                                    <g fill="none">
                                        <path d="M4 9l8 8l8-8" stroke="#626262" stroke-width="3" stroke-linecap="round" stroke-linejoin="round"></path>
                                    </g>
                                </svg>
                                <span><?php echo $text_open; ?></span>
                            </button>
							<?php
						}
						?>
                    </div>
                </div>
                <div class="product-cart__meta">
	                <?php if ( ! get_theme_mod( 'product_price_before_title', false ) ) { ?>
		                <?php do_action( 'woocommerce_before_shop_loop_price' ); ?>
                        <span class="price product-cart__price">
                            <?php echo $product->get_price_html(); ?>
                        </span>
		                <?php do_action( 'woocommerce_shop_loop_price' ); ?>
	                <?php } ?>
                </div>
            </div>
            <div class="product-cart__group-buttons">
		        <?php wescle_compare_loop_item(); ?>
                <div class="product-cart__add-cart">
			        <?php woocommerce_template_loop_add_to_cart(); ?>
                </div>
		        <?php wescle_wishlist_after_cart_form(); ?>
            </div>
        </div>
    </div>
</div>

<?php
/**
 * Hook: woocommerce_before_shop_loop_item.
 *
 * @hooked woocommerce_template_loop_product_link_open - 10
 */
//do_action( 'woocommerce_before_shop_loop_item' );

/**
 * Hook: woocommerce_before_shop_loop_item_title.
 *
 * @hooked woocommerce_show_product_loop_sale_flash - 10
 * @hooked woocommerce_template_loop_product_thumbnail - 10
 */
//do_action( 'woocommerce_before_shop_loop_item_title' );

/**
 * Hook: woocommerce_shop_loop_item_title.
 *
 * @hooked woocommerce_template_loop_product_title - 10
 */
//do_action( 'woocommerce_shop_loop_item_title' );

/**
 * Hook: woocommerce_after_shop_loop_item_title.
 *
 * @hooked woocommerce_template_loop_rating - 5
 * @hooked woocommerce_template_loop_price - 10
 */
//do_action( 'woocommerce_after_shop_loop_item_title' );

/**
 * Hook: woocommerce_after_shop_loop_item.
 *
 * @hooked woocommerce_template_loop_product_link_close - 5
 * @hooked woocommerce_template_loop_add_to_cart - 10
 */
//do_action( 'woocommerce_after_shop_loop_item' );
?>

