<?php
/**
 * The template for displaying product category thumbnails within loops
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-product-cat.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 4.7.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$slider_enable = get_theme_mod( 'category_slider_enable', true );
?>
<?php if ( $slider_enable ) { ?>
<div class="goods-categories__slide product-category">
	<?php } ?>
    <a class="goods-categories-item" href="<?php echo esc_url( get_term_link( $category, 'product_cat' ) ); ?>">
        <div class="goods-categories-item__image">
			<?php do_action( 'woocommerce_before_subcategory_title', $category ); ?>
        </div>
        <div class="goods-categories-item__body">
			<?php
			if ( $category->count > 0 ) {
				// phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
				echo apply_filters( 'woocommerce_subcategory_count_html', '<div class="goods-categories-item__count">' . esc_html( $category->count ) . '</div>', $category );
			}
			?>
            <div class="goods-categories-item__title"><?php echo esc_html( $category->name ); ?></div>
        </div>
    </a>
	<?php if ( $slider_enable ) { ?>
</div>
<?php } ?>
