<?php
/**
 * Template Name: Wishlist
 * Template Post Type: page
 *
 */

get_header();
?>
    <div class="content">
        <div class="container">
            <div class="row content__row">
                <div class="col content__col content__col_big">
                    <div class="content__body">
			            <?php get_template_part( 'template-parts/breadcrumbs' ); ?>

			            <?php
			            $is_plugin_shortcode   = has_shortcode( $post->post_content, 'ti_wishlistsview' );
			            $is_plugin_ti_wishlist = Helper::is_plugin_active( 'ti-woocommerce-wishlist/ti-woocommerce-wishlist.php' )
			            ?>
                        <section class="seo seo_top" id="seo-top">
                            <div class="container">
					            <?php get_template_part( 'template-parts/post/title', 'page_template' ); ?>
					            <?php
					            if ( $post->post_content && ! $is_plugin_shortcode ) {
						            $html_content = '<div>' . apply_filters( 'the_content', $post->post_content ) . '</div>';
						            ?>
                                    <div class="seo__body">
							            <?php echo str_replace( '<div class="', '<div class="seo__text ', $html_content ); ?>
                                    </div>
						            <?php
					            }
					            ?>
                            </div>
                        </section>

						<?php if ( ! $is_plugin_shortcode && ! $is_plugin_ti_wishlist ) { ?>
                            <div class="goods">
								<?php echo WsclWoocommerce::wishlist_products_display(); ?>
                            </div>
						<?php } else { ?>
							<?php if ( $is_plugin_ti_wishlist && ! $is_plugin_shortcode ) { ?>
								<?php echo do_shortcode( '[ti_wishlistsview]' ); ?>
							<?php } else { ?>
								<?php the_content(); ?>
							<?php } ?>
						<?php } ?>

                    </div><!-- .content__body -->
                </div>

				<?php get_sidebar(); ?>
            </div>
        </div>
    </div>

<?php get_footer(); ?>