<?php
/**
 * Template Name: Compare
 * Template Post Type: page
 *
 */

get_header();

global $product;

$cat_id       = 0;
$compare_data = Helper::get_compare_data();
if ( count( $compare_data ) == 1 ) {
	$wescle_compare_ids = current( $compare_data );
	foreach ( $compare_data as $cat_id => $ids ) {
		break;
	}
}
else {
	$cat_id             = $_GET['list'] ?? 0;
	$wescle_compare_ids = isset( $compare_data[ $cat_id ] ) ? $compare_data[ $cat_id ] : [];
}

$fields                = [];
$column_fields         = get_theme_mod( 'compare_columns', Helper::get_default_theme_data( 'compare_columns' ) );
$compare_column_fields = Helper::get_compare_column_fields();
$fields['image']       = $compare_column_fields['image'] ?? '';
foreach ( $column_fields as $item ) {
	$key            = $item['column_field'];
	$fields[ $key ] = $compare_column_fields[ $key ] ?? '';
}

$fields = apply_filters( 'wescle_compare_fields', $fields, $cat_id );

$products = [];
foreach ( $wescle_compare_ids as $product_id ) {
	$current_language = apply_filters( 'wpml_current_language', null );
	$product          = apply_filters( 'wpml_object_id', $product_id, 'product', true, $current_language );
	$product          = wc_get_product( $product_id );
	if ( ! $product ) {
		continue;
	}

	$product->fields = array();

	foreach ( $fields as $field => $name ) {

		switch ( $field ) {
			case 'title':
				$product->fields[ $field ] = '<div class="_title"><a href="' . $product->get_permalink() . '">' . $product->get_title() . '</a></div>';
				break;
			case 'price':
				$product->fields[ $field ] = '<div class="_price price">' . $product->get_price_html() . '</div>';
				break;
			case 'image':
				$product->fields[ $field ] = '<div class="_image"><a href="' . $product->get_permalink() . '">' . woocommerce_get_product_thumbnail() . '</a></div>';
				break;
			case 'description':
				$product->fields[ $field ] = '<div class="_description">' . apply_filters( 'woocommerce_short_description', $product->get_short_description() ) . '</div>';
				break;
			case 'stock':
				$availability = $product->get_availability();
				if ( empty( $availability['availability'] ) ) {
					$stock_html = '<p class="stock in-stock">' . wc_get_product_stock_status_options()['instock'] . '</p>';
				}
				else {
					$stock_html = wc_get_stock_html( $product );
				}
				$product->fields[ $field ] = $stock_html;
				break;
			case 'sku':
				$sku = $product->get_sku();
				if ( ! $sku ) {
					$sku = '-';
				}
				$product->fields[ $field ] = '<div class="_sku">' . $sku . '</div>';;
				break;
			case 'weight':
				$weight = $product->get_weight();
				$weight = $weight ? ( wc_format_localized_decimal( $weight ) . ' ' . esc_attr( get_option( 'woocommerce_weight_unit' ) ) ) : '-';

				$product->fields[ $field ] = sprintf( '<div class="_weight">%s</div>', esc_html( $weight ) );
				break;
			case 'dimensions':
				$dimensions = function_exists( 'wc_format_dimensions' ) ? wc_format_dimensions( $product->get_dimensions( false ) ) : $product->get_dimensions();
				if ( ! $dimensions ) {
					$dimensions = '-';
				}

				$product->fields[ $field ] = sprintf( '<div class="_dimensions">%s</div>', esc_html( $dimensions ) );
				break;
			default:
				if ( taxonomy_exists( $field ) ) {
					$product->fields[ $field ] = array();
					$terms                     = get_the_terms( $product_id, $field );
					if ( ! empty( $terms ) ) {
						foreach ( $terms as $term ) {
							$term                        = sanitize_term( $term, $field );
							$product->fields[ $field ][] = $term->name;
						}
					}
					$product->fields[ $field ] = '<div class="_attrs"><span>' . implode( ',</span> <span>', $product->fields[ $field ] ) . '</span></div>';
				}
				else {
					$product->fields[ $field ] = '';
				}
				break;
		}
	}

	$products[ $product_id ] = $product;
}
?>
    <div class="content _compare">
        <div class="container">
			<?php get_template_part( 'template-parts/breadcrumbs' ); ?>
			<?php if ( ! get_post_meta( $post->ID, 'hide_page_title', 1 ) ) { ?>
                <h1 class="title title_divider"><?php echo get_the_title(); ?></h1>
			<?php } ?>

			<?php
			if ( ! $products ) {

			}
			else {
				?>
                <div class="_table-section" id="table-section-<?php echo $cat_id; ?>">
                    <div class="_table-scroll">
                        <div class="_table">
                            <table>
                                <thead>
                                <tr>
                                    <th class="_cell-fixed"><?php _e( 'Изображение', 'wescle' ); ?></th>
									<?php
									foreach ( $fields as $field => $name ) {
										if ( $field === 'image' ) {
											continue;
										}
										?>
                                        <th><?php echo $name; ?></th>
									<?php } ?>
                                </tr>

                                </thead>
                                <tbody>
								<?php foreach ( $products as $product_id => $product ) { ?>
                                    <tr>
                                        <td class="_cell-fixed">
											<?php echo $product->fields['image']; ?>
                                        </td>
										<?php
										foreach ( $product->fields as $field => $field_html ) {
											if ( $field === 'image' ) {
												continue;
											}

											if ( $field === 'actions' ) {
												?>
                                                <td>
                                                    <div class="_actions">
														<?php woocommerce_template_loop_add_to_cart(); ?>
                                                        <a class="btn btn-main btn-delete link_compare-delete" href="#" data-product_id="<?php echo $product_id; ?>">
                                                            <svg xmlns="http://www.w3.org/2000/svg" aria-hidden="true" role="img" width="1em" height="1em" preserveaspectratio="xMidYMid meet" viewbox="0 0 24 24">
                                                                <path fill="currentColor" d="m13.41 12l4.3-4.29a1 1 0 1 0-1.42-1.42L12 10.59l-4.29-4.3a1 1 0 0 0-1.42 1.42l4.3 4.29l-4.3 4.29a1 1 0 0 0 0 1.42a1 1 0 0 0 1.42 0l4.29-4.3l4.29 4.3a1 1 0 0 0 1.42 0a1 1 0 0 0 0-1.42Z"></path>
                                                            </svg>
                                                        </a>
                                                    </div>
                                                </td>
												<?php
												continue;
											}

											?>
                                            <td><?php echo $field_html; ?></td>
											<?php
										}
										?>
                                    </tr>
								<?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
				<?php
			}
			?>
        </div>
    </div>

<?php get_footer(); ?>