<?php
/**
 * Template Name: Video Reviews
 * Template Post Type: page
 *
 */

get_header();
?>
    <div class="content">
        <div class="container">
            <div class="row content__row">
                <div class="col content__col content__col_big">
                    <div class="content__body">
						<?php get_template_part( 'template-parts/breadcrumbs' ); ?>

						<?php
						$paged        = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
						$review_query = new WP_Query( [
							'post_type'   => 'videoreview',
							'post_status' => 'publish',
							'paged'       => $paged,
						] );
						?>
                        <div class="block-authors-info">
							<?php while ( have_posts() ) : the_post(); ?>
								<?php get_template_part( 'template-parts/post/title', 'page_template' ); ?>
								<?php
								if ( $post->post_content && ! is_paged() ) {
									?>
                                    <div class="section-post__editor entry-content">
	                                    <?php the_content(); ?>
                                    </div>
									<?php
								}
								?>
							<?php endwhile; ?>

	                        <?php
	                        $posts = $review_query->get_posts();
	                        ?>
                            <div class="reviews-2__grid">
		                        <?php
		                        foreach ( $posts as $post ) {
			                        setup_postdata( $post );

			                        get_template_part( 'template-parts/content/videoreview', 'item', [] );
		                        }
		                        ?>
                            </div>
                        </div><!-- .block-authors-info -->

	                    <?php wescle_paginate_links( $review_query ); ?>
                    </div><!-- .content__body -->

					<?php wp_reset_query(); ?>
                </div>

				<?php get_sidebar(); ?>
            </div>
        </div>
    </div>

<?php get_footer(); ?>