<?php
/**
 * Template Name: Products Wescle
 * Template Post Type: page
 *
 */

get_header();
?>
    <div class="content">
        <div class="container">
            <div class="row content__row">
                <div class="col content__col content__col_big">
                    <div class="content__body">
						<?php get_template_part( 'template-parts/breadcrumbs' ); ?>

						<?php
						$paged            = get_query_var( 'paged' ) ? get_query_var( 'paged' ) : 1;
						$query_prodwescle = new WP_Query( [
							'post_type'   => 'product_wescle',
							'post_status' => 'publish',
							'paged'       => $paged,
							'orderby'     => [ 'menu_order' => 'ASC', 'date' => 'DESC' ],
						] );
						?>
                        <div class="block-authors-info">
							<?php while ( have_posts() ) : the_post(); ?>
								<?php get_template_part( 'template-parts/post/title', 'page_template' ); ?>
								<?php
								if ( $post->post_content && ! is_paged() ) {
									?>
                                    <div class="section-post__editor entry-content">
										<?php the_content(); ?>
                                    </div>
									<?php
								}
								?>
							<?php endwhile; ?>

                            <div class="products-section__grid">
								<?php
								foreach ( $query_prodwescle->get_posts() as $post ) {
									setup_postdata( $post );

									get_template_part( 'template-parts/content/product', 'item' );
								}
								wp_reset_postdata();
								?>
                            </div>
                        </div><!-- .block-authors-info -->

	                    <?php wescle_paginate_links( $query_prodwescle ); ?>
                    </div><!-- .content__body -->

	                <?php wp_reset_query(); ?>

	                <?php wescle_form_after_content(); ?>
                </div>

	            <?php get_sidebar(); ?>
            </div>
        </div>
    </div>

<?php get_footer(); ?>