<?php
/**
 * Template Name: Portfolios
 * Template Post Type: page
 *
 */

get_header();

$home_portfolio_posts = get_theme_mod( 'home_portfolio_posts', [] );

$home_portfolio_data = [];
foreach ( $home_portfolio_posts as $item ) {
	if ( $item['post_id'] ) {
		$home_portfolio_data[ $item['post_id'] ]['size'] = 'big';
	}
}
?>
    <div class="content">
        <div class="container">
            <div class="row content__row">
                <div class="col content__col content__col_big">
                    <div class="content__body">
						<?php get_template_part( 'template-parts/breadcrumbs' ); ?>

						<?php
						$paged            = get_query_var( 'paged' ) ? get_query_var( 'paged' ) : 1;
						$portfolios_query = new WP_Query( [
							'post_type'   => 'portfolio_wescle',
							'post_status' => 'publish',
							'paged'       => $paged,
						] );
						?>
                        <div class="block-authors-info">
							<?php while ( have_posts() ) : the_post(); ?>
								<?php get_template_part( 'template-parts/post/title', 'page_template' ); ?>
								<?php
								if ( $post->post_content && ! is_paged() ) {
									?>
                                    <div class="section-post__editor entry-content">
										<?php the_content(); ?>
                                    </div>
									<?php
								}
								?>
							<?php endwhile; ?>

							<?php
							$posts = $portfolios_query->get_posts();
							foreach ( $posts as $item ) {
								$home_portfolio_data[ $item->ID ]['size'] = 'big';
							}

							set_query_var( 'template_args', [ 'portfolio_data' => $home_portfolio_data ] );
							?>
                            <div class="row work-performed-items">
								<?php
								set_query_var( 'template_args', [ 'portfolio_data' => $home_portfolio_data ] );

								foreach ( $posts as $post ) {
									setup_postdata( $post );

									get_template_part( 'template-parts/content/portfolio', 'item' );
								}
								wp_reset_postdata();
								?>
                            </div>
                        </div><!-- .block-authors-info -->

						<?php wescle_paginate_links( $portfolios_query ); ?>
                    </div><!-- .content__body -->

					<?php wp_reset_query(); ?>

					<?php wescle_form_after_content(); ?>
                </div>

				<?php get_sidebar(); ?>
            </div>
        </div>
    </div>

<?php get_footer(); ?>