<?php
/**
 * Template Name: Partners
 * Template Post Type: page
 *
 */

get_header();
?>
    <div class="content">
        <div class="container">
            <div class="row content__row">
                <div class="col content__col content__col_big">
                    <div class="content__body">
						<?php get_template_part( 'template-parts/breadcrumbs' ); ?>

                        <div class="block-authors-info">
							<?php while ( have_posts() ) : the_post(); ?>
								<?php get_template_part( 'template-parts/post/title', 'page_template' ); ?>
								<?php
								if ( $post->post_content && ! is_paged() ) {
									?>
                                    <div class="section-post__editor entry-content">
										<?php the_content(); ?>
                                    </div>
									<?php
								}
								?>
							<?php endwhile; ?>
                        </div><!-- .block-authors-info -->

                        <div class="partners__body">
							<?php
							$partner_posts = get_posts( [
								'post_type'      => 'partner_wescle',
								'posts_per_page' => - 1,
								'orderby'        => [ 'menu_order' => 'ASC', 'date' => 'DESC' ],
								'meta_query'     => [
									[
										'key'   => 'featured',
										'value' => 1,
									]
								],
							] );
							if ( $partner_posts ) {
								?>
                                <div class="partners-list">
									<?php
									foreach ( $partner_posts as $post ) {
										setup_postdata( $post );

										get_template_part( 'template-parts/content/partner', 'item' );
									}
									wp_reset_postdata();
									?>
                                </div>
								<?php
							}

							$terms = get_terms( [
								'taxonomy' => 'partnercat_wescle',
							] );
							foreach ( $terms as $term ) {
								$partner_posts = get_posts( [
									'post_type'      => 'partner_wescle',
									'posts_per_page' => - 1,
									'orderby'        => [ 'menu_order' => 'ASC', 'date' => 'DESC' ],
									'meta_query'     => [
										[
											'key'     => 'featured',
											'value'   => 1,
											'compare' => '!=',
										]
									],
									'tax_query'      => [
										[
											'taxonomy' => $term->taxonomy,
											'terms'    => [ $term->term_id ],
										]
									],
								] );
								if ( $partner_posts ) {
									?>
                                    <div class="partners__title"><?php echo $term->name; ?></div>
									<?php if ( $term->description ) { ?>
                                        <div class="partners__text"><?php echo $term->description; ?></div>
									<?php } ?>
                                    <div class="partners-list">
										<?php
										foreach ( $partner_posts as $post ) {
											setup_postdata( $post );

											get_template_part( 'template-parts/content/partner', 'item' );
										}
										wp_reset_postdata();
										?>
                                    </div>
									<?php
								}
							}
							?>
                        </div>

                    </div><!-- .content__body -->
                </div>
            </div>
        </div>
    </div>

<?php get_footer(); ?>