<?php
/**
 * Template Name: Courses
 * Template Post Type: page
 *
 */

get_header();
?>
    <div class="content-title">
        <div class="container">
			<?php get_template_part( 'template-parts/post/title', 'page_template' ); ?>
			<?php if ( $post->post_content ) { ?>
                <div class="subtitle"><?php echo $post->post_content; ?></div>
			<?php } ?>
        </div>
    </div>

<?php
$args  = [
	'taxonomy' => 'coursecat_wescle',
	'parent'   => 0
];
$terms = get_terms( $args );
if ( count( $terms ) > 0 ) {
	?>
    <div class="category-categories">
        <div class="container">
            <div class="category-categories__grid">
				<?php
				foreach ( $terms as $term ) {
					if ( get_queried_object_id() == $term->term_id ) {
						$tag_open  = '<span class="category-categories-item btn btn-main">';
						$tag_close = '</span>';
					}
					else {
						$tag_open  = '<a class="category-categories-item btn btn-main" href="' . get_term_link( $term ) . '">';
						$tag_close = '</a>';
					}

					$thumbnail_id = get_term_meta( $term->term_id, '_thumbnail_id', 1 );

					echo $tag_open;
					if ( $thumbnail_id ) {
						echo wp_get_attachment_image( $thumbnail_id );
					}
					echo '<span>' . $term->name . '</span>';
					echo $tag_close;
				}
				?>
            </div>
        </div>
    </div>
<?php } ?>

<?php
$args = [
	'taxonomy' => 'coursetag_wescle',
	'parent'   => 0
];
$tags = get_terms( $args );
if ( count( $tags ) > 0 ) {
	$title_block = get_theme_mod( 'course_all_tags_title', Helper::get_default_theme_data( 'course_all_tags_title' ) );
	?>
    <div class="course-advantages-wrap">
        <div class="container">
            <div class="course-advantages">
                <div class="course-advantages__block">
					<?php if ( $title_block ) { ?>
                        <div class="course-advantages__title"><?php echo $title_block; ?></div>
					<?php } ?>
                    <div class="course-advantages__line">
						<?php foreach ( $tags as $tag ) { ?>
                            <a href="<?php echo get_term_link( $tag ); ?>" class="course-advantages-item"><span><?php echo $tag->name; ?></span></a>
						<?php } ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
	<?php
}
?>
    <div class="content">
        <div class="container">
            <div class="row content__row">
                <div class="col content__col content__col_big">
                    <div class="content__body">
						<?php
						$paged = get_query_var( 'paged' ) ? get_query_var( 'paged' ) : 1;
						query_posts( [
							'post_type'   => 'course_wescle',
							'post_status' => 'publish',
							'paged'       => $paged,
						] );
						if ( have_posts() ) { ?>
                            <section class="post-course" id="post-course">
                                <div class="post-course__row">
									<?php while ( have_posts() ) : the_post(); ?>
										<?php get_template_part( 'template-parts/content/course-item' ); ?>
									<?php endwhile; ?>
                                </div>
                            </section>
							<?php wescle_paginate_links(); ?>
							<?php
						}
						else {
							get_template_part( 'template-parts/content/content', 'none' );
						}
						wp_reset_query();
						?>
                    </div>
                </div>
            </div>
        </div>
    </div>

<?php get_footer(); ?>