<?php
/**
 * Template Name: Brands
 * Template Post Type: page
 *
 */

get_header();
?>
    <div class="content">
        <div class="container">
            <div class="row content__row">
                <div class="col content__col content__col_big">
                    <div class="content__body">
						<?php get_template_part( 'template-parts/breadcrumbs' ); ?>

						<?php
						$args       = array(
							'public'      => true,
							'object_type' => [ 'product' ]
						);
						$taxonomies = get_taxonomies( $args );

						$taxonomy = get_post_meta( $post->ID, 'taxonomy_brand', 1 );
						if ( ! $taxonomy ) {
							$taxonomy = 'product_cat';
						}

						$terms_brand = get_terms( [
							'taxonomy' => $taxonomy,
							'orderby'  => 'count',
							'order'    => 'DESC',
						] );

						$popular_length = get_post_meta( $post->ID, 'count_popular', 1 );
						if ( $popular_length === '' ) {
							$popular_length = count( $terms_brand ) > 10 ? 10 : 5;
						}
						$terms_brand_popular = array_slice( $terms_brand, 0, $popular_length );

						$first_letters       = array();
						$first_letters_terms = array();
						foreach ( $terms_brand as $term ) {
							$starting_letter = Helper::get_first_char( $term->name );
							$first_letters[] = $starting_letter;
						}
						$first_letters = array_unique( $first_letters );
						sort( $first_letters );
						?>
                        <section class="brands" id="brands">
							<?php if ( ! get_post_meta( $post->ID, 'hide_page_title', 1 ) ) { ?>
                                <h1 class="brands__title title title_divider"><?php echo get_the_title(); ?></h1>
							<?php } ?>
                            <nav class="brands-nav">
								<?php foreach ( $first_letters as $letter ) { ?>
                                    <a href="#char-<?php echo $letter; ?>"><?php echo $letter; ?></a>
								<?php } ?>
                            </nav>
                            <div class="brands-block">
								<?php if ( $terms_brand_popular ) { ?>
									<?php if ( $title = get_post_meta( $post->ID, 'title_popular', 1 ) ) { ?>
                                        <div class="brands__title title"><?php echo $title; ?></div>
									<?php } ?>
                                    <div class="brands-images">
										<?php
										foreach ( $terms_brand_popular as $term ) {
											$image_html = get_brand_image_html( $term );
											if ( ! $image_html ) {
												continue;
											}
											$term_link = get_term_link( $term );
											?>
                                            <a class="brands-images-item" href="<?php echo $term_link; ?>">
												<?php echo $image_html; ?>
                                            </a>
											<?php
										}
										?>
                                    </div>
								<?php } ?>
	                            <?php
	                            $width_column = get_post_meta( $post->ID, 'column_width', 1 );
	                            $style        = $width_column != 150 ? 'style="grid-template-columns:repeat(auto-fill,minmax(' . $width_column . 'px,1fr))"' : '';
	                            ?>
                            </div>
                            <div class="brands-names" <?php echo $style; ?>>
		                        <?php foreach ( $first_letters as $letter ) { ?>
                                    <div class="brands-names-item" id="char-<?php echo $letter; ?>">
                                        <div class="brands-names-item__title"><?php echo $letter; ?></div>
                                        <div class="brands-names-item__list">
					                        <?php
					                        foreach ( $terms_brand as $term ) {
						                        $starting_letter = Helper::get_first_char( $term->name );

						                        if ( $starting_letter === $letter ) {
							                        echo '<a href="' . get_term_link( $term ) . '">' . $term->name . '</a>';
						                        }
					                        }
					                        ?>
                                        </div>
                                    </div>
		                        <?php } ?>
                            </div>
                        </section>

                    </div><!-- .content__body -->
                </div>
	            <?php get_sidebar(); ?>
            </div>
        </div>
    </div>

<?php get_footer(); ?>