<?php
/**
 * Template Name: Authors
 * Template Post Type: page
 *
 */

get_header();
?>
    <div class="content">
        <div class="container">
            <div class="row content__row">
                <div class="col content__col content__col_big">
                    <div class="content__body">
						<?php get_template_part( 'template-parts/breadcrumbs' ); ?>

						<?php
						$paged  = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
						$number = 10;
						$offset = ( $paged - 1 ) * $number;

						$author_users_args = [
							'has_published_posts' => 'post',
						];
						$all_users         = get_users( $author_users_args );

						$author_users_args = [
							'has_published_posts' => 'post',
							'fields'              => 'all_with_meta',
							'number'              => $number,
							'offset'              => $offset
						];
						$author_users_args = apply_filters( 'author_users_args', $author_users_args );
						$query_users       = get_users( $author_users_args );

						$total_users = count( $all_users );
						$total_query = count( $query_users );
						$total_pages = ceil( $total_users / $number );
						?>
                        <div class="block-authors-info">
		                    <?php while ( have_posts() ) : the_post(); ?>
			                    <?php get_template_part( 'template-parts/post/title', 'page_template' ); ?>
			                    <?php
			                    if ( $post->post_content && ! is_paged() ) {
				                    ?>
                                    <div class="section-post__editor entry-content">
					                    <?php the_content(); ?>
                                    </div>
				                    <?php
			                    }
			                    ?>
		                    <?php endwhile; ?>

                            <div class="row block-authors-info__row">
			                    <?php
			                    foreach ( $query_users as $user_author ) {
				                    $user_author_link = get_author_posts_url( $user_author->ID );
				                    $header_image_id  = get_user_meta( $user_author->ID, 'header_image', 1 );
				                    ?>
                                    <div class="col block-authors-info__col">
                                        <div class="author-info">
                                            <div class="author-info__image">
							                    <?php
							                    if ( $header_image_id ) {
								                    echo wp_get_attachment_image( $header_image_id, 'medium_large' );
							                    }
							                    ?>
                                            </div>
                                            <div class="author-info__body">
                                                <a class="author-info__photo" href="<?php echo $user_author_link; ?>">
								                    <?php echo get_avatar( $user_author->ID, 120 ); ?>
                                                </a>

                                                <a class="author-info__name" href="<?php echo $user_author_link; ?>"><?php echo Helper::get_author_name( $user_author ); ?></a>

							                    <?php if ( $user_author->description ) { ?>
                                                    <div class="author-info__text">
									                    <?php echo Helper::short_string( wp_strip_all_tags( $user_author->description ), 150 ); ?>
                                                    </div>
							                    <?php } ?>

							                    <?php
							                    set_query_var( 'template_args', [ 'user_id' => $user_author->ID ] );
							                    get_template_part( 'template-parts/archive/author', 'social' );
							                    ?>
                                            </div>
                                        </div>
                                    </div>
			                    <?php } ?>
                            </div>
                        </div>

	                    <?php if ( $total_users > $total_query ) { ?>
		                    <?php wescle_paginate_links( false, true, [ 'total' => $total_pages ] ); ?>
	                    <?php } ?>
                    </div>
                </div>
	            <?php get_sidebar(); ?>
            </div>
        </div>
    </div>

<?php get_footer(); ?>