<?php
$title = $args['title'] ?? '';
$items = $args['data_features'];
if ( ! $items ) {
	return;
}

$title = apply_filters( 'wescle_product_features_title', $title );
?>
<div class="product-advantages">
	<?php if ( $title ) { ?>
        <div class="product-advantages__title"><?php echo $title; ?></div>
	<?php } ?>
    <div class="product-advantages__grid">
		<?php foreach ( $items as $item ) { ?>
            <div class="product-advantages-item">
				<?php if ( $item['img_id'] ) { ?>
                    <div class="product-advantages-item__img">
						<?php echo wp_get_attachment_image( $item['img_id'], 'medium' ); ?>
                    </div>
				<?php } ?>
                <div class="product-advantages-item__body">
					<?php if ( $item['title'] ) { ?>
                        <div class="product-advantages-item__name"><?php echo $item['title']; ?></div>
					<?php } ?>
					<?php if ( $item['text'] ) { ?>
                        <div class="product-advantages-item__title"><?php echo $item['text']; ?></div>
					<?php } ?>
                </div>
            </div>
		<?php } ?>
    </div>
</div>