<?php
$categories_data = $args['terms_data'];
$show_image      = $args['show_image'];
$show_count      = $args['show_count'];
$show_children   = $args['show_children'];

if ( $categories_data ) {
	?>
    <div class="aside-store-categories__body">
        <ul class="aside-store-categories__list" aria-expanded="false">
			<?php
			foreach ( $categories_data as $categories_data_item ) {
				$li_class = '';
				if ( $categories_data_item['children'] ) {
					$li_class = 'class="with-arrow"';
				}

				if ( $categories_data_item['term_link'] ) {
					$tag_open  = '<a href="' . $categories_data_item['term_link'] . '">';
					$tag_close = '</a>';
				}
				else {
					$tag_open  = '<span>';
					$tag_close = '</span>';
				}
				?>
                <li <?php echo $li_class; ?>>
					<?php echo $tag_open; ?>
					<?php
					if ( $show_image && $categories_data_item['term_img'] ) {
						echo '<div class="aside-store-categories__image">';
						echo $categories_data_item['term_img'];
						echo '</div>';
					}
					?>
                    <span>
                        <?php echo $categories_data_item['term_name']; ?>
                        <?php if ( $show_count ) {
	                        echo '<span>(' . $categories_data_item['term_count'] . ')</span>';
                        } ?>
                    </span>
					<?php echo $tag_close; ?>
					<?php if ( $show_children && $categories_data_item['children'] ) { ?>
                        <button class="arrow">
                            <svg class="icon-arrow-bottom" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 32 32">
                                <g fill="none" stroke="#626262" stroke-linecap="round" stroke-linejoin="round" stroke-width="4">
                                    <path d="M30 12L16 24L2 12"></path>
                                </g>
                            </svg>
                        </button>
                        <div class="aside-store-categories__sublist">
                            <div class="aside-store-categories__sublist-wrap">
                                <button class="btn-close" type="button">
                                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 24 24">
                                        <path fill="#626262" d="M13.41 12l4.3-4.29a1 1 0 1 0-1.42-1.42L12 10.59l-4.29-4.3a1 1 0 0 0-1.42 1.42l4.3 4.29l-4.3 4.29a1 1 0 0 0 0 1.42a1 1 0 0 0 1.42 0l4.29-4.3l4.29 4.3a1 1 0 0 0 1.42 0a1 1 0 0 0 0-1.42z"></path>
                                    </svg>
                                </button>
								<?php foreach ( $categories_data_item['children'] as $child_item ) {
									if ( $child_item['term_link'] ) {
										$tag_open  = '<a href="' . $child_item['term_link'] . '">';
										$tag_close = '</a>';
									}
									else {
										$tag_open  = '<span>';
										$tag_close = '</span>';
									}
									?>
                                    <div>
                                        <p><?php echo $tag_open; ?><?php echo $child_item['term_name']; ?><?php echo $tag_close; ?></p>
										<?php
										if ( isset( $child_item['children'] ) && $child_item['children'] ) {
											echo '<ul>';
											foreach ( $child_item['children'] as $item ) {
												if ( $item['term_link'] ) {
													$tag_open  = '<a href="' . $item['term_link'] . '">';
													$tag_close = '</a>';
												}
												else {
													$tag_open  = '<span>';
													$tag_close = '</span>';
												}

												echo '<li>' . $tag_open . $item['term_name'] . $tag_close . '</li>';
											}
											echo '</ul>';
										}
										?>
                                    </div>
								<?php } ?>
                            </div>
                        </div>
					<?php } ?>
                </li>
			<?php } ?>
        </ul>
		<?php if ( count( $categories_data ) > 6 ) { ?>
            <a class="view-more" href="#" aria-expanded="false" data-open-name="<?php echo Helper::get_text_label( 'show_more' ); ?>" data-close-name="<?php echo Helper::get_text_label( 'close' ); ?>"><?php echo Helper::get_text_label( 'show_more' ); ?></a>
		<?php } ?>
    </div>
	<?php
}


