<?php
$args         = get_query_var( 'template_args' );
$posts_custom = $args['posts'];
$options      = $args['instance'];
if ( $posts_custom ) {
	$current_post_id = 0;
	if ( is_single() ) {
		$current_post_id = get_queried_object_id();
	}

	echo '<div class="row popular__row">';
	foreach ( $posts_custom as $post ) {
		setup_postdata( $post );

		$post_card_meta = [];
		foreach ( choices_visibility_meta() as $key => $val ) {
			$post_card_meta[ $key ] = $key;
		}

		if ( ! empty( $options ) ) {
			if ( ! $options['show_author'] ) {
				unset( $post_card_meta['author'] );
			}
			if ( ! $options['show_date'] ) {
				unset( $post_card_meta['date'] );
			}
			if ( ! $options['show_comments'] ) {
				unset( $post_card_meta['comments'] );
			}
			if ( ! $options['show_views'] ) {
				unset( $post_card_meta['views'] );
			}
		}
		?>
        <div class="col popular__col">
            <div class="popular__post popular-post post">
                <a href="<?php the_permalink(); ?>" class="post__image">
					<?php
					if ( $img_id = get_post_meta( $post->ID, 'thumbnail_archive', 1 ) ) {
						echo wp_get_attachment_image( $img_id, 'medium' );
					}
					else {
						the_post_thumbnail( 'medium' );
					}
					?>
                </a>
                <div class="post__body">
		            <?php
		            if ( $options['show_category'] ) {
			            post_card_category( '', 1 );
		            }
		            ?>

		            <?php post_card_title( true, false ); ?>

		            <?php post_card_meta( $post_card_meta, true, false, false ); ?>
                </div>
            </div>
        </div>
		<?php
	}
	wp_reset_postdata();

	echo '</div>';
}