<?php
$args         = get_query_var( 'template_args' );
$posts_custom = $args['posts'];
$options      = $args['instance'];
if ( $posts_custom ) {
	$current_post_id = 0;
	if ( is_single() ) {
		$current_post_id = get_queried_object_id();
	}

	echo '<div class="row popular__row">';
	foreach ( $posts_custom as $post ) {
		setup_postdata( $post );
		?>
        <div class="col popular__col">
            <div class="popular__post popular-post post">
                <a href="<?php the_permalink(); ?>" class="post__image">
					<?php
					if ( $img_id = get_post_meta( $post->ID, 'thumbnail_archive', 1 ) ) {
						echo wp_get_attachment_image( $img_id, 'medium' );
					}
					else {
						the_post_thumbnail( 'medium' );
					}
					?>
                </a>
                <div class="post__body">
					<?php post_card_title( true, false ); ?>
					<?php
					if ( $options['show_excerpt'] && $post->post_excerpt ) {
						echo '<div class="post__excerpt">' . $post->post_excerpt . '</div>';
					}
					?>
                </div>
            </div>
        </div>
		<?php
	}
	wp_reset_postdata();

	echo '</div>';
}