<?php
$args         = get_query_var( 'template_args' );
$posts_custom = $args['posts'];
$options      = $args['instance'];
if ( $posts_custom ) {
	?>
    <div class="news-widget__row">
		<?php
		foreach ( $posts_custom as $key => $post ) {
			setup_postdata( $post );

			$custom_class = 'news-widget-item';
			$img          = '';
			if ( get_post_meta( $post->ID, 'show_image_news_widget', 1 ) ) {
				$custom_class = 'news-widget-item news-widget-item_with-img';
				$img          = wp_get_attachment_image( get_post_thumbnail_id(), 'medium' );
			}
			?>
            <div class="news-widget__col">
                <a class="<?php echo $custom_class; ?>" href="<?php the_permalink(); ?>">
					<?php if ( $img ) { ?>
                        <div class="news-widget-item__img">
							<?php echo $img; ?>
                        </div>
					<?php } else { ?>
                        <time class="news-widget-item__time" datetime="<?php echo get_the_date( 'Y-m-d H:i:s' ); ?>"><?php echo get_the_time(); ?></time>
					<?php } ?>
                    <div class="news-widget-item__title"><?php the_title(); ?></div>
                </a>
            </div>
			<?php
		}
		wp_reset_postdata();
		?>
    </div>
	<?php
}