<?php
$items = get_post_meta( get_the_ID(), 'wescle_course_info', 1 );
if ( ! $items ) {
	return;
}
?>
<section class="aside-advantages widget" id="aside-advantages">
    <div class="aside-advantages__content">
		<?php foreach ( $items as $item ) { ?>
            <div class="aside-advantages-item">
				<?php if ( $item['img_id'] ) { ?>
                    <div class="aside-advantages-item__img">
						<?php echo wp_get_attachment_image( $item['img_id'], 'medium' ); ?>
                    </div>
				<?php } ?>
                <div class="aside-advantages-item__body">
					<?php if ( $item['title'] ) { ?>
                        <div class="aside-advantages-item__title"><?php echo $item['title']; ?></div>
					<?php } ?>
					<?php if ( $item['text'] ) { ?>
                        <div class="aside-advantages-item__text"><?php echo nl2br( $item['text'] ); ?></div>
					<?php } ?>
                </div>
            </div>
		<?php } ?>
    </div>
</section>