<?php
$instance = $args['instance'];

$phones_html = '';
if ( $instance['phones'] ) {
	foreach ( $instance['phones'] as $phone ) {
		if ( $instance['phone_as_link'] ) {
			$phones_html .= '<a class="aside-order__tel" href="tel:' . Helper::phone_number_format( $phone ) . '">' . Helper::phone_number_mask( $phone ) . '</a>';
		}
		else {
			$phones_html .= '<span class="aside-order__tel">' . $phone . '</span>';
		}
	}
}

$socials_html = '';
if ( $instance['socials'] ) {
	foreach ( $instance['socials'] as $item ) {
		$link = '#';
		if ( $item['url'] ) {
			$link = $item['url'];
		}

		$svg = '';
		if ( $item['type'] ) {
			$svg = Helper::html_svg_icon( $item['type'] );
		}
		$socials_html .= '<span class="aside-order-socials__item socials__item-' . $item['type'] . ' js-link" data-link="' . $link . '">' . $svg . '<span>' . $item['label'] . '</span></span>';
	}
}
?>
<div class="aside-order__content">
	<?php if ( $instance['title_1'] || $instance['text_1'] ) { ?>
        <div class="aside-order__top">
			<?php if ( $instance['title_1'] ) { ?>
                <div class="aside-order__title"><span><?php echo $instance['title_1']; ?></span>
					<?php if ( $instance['image_1'] ) { ?>
                        <img src="<?php echo $instance['image_1']; ?>" loading="lazy" alt="" width="24" height="24">
					<?php } ?>
                </div>
			<?php } ?>
			<?php if ( $instance['text_1'] ) { ?>
                <div class="aside-order__text"><?php echo $instance['text_1']; ?></div>
			<?php } ?>
        </div>
	<?php } ?>
    <div class="aside-order__body">
		<?php if ( $instance['title_2'] ) { ?>
            <div class="aside-order__title"><span><?php echo $instance['title_2']; ?></span>
				<?php if ( $instance['image_2'] ) { ?>
                    <img src="<?php echo $instance['image_2']; ?>" loading="lazy" alt="" width="24" height="24">
				<?php } ?>
            </div>
		<?php } ?>
		<?php echo $phones_html; ?>
		<?php if ( $instance['text_2'] ) { ?>
            <div class="aside-order__text">
				<?php echo $instance['text_2']; ?>
            </div>
		<?php } ?>
		<?php if ( $instance['button_label'] ) { ?>
			<?php echo $args['style']; ?>
            <a class="btn btn-main btn-main_blue<?php echo $instance['button_custom_class']; ?>" href="<?php echo $instance['button_link']; ?>"><?php echo $instance['button_label']; ?></a>
		<?php } ?>
		<?php if ( $socials_html ) { ?>
            <div class="aside-order-socials">
				<?php echo $socials_html; ?>
            </div>
		<?php } ?>
    </div>
</div>