<div class="footer__contacts">
	<?php
	$text = isset( $args['widget_text'] ) ? $args['widget_text'] : '';
	if ( $text ) {
		echo '<div class="footer__contacts-text">' . nl2br( $text ) . '</div>';
	}
	?>

	<?php
	$phone        = get_theme_mod( 'phone_primary', Helper::get_default_theme_data( 'phone_primary' ) );
	$phone_type   = get_theme_mod( 'phone_type', Helper::get_default_theme_data( 'phone_type' ) );
	$phone_login  = get_theme_mod( 'phone_type', '' );
	$work_time    = get_theme_mod( 'work_time', Helper::get_default_theme_data( 'work_time' ) );
	$working_days = get_theme_mod( 'working_days_list', Helper::get_default_theme_data( 'working_days_list' ) );
	$phone_others = get_theme_mod( 'phone_others', Helper::get_default_theme_data( 'phones' ) );
	$phone_style  = get_theme_mod( 'color_footer_style_phones', 'black' );
	if ( $phone || $phone_others ) {
		$add_class = isset( $phone_others[0] ) && $phone_others[0]['phone'] ? '' : 'one-number';
		$div_class = 'footer__telephone telephone dropdown-toggle';
		if ( $phone_style == 'white' ) {
			$div_class .= ' telephone_dark';
		}
		$operator_icon_id = get_theme_mod( 'phone_icon' );
		if ( $operator_icon_id ) {
			$div_class .= ' _with-operator';
		}
        elseif ( isset( $phone_others[0] ) && $phone_others[0]['phone'] ) {
			foreach ( $phone_others as $tel_other ) {
				if ( ! $tel_other['phone'] ) {
					continue;
				}

				$phone_icon = isset( $tel_other['phone_icon'] ) ? $tel_other['phone_icon'] : '';
				if ( $phone_icon ) {
					$div_class .= ' _with-operator';
					break;
				}
			}
		}
		?>
        <div class="<?php echo $div_class; ?>">
            <div class="telephone__content">
                <div class="telephone__actions <?php echo $add_class; ?>">
					<?php if ( $phone ) { ?>
						<?php
						$phone_link = Helper::phone_number_format( $phone, $phone_type, $phone_login );

						if ( strpos( $phone_link, '://' ) === false ) {
							?>
                            <a rel="nofollow" class="social-telephone" href="<?php echo Helper::phone_number_format( $phone, $phone_type, $phone_login ); ?>">
								<?php echo Helper::html_svg_icon( $phone_type ); ?>
                            </a>
							<?php
						}
						else {
							?>
                            <span class="social-telephone js-link" data-link="<?php echo Helper::phone_number_format( $phone, $phone_type, $phone_login ); ?>">
								<?php echo Helper::html_svg_icon( $phone_type ); ?>
                            </span>
							<?php
						}
						?>

                        <a rel="nofollow" class="telephone__link" href="<?php echo Helper::phone_number_format( $phone, 'tel' ); ?>">
                            <span><?php echo Helper::phone_number_mask( strip_tags( $phone ) ); ?></span>
                        </a>
					<?php } ?>
	                <?php
	                if ( $operator_icon_id ) {
		                $operator_icon = wp_get_attachment_image_src( $operator_icon_id );
		                echo '<div class="telephone-operator"><img src="' . $operator_icon[0] . '" alt="" loading="lazy"></div>';
	                }
	                ?>
	                <?php if ( isset( $phone_others[0] ) && $phone_others[0]['phone'] ) { ?>
                        <button class="_arrowUpDown telephone__btn-arrow btn-arrow">
                            <svg class="_arrow-up" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" preserveaspectratio="xMidYMid meet" viewbox="0 0 32 32">
                                <g fill="none" stroke="#626262" stroke-linecap="round" stroke-linejoin="round" stroke-width="4">
                                    <path d="M30 12L16 24L2 12"></path>
                                </g>
                            </svg>
                            <svg class="_arrow-down" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" preserveaspectratio="xMidYMid meet" viewbox="0 0 32 32">
                                <g fill="none" stroke="#626262" stroke-linecap="round" stroke-linejoin="round" stroke-width="4">
                                    <path d="M30 12L16 24L2 12"></path>
                                </g>
                            </svg>
                        </button>
	                <?php } ?>
                </div>
	            <?php if ( $work_time ) { ?>
                    <div class="telephone__schedule schedule"><?php echo $work_time; ?></div>
	            <?php } ?>
	            <?php
	            if ( $working_days ) {
		            echo html_working_days( $working_days );
	            }
	            ?>
            </div>
	        <?php if ( isset( $phone_others[0] ) && $phone_others[0]['phone'] ) { ?>
                <div class="telephone__dropdown dropdown-content">
                    <div class="telephones">
				        <?php
				        foreach ( $phone_others as $tel_other ) {
					        if ( ! $tel_other['phone'] ) {
						        continue;
					        }

					        $phone            = $tel_other['phone'];
					        $phone_type       = $tel_other['phone_type'];
					        $username         = $tel_other['phone_username'];
					        $phone_label      = isset( $tel_other['phone_label'] ) ? $tel_other['phone_label'] : '';
					        $label_as_link    = isset( $tel_other['phone_label_is_link'] ) ? $tel_other['phone_label_is_link'] : '';
					        $operator_icon_id = isset( $tel_other['phone_icon'] ) ? $tel_other['phone_icon'] : '';

					        echo '<div class="telephones-wrapper">';

					        if ( $phone_type != 'tel' ) {
						        $phone_link = Helper::phone_number_format( $phone, $phone_type, $username );
						        if ( strpos( $phone_link, '://' ) === false ) {
							        echo '<a rel="nofollow" class="social-telephone" href="' . $phone_link . '">' . Helper::html_svg_icon( $phone_type ) . '</a>';
						        }
						        else {
							        echo '<span class="social-telephone js-link" data-link="' . $phone_link . '">' . Helper::html_svg_icon( $phone_type ) . '</span>';
						        }
					        }
					        else {
						        echo '<span class="social-telephone">' . Helper::html_svg_icon( $phone_type ) . '</span>';
					        }

					        if ( $phone_label ) {
						        $phone_link  = Helper::phone_number_format( $phone, $phone_type, $username );
						        $phone_label = Helper::phone_number_mask( strip_tags( $phone_label ) );
						        if ( $label_as_link || $phone_type == 'tel' ) {
							        if ( strpos( $phone_link, '://' ) === false ) {
								        echo '<a rel="nofollow" class="telephones__link telephones__link1" href="' . $phone_link . '">' . $phone_label . '</a>';
							        }
							        else {
								        echo '<span class="telephones__link telephones__link1 js-link" data-link="' . $phone_link . '">' . $phone_label . '</span>';
							        }
						        }
						        else {
							        echo '<span class="telephones__link telephones__link2">' . $phone_label . '</span>';
						        }
					        }
					        else {
						        echo '<a rel="nofollow" class="telephones__link telephones__link3" href="' . Helper::phone_number_format( $phone, 'tel', $username ) . '">' . Helper::phone_number_mask( strip_tags( $phone ) ) . '</a>';
					        }

					        if ( $operator_icon_id ) {
						        $operator_icon = wp_get_attachment_image_src( $operator_icon_id );
						        echo '<div class="telephone-operator"><img src="' . $operator_icon[0] . '" alt="" loading="lazy"></div>';
					        }

					        echo '</div>';
				        }
				        ?>
                    </div>
                </div>
	        <?php } ?>
        </div>
		<?php
	}

	$text           = get_theme_mod( 'address_text', Helper::get_default_theme_data( 'address_text' ) );
	$link           = get_theme_mod( 'address_link', Helper::get_default_theme_data( 'address_link' ) );
	$img_id         = get_theme_mod( 'address_image' );
	$address_items  = get_theme_mod( 'address_others', [] );
	$location_style = get_theme_mod( 'color_footer_style_location', 'black' );

	if ( $link ) {
		$open_tag  = '<a class="location__link" href="' . esc_url( $link ) . '" target="_blank">';
		$close_tag = '</a>';
	}
	else {
		$open_tag  = '<div class="location__link">';
		$close_tag = '</div>';
	}

	$div_class = 'footer__location location';
	if ( ! $address_items ) {
		$div_class .= ' _one-location';
	}
	if ( 'white' === $location_style ) {
		$div_class .= ' _location-light';
	}
	if ( $text ) {
		?>
        <div class="<?php echo $div_class; ?>">
			<?php echo $open_tag; ?>
			<?php if ( $img_id ) { ?>
				<?php echo wp_get_attachment_image( $img_id, 'medium', false, [ 'class' => 'icon-location icon-custom' ] ); ?>
			<?php } else { ?>
                <svg class="icon-location" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 24 24">
                    <path d="M12 2C8.13 2 5 5.13 5 9c0 5.25 7 13 7 13s7-7.75 7-13c0-3.87-3.13-7-7-7zm0 9.5a2.5 2.5 0 0 1 0-5a2.5 2.5 0 0 1 0 5z" fill="#2178ff"></path>
                </svg>
			<?php } ?>
            <span><?php echo nl2br( $text ); ?></span>
			<?php echo $close_tag; ?>

			<?php if ( $address_items ) { ?>
                <button class="_arrowUpDown location__btn-arrow btn-arrow">
                    <svg class="_arrow-up" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" preserveaspectratio="xMidYMid meet" viewbox="0 0 32 32">
                        <g fill="none" stroke="#626262" stroke-linecap="round" stroke-linejoin="round" stroke-width="4">
                            <path d="M30 12L16 24L2 12"></path>
                        </g>
                    </svg>
                    <svg class="_arrow-down" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" preserveaspectratio="xMidYMid meet" viewbox="0 0 32 32">
                        <g fill="none" stroke="#626262" stroke-linecap="round" stroke-linejoin="round" stroke-width="4">
                            <path d="M30 12L16 24L2 12"></path>
                        </g>
                    </svg>
                </button>
                <div class="location__dropdown dropdown-content">
					<?php
					foreach ( $address_items as $item ) {
						$text   = $item['text'];
						$link   = $item['url'];
						$img_id = $item['image'];
						if ( ! $text ) {
							continue;
						}

						if ( $link ) {
							$open_tag  = '<a class="location__link" href="' . esc_url( $link ) . '" target="_blank" rel="noopener">';
							$close_tag = '</a>';
						}
						else {
							$open_tag  = '<div class="location__link">';
							$close_tag = '</div>';
						}

						echo $open_tag;
						if ( $img_id ) { ?>
							<?php echo wp_get_attachment_image( $img_id, 'medium', false, [ 'class' => 'icon-location icon-custom' ] ); ?>
						<?php } else { ?>
                            <svg class="icon-location" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 24 24">
                                <path d="M12 2C8.13 2 5 5.13 5 9c0 5.25 7 13 7 13s7-7.75 7-13c0-3.87-3.13-7-7-7zm0 9.5a2.5 2.5 0 0 1 0-5a2.5 2.5 0 0 1 0 5z" fill="#2178ff"></path>
                            </svg>
						<?php } ?>
                        <span><?php echo nl2br( $text ); ?></span>
						<?php
						echo $close_tag;
					}
					?>
                </div>
			<?php } ?>
        </div>
		<?php
	}
	?>

	<?php
	$emails       = [];
	$email        = strip_tags( get_theme_mod( 'email_primary', Helper::get_default_theme_data( 'email_primary' ) ) );
	$email_others = get_theme_mod( 'email_others', [] );

	if ( $email ) {
		$emails[] = $email;
	}

	if ( $email_others ) {
		foreach ( $email_others as $item ) {
			$emails[] = $item['email'];
		}
	}

	if ( $emails ) {
		foreach ( $emails as $email ) {
			?>
            <div class="footer__location email">
                <a class="email__link" href="mailto:<?php echo $email; ?>">
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 20 20">
                        <g fill="none">
                            <path d="M2.003 5.884L10 9.882l7.997-3.998A2 2 0 0 0 16 4H4a2 2 0 0 0-1.997 1.884z" fill="white"></path>
                            <path d="M18 8.118l-8 4l-8-4V14a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8.118z" fill="white"></path>
                        </g>
                    </svg>
                    <span><?php echo $email; ?></span>
                </a>
            </div>
			<?php
		}
	}
	?>
</div>