<?php
$args       = get_query_var( 'template_args' );
$terms      = $args['terms'];
$show_count = $args['show_count'];

if ( $terms ) {
	$current_term_id = 0;
	if ( is_category() ) {
		$current_term_id = get_queried_object_id();
	}

	echo '<div class="row category-section__row">';
	foreach ( $terms as $term ) {
		$title = '<span class="category__title">' . $term->name . '</span>';
		if ( $show_count ) {
			$title .= '<span class="category__count">' . $term->count . '</span>';
		}

		if ( $img_id = get_term_meta( $term->term_id, '_thumbnail_id', 1 ) ) {
			$title = '<div class="category__img">' . wp_get_attachment_image( $img_id, 'thumbnail' ) . '</div>' . $title;
		}

		if ( $term->term_id == $current_term_id ) {
			$term_item_html = '<span class="category-section__item category">%1$s</span>';
		}
		else {
			$term_item_html = '<a class="category-section__item category" href="%2$s">%1$s</a>';
		}

		$term_item = sprintf( $term_item_html, $title, esc_url( get_term_link( $term ) ) );

		echo '<div class="col category-section__col">' . $term_item . '</div>';
	}
	echo '</div>';
}


