<?php
$args    = get_query_var( 'template_args' );
$options = $args['instance'];
?>
<div class="row advertising__row">
    <div class="col advertising__col">
		<?php echo $options['link_open']; ?>
		<?php if ( isset( $options['image_id'] ) && $options['image_id'] ) { ?>
            <div class="advertising__image image-overlay">
				<?php echo wp_get_attachment_image( $options['image_id'], 'medium_large' ); ?>
            </div>
		<?php } ?>
        <div class="advertising__body advertising__body-<?php echo $options['style_text']; ?>">
			<?php if ( isset( $options['title_text'] ) && $options['title_text'] ) { ?>
                <div class="advertising__title"><?php echo $options['title_text']; ?></div>
			<?php } ?>
			<?php if ( isset( $options['text'] ) && $options['text'] ) { ?>
                <div class="advertising__text"><?php echo nl2br( $options['text'] ); ?></div>
			<?php } ?>
			<?php if ( isset( $options['link'] ) && $options['link'] && $options['link_text'] ) { ?>
                <div class="advertising__button btn btn-main"><?php echo $options['link_text']; ?></div>
			<?php } ?>
        </div>
		<?php echo $options['link_close']; ?>
    </div>
</div>
