<?php
$args       = get_query_var( 'template_args' );
$users      = $args['users'];
$show_count = $args['show_count'];

if ( $users ) {
	$current_author_id = 0;
	if ( is_author() ) {
		$current_author_id = get_queried_object_id();
	}

	echo '<div class="row authors-section__row">';
	foreach ( $users as $user ) { ?>
        <div class="col authors-section__col">
            <div class="authors-section__item">
				<?php
				if ( $user->ID == $current_author_id ) {
					echo '<span class="author">';
				}
				else {
					echo '<a class="author" href="' . esc_url( get_author_posts_url( $user->ID ) ) . '">';
				}
				?>
                <div class="author__photo image-bg">
					<?php echo get_avatar( $user->user_email, '71' ); ?>
                </div>
                <div class="author__info">
                    <div class="author__name"><?php echo get_the_author_meta( 'display_name', $user->ID ); ?></div>
					<?php
					if ( $show_count ) {
						$count_posts = count_user_posts( $user->ID, 'post', true );
						?>
                        <div class="author__posts">
                            <span class="author__posts-count"><?php echo $count_posts; ?></span>
                            <span class="author__post-label"><?php echo Helper::label_number_items( $count_posts ); ?></span>
                        </div>
						<?php
					}
					?>
                </div>

				<?php
				if ( $user->ID == $current_author_id ) {
					echo '</span>';
				}
				else {
					echo '</a>';
				}
				?>
            </div>
        </div>
		<?php
	}
	echo '</div>';
}


