<?php get_header(); ?>

    <div class="content-title">
        <div class="container">
			<?php the_archive_title( '<h1 class="title">', '</h1>' ); ?>
			<?php if ( term_description() ) { ?>
                <div class="subtitle"><?php echo term_description(); ?></div>
			<?php } ?>
        </div>
    </div>

<?php
if ( is_tax( 'coursetag_wescle' ) ) {
	$terms     = get_terms( [
		'taxonomy' => get_queried_object()->taxonomy,
		'exclude'  => [ get_queried_object_id() ]
	] );
	$show_list = count( $terms ) > 1;
}
else {
	$args  = [
		'taxonomy' => get_queried_object()->taxonomy,
		'parent'   => get_queried_object_id()
	];
	$terms = get_terms( $args );
	if ( ! $terms ) {
		$args['parent'] = 0;
		$terms          = get_terms( $args );
	}
	$show_list = count( $terms ) > 0;
}
if ( $show_list ) {
	?>
    <div class="category-categories">
        <div class="container">
            <div class="category-categories__grid">
				<?php
				foreach ( $terms as $term ) {
					if ( get_queried_object_id() == $term->term_id ) {
						$tag_open  = '<span class="category-categories-item btn btn-main">';
						$tag_close = '</span>';
					}
					else {
						$tag_open  = '<a class="category-categories-item btn btn-main" href="' . get_term_link( $term ) . '">';
						$tag_close = '</a>';
					}

					$thumbnail_id = get_term_meta( $term->term_id, '_thumbnail_id', 1 );

					echo $tag_open;
					if ( $thumbnail_id ) {
						echo wp_get_attachment_image( $thumbnail_id );
					}
					echo '<span>' . $term->name . '</span>';
					echo $tag_close;
				}
				?>
            </div>
        </div>
    </div>
<?php } ?>

    <div class="content">
        <div class="container">
            <div class="row content__row">
                <div class="col content__col content__col_big">
                    <div class="content__body">
						<?php
						if ( have_posts() ) { ?>
                            <section class="post-course" id="post-course">
                                <div class="post-course__row">
									<?php while ( have_posts() ) : the_post(); ?>
										<?php get_template_part( 'template-parts/content/course-item' ); ?>
									<?php endwhile; ?>
                                </div>
                            </section>
							<?php wescle_paginate_links(); ?>
							<?php
						}
						else {
							get_template_part( 'template-parts/content/content', 'none' );
						}
						?>
                    </div>
                </div>
            </div>
        </div>
    </div>

<?php get_footer(); ?>