<?php get_header(); ?>

<?php get_template_part( 'template-parts/archive/title' ); ?>

<?php
$term = get_queried_object();

$code = get_theme_mod( 'reklama_archive_before_content', '' );
if ( $code ) {
	set_query_var( 'template_args', [ 'code' => $code ] );
	get_template_part( 'template-parts/section/advt', '' );
}
$class_three_in_row = get_theme_mod( 'catalog_archive_three_in_row' ) ? ' _3' : '';

$show_map     = get_theme_mod( 'catalog_archive_show_map' );
$top_show_map = get_theme_mod( 'catalog_archive_top_show_map' );
?>
    <div class="content">
        <div class="container">
            <div class="row content__row">
                <div class="col content__col content__col_big">
                    <div class="content__body">
						<?php
						if ( have_posts() ) {
							echo '<div class="_tabs-block" data-number="0"><div class="wescle-transport__grid' . $class_three_in_row . '">';

							while ( have_posts() ) : the_post();
								get_template_part( 'template-parts/content/catalog-item' );
							endwhile;

							echo '</div></div>';

							wescle_paginate_links();
						}

						if ( ! is_paged() ) {
							$description_bottom = get_term_meta( get_queried_object_id(), 'description_bottom', 1 );
							if ( $description_bottom || ( $show_map && ! $top_show_map ) ) {
								?>
                                <div class="content-bottom entry-content text section-post__editor">
									<?php
									if ( $description_bottom ) {
										echo do_shortcode( shortcode_unautop( wpautop( $description_bottom ) ) );
									}
									if ( get_theme_mod( 'catalog_archive_show_map' ) ) {
										echo do_shortcode( '[catalog_map]' );
									}
									?>
                                </div>
								<?php
							}
						}
						?>
                    </div>
                </div>

				<?php get_sidebar( 'catalog' ); ?>
            </div>
        </div>
    </div>

<?php
$code = get_theme_mod( 'reklama_archive_after_content', '' );
if ( $code ) {
	set_query_var( 'template_args', [ 'code' => $code ] );
	get_template_part( 'template-parts/section/advt', '' );
}
?>

<?php get_footer(); ?>