<?php
$button_text  = get_post_meta( $post->ID, 'button_text', 1 );
$button_url   = get_post_meta( $post->ID, 'button_link', 1 );
$target_blank = get_post_meta( $post->ID, 'button_link_is_blank', 1 ) ? 'target="_blank" rel="noopener noreferrer"' : '';

$order_checkbox_disabled = get_post_meta( $post->ID, 'order_checkbox_disabled', 1 );
?>
<div class="catalog-post__aside">
	<?php
	$code = get_theme_mod( 'reklama_sidebar_top', '' );
	if ( $code ) {
		echo '<div class="widget">' . do_shortcode( $code ) . '</div>';
	}
	?>

	<?php
	if ( ! Helper::is_external_url( $button_url ) ) {
		get_template_part( 'template-parts/content/catalog-item', null, [ 'short' => true, 'checkbox_disabled' => $order_checkbox_disabled ] );
	}
	else {
		?>
        <span class="btn btn-main btn-main_blue js-link" data-link="<?php echo $button_url; ?>" <?php echo $target_blank; ?> data-name="<?php echo esc_attr( $post->post_title ); ?>" data-url="<?php echo esc_url( get_permalink( $post ) ); ?>"><span><?php echo $button_text; ?></span></span>
		<?php
	}
	?>

	<?php dynamic_sidebar( 'sidebar-catalog' ); ?>

	<?php
	$code = get_theme_mod( 'reklama_sidebar_bottom', '' );
	if ( $code ) {
		echo '<div class="widget">' . do_shortcode( $code ) . '</div>';
	}
	?>
</div>