<?php get_header(); ?>

<?php
$post_version = Helper::get_single_about_version();

if ( $post_version == 'v4' ) {
	get_template_part( 'template-parts/post/promo', $post_version );
}

$thumb_size = THEME_SLUG . '_single_thumbnail';

$post_blocks_hide = Helper::get_post_blocks_hide();
?>
    <div class="content">
        <div class="container">
            <div class="row content__row">
                <div class="col content__col content__col_big">
                    <div class="content__body">
						<?php get_template_part( 'template-parts/breadcrumbs' ); ?>

						<?php
						set_query_var( 'template_args', [ 'key' => 'after_breadcrumb' ] );
						get_template_part( 'template-parts/post/advertising' );
						?>

						<?php while ( have_posts() ) : the_post(); ?>
							<?php get_template_part( 'template-parts/post/course-navigation' ); ?>

                            <section class="section-post section-post_<?php echo $post_version; ?>">
								<?php get_template_part( 'template-parts/post/about', $post_version ); ?>

								<?php if ( $post_version == 'v1' && get_post_thumbnail_id() && Helper::get_post_about_version_image() ) { ?>
									<?php $custom_class = Helper::is_about_image_height_variable() ? 'section-post__image_nocrop' : ''; ?>
                                    <div class="section-post__image section-post__image_main <?php echo $custom_class; ?>">
										<?php the_post_thumbnail( 'wescle_single_thumbnail' ); ?>
                                    </div>
								<?php } ?>

								<?php
								set_query_var( 'template_args', [ 'key' => 'before_content' ] );
								get_template_part( 'template-parts/post/advertising' );
								?>

                                <div class="course-preview">
                                    <div class="course-preview__desc">
										<?php the_content(); ?>
										<?php
										$text_open  = get_theme_mod( 'course_text_open', Helper::get_text_label( 'open' ) );
										$text_close = get_theme_mod( 'course_text_close', Helper::get_text_label( 'close' ) );
										$height     = get_theme_mod( 'course_text_height', 200 );
										?>
                                        <button class="btn_expand js-hide" type="button" data-text-open="<?php echo $text_open; ?>" data-text-close="<?php echo $text_close; ?>" data-height="<?php echo $height; ?>">
                                            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 24 24">
                                                <g fill="none">
                                                    <path d="M4 9l8 8l8-8" stroke="#626262" stroke-width="3" stroke-linecap="round" stroke-linejoin="round"></path>
                                                </g>
                                            </svg>
                                            <span><?php echo $text_open; ?></span>
                                        </button>
                                    </div>
                                </div>
								<?php
								$tags       = get_the_terms( $post, 'coursetag_wescle' );
								$info_items = get_post_meta( $post->ID, 'wescle_course_advantages', 1 );

								$title_block = get_post_meta( $post->ID, 'advantages_title', 1 );
								if ( ! $title_block ) {
									$title_block = get_theme_mod( 'course_advantages_title', Helper::get_default_theme_data( 'course_advantages_title' ) );
								}
								if ( $tags || $info_items ) { ?>
                                    <div class="course-advantages" id="what-learn">
										<?php if ( $info_items ) { ?>
                                            <div class="course-advantages__block">
												<?php if ( $title_block ) { ?>
                                                    <div class="course-advantages__title"><?php echo $title_block; ?></div>
												<?php } ?>
                                                <div class="course-advantages__grid">
													<?php foreach ( $info_items as $item ) { ?>
                                                        <div class="course-advantages-item">
                                                            <div class="course-advantages-item__img">
                                                                <svg xmlns="http://www.w3.org/2000/svg" aria-hidden="true" width="1em" height="1em" style="-ms-transform:rotate(360deg);-webkit-transform:rotate(360deg)" viewbox="0 0 16 16" transform="rotate(360)">
                                                                    <path fill-rule="evenodd" d="M10.97 4.97a.75.75 0 011.071 1.05l-3.992 4.99a.75.75 0 01-1.08.02L4.324 8.384a.75.75 0 111.06-1.06l2.094 2.093 3.473-4.425a.236.236 0 01.02-.022z" fill="#08c"></path>
                                                                </svg>
                                                            </div>
                                                            <div class="course-advantages-item__text"><?php echo nl2br( $item['text'] ); ?></div>
                                                        </div>
													<?php } ?>
                                                </div>
                                            </div>
										<?php } ?>

										<?php
										if ( $tags ) {
											$title_block = get_post_meta( $post->ID, 'tags_title', 1 );
											if ( ! $title_block ) {
												$title_block = get_theme_mod( 'course_tags_title', Helper::get_default_theme_data( 'course_tags_title' ) );
											}
											?>
                                            <div class="course-advantages__block">
												<?php if ( $title_block ) { ?>
                                                    <div class="course-advantages__title"><?php echo $title_block; ?></div>
												<?php } ?>
                                                <div class="course-advantages__line">
													<?php foreach ( $tags as $tag ) { ?>
                                                        <a href="<?php echo get_term_link( $tag ); ?>" class="course-advantages-item"><span><?php echo $tag->name; ?></span></a>
													<?php } ?>
                                                </div>
                                            </div>
										<?php } ?>
                                    </div>
								<?php } ?>

	                            <?php
	                            $video_ids = get_post_meta( $post->ID, 'course_video_ids', 1 );
	                            if ( $video_ids ) {
		                            $video_posts = get_posts( [
			                            'post_type'      => 'course_video',
			                            'posts_per_page' => - 1,
			                            'post__in'       => $video_ids,
			                            'orderby'        => 'post__in'
		                            ] );

		                            ?>
                                    <div class="video-max" id="video-max">
                                        <div class="video-max__grid">
                                            <div class="video-max-main">
                                                <div class="video-max-main__video">
						                            <?php foreach ( $video_posts as $item ) { ?>
							                            <?php
							                            $video_id = Helper::get_youtube_video_id( get_post_meta( $item->ID, 'youtube_link', 1 ) );
							                            if ( ! $video_id ) {
								                            continue;
							                            }
							                            $img_src = wp_get_attachment_image_src( get_post_thumbnail_id( $item ), 'large' );
							                            ?>
                                                        <div class="_video-iframe" data-src="<?php echo $video_id; ?>" style="background-image: url(<?php echo $img_src[0]; ?>);">
                                                            <div class="btn-play">
                                                                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 448 512">
                                                                    <path d="M424.4 214.7L72.4 6.6C43.8-10.3 0 6.1 0 47.9V464c0 37.5 40.7 60.1 72.4 41.3l352-208c31.4-18.5 31.5-64.1 0-82.6z" fill="white"></path>
                                                                </svg>
                                                            </div>
                                                        </div>
							                            <?php break;
						                            } ?>
                                                </div>
                                            </div>
                                            <div class="video-max-list">
					                            <?php foreach ( $video_posts as $item ) { ?>
						                            <?php
						                            $video_id = Helper::get_youtube_video_id( get_post_meta( $item->ID, 'youtube_link', 1 ) );
						                            if ( ! $video_id ) {
							                            continue;
						                            }
						                            ?>
                                                    <a class="video-max-block" href="#" data-src="<?php echo $video_id; ?>">
                                                        <div class="video-max-block__body">
                                                            <div class="video-max-block__subtitle">
                                                                <span class="video-max-block__name"><?php echo $item->post_title; ?></span>
									                            <?php if ( $duration = get_post_meta( $item->ID, 'time_duration', 1 ) ) { ?>
                                                                    <span class="video-max-block__time"><?php echo $duration; ?></span>
									                            <?php } ?>
                                                            </div>
                                                            <div class="video-max-block__title"><?php echo nl2br( $item->post_content ); ?></div>
                                                        </div>
                                                    </a>
					                            <?php } ?>
                                            </div>
                                        </div>
                                    </div>
		                            <?php
	                            }
	                            ?>

	                            <?php
	                            set_query_var( 'template_args', [ 'key' => 'after_content' ] );
	                            get_template_part( 'template-parts/post/advertising' );
	                            ?>

	                            <?php
	                            if ( ! in_array( 'share', $post_blocks_hide ) ) {
		                            get_template_part( 'template-parts/post/share' );

									set_query_var( 'template_args', [ 'key' => 'after_share' ] );
									get_template_part( 'template-parts/post/advertising' );
								}
								?>

								<?php
								if ( ! in_array( 'author_info', $post_blocks_hide ) ) {
									get_template_part( 'template-parts/post/author' );

									set_query_var( 'template_args', [ 'key' => 'after_author' ] );
									get_template_part( 'template-parts/post/advertising' );
								}
								?>

								<?php get_template_part( 'template-parts/post/navigation' ); ?>
                            </section>

							<?php
							set_query_var( 'template_args', [ 'key' => 'before_related' ] );
							get_template_part( 'template-parts/post/advertising' );
							?>

							<?php get_template_part( 'template-parts/post/related' ); ?>

							<?php
							if ( ( comments_open() || get_comments_number() ) && ! post_password_required() ) {
								comments_template();
							}
							?>

						<?php endwhile; ?>
                    </div>
                </div>
				<?php get_template_part( 'template-parts/post/sidebar-course' ); ?>
            </div>
        </div>
    </div>

<?php get_footer(); ?>