<?php get_header(); ?>

<?php
$post_version     = Helper::get_single_about_version();
$post_blocks_hide = Helper::get_post_blocks_hide();
?>
    <div class="content">
		<?php get_template_part( 'template-parts/post/catalog-navigation' ); ?>
        <div class="container">
            <div class="row content__row">
                <div class="col content__col content__col_big">
                    <div class="content__body" itemscope itemtype="http://schema.org/Article">
						<?php get_template_part( 'template-parts/breadcrumbs' ); ?>

						<?php
						set_query_var( 'template_args', [ 'key' => 'after_breadcrumb' ] );
						get_template_part( 'template-parts/post/advertising' );
						?>

						<?php while ( have_posts() ) : the_post(); ?>

                            <section class="section-post section-post_<?php echo $post_version; ?>">
								<?php
								if ( $post_version == 'v1' ) {
									get_template_part( 'template-parts/post/about', $post_version );
								}
								else {
									get_template_part( 'template-parts/post/catalog-gallery' );
								}
								?>
                                <div class="section-post__body">
									<?php
									set_query_var( 'template_args', [ 'key' => 'before_content' ] );
									get_template_part( 'template-parts/post/advertising' );
									?>

									<?php
									if ( $post_version == 'v1' ) {
										get_template_part( 'template-parts/post/catalog-gallery' );
									}
									else {
										get_template_part( 'template-parts/post/about', $post_version );
									}
									?>

                                    <div class="catalog-post__body">
                                        <div class="section-post__editor entry-content" itemprop="articleBody" id="description">
			                                <?php the_content(); ?>

			                                <?php edit_post_link(); ?>
                                        </div>

	                                    <?php get_template_part( 'template-parts/singular/sidebar-catalog_item' ); ?>
                                    </div>

	                                <?php
	                                $lat  = get_post_meta( $post->ID, 'lat', 1 );
	                                $lng  = get_post_meta( $post->ID, 'lng', 1 );
	                                $zoom = get_post_meta( $post->ID, 'zoom', 1 );
	                                if ( ! $zoom ) {
		                                $zoom = 7;
	                                }
	                                if ( $lat && $lng ) {
		                                echo do_shortcode( '[catalog_map center_lat="' . $lat . '" center_lng="' . $lng . '" zoom="' . $zoom . '"]' );
	                                }
	                                ?>
                                </div>

	                            <?php
	                            set_query_var( 'template_args', [ 'key' => 'after_content' ] );
	                            get_template_part( 'template-parts/post/advertising' );
	                            ?>

								<?php
								if ( ! in_array( 'share', $post_blocks_hide ) ) {
									get_template_part( 'template-parts/post/share' );

									set_query_var( 'template_args', [ 'key' => 'after_share' ] );
									get_template_part( 'template-parts/post/advertising' );
								}
								?>

								<?php
								if ( ! in_array( 'author_info', $post_blocks_hide ) ) {
									get_template_part( 'template-parts/post/author' );

									set_query_var( 'template_args', [ 'key' => 'after_author' ] );
									get_template_part( 'template-parts/post/advertising' );
								}
								?>

								<?php get_template_part( 'template-parts/post/navigation' ); ?>
                            </section>

							<?php
							set_query_var( 'template_args', [ 'key' => 'before_related' ] );
							get_template_part( 'template-parts/post/advertising' );
							?>

							<?php get_template_part( 'template-parts/post/related' ); ?>

							<?php
							if ( ( comments_open() || get_comments_number() ) && ! post_password_required() ) {
								comments_template();
							}
							?>

                            <meta itemscope itemprop="mainEntityOfPage" itemType="https://schema.org/WebPage" itemid="<?php the_permalink() ?>" content="<?php the_title(); ?>">
                            <meta itemprop="datePublished" content="<?php the_time( 'c' ) ?>">
                            <meta itemprop="author" content="<?php the_author() ?>">
							<?php echo Helper::html_microdata_publisher() ?>
							<?php echo Helper::html_microdata_image() ?>

						<?php endwhile; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

<?php get_footer(); ?>