<?php
if ( ! Helper::is_woocommerce_active() ) {
	return;
}

$block            = $args['block'];
$key_block        = $args['key_block'];
$block_attributes = $args['block_attributes'] ?? [];

$title      = $block['woo_block_title'];
$title_type = $block['woo_block_title_type'];
$text       = $block['woo_block_text'];

$link    = $block['woo_block_link_url'];
$link_id = $block['woo_block_link_id'];
if ( $link_id ) {
	$link = get_permalink( $link_id );
}
$link_text = $block['woo_block_link_text'];

$products_type = $block['woo_block_product_type'];
$limit         = intval( $block['woo_block_limit'] );
if ( $limit < 1 ) {
	$limit = 10;
}
$product_args = [
	'post_type'        => 'product',
	'posts_per_page'   => $limit,
	'tax_query'        => [],
	'orderby'          => [ 'menu_order' => 'ASC', 'date' => 'DESC' ],
	'suppress_filters' => false
];

if ( 'custom' == $products_type ) {
	if ( $block['woo_block_category'] && $block['woo_block_category'][0] ) {
		$product_args['tax_query'][] = [
			'taxonomy' => 'product_cat',
			'terms'    => $block['woo_block_category']
		];
	}

	if ( $block['woo_block_products'] ) {
		unset( $product_args['tax_query'] );

		if ( is_string( $block['woo_block_products'] ) ) {
			$block['woo_block_products'] = explode( ',', str_replace( ' ', '', $block['woo_block_products'] ) );
		}

		$product_args['posts_per_page'] = count( $block['woo_block_products'] );
		$product_args['post__in']       = $block['woo_block_products'];
		$product_args['orderby']        = 'post__in';
	}
}

if ( 'new' == $products_type ) {
	$product_args['orderby'] = [ 'date' => 'DESC' ];
}
if ( 'sale' == $products_type ) {
	$product_args['post__in'] = array_merge( array( 0 ), wc_get_product_ids_on_sale() );
	$product_args['orderby']  = 'post__in';
}
if ( 'views' == $products_type ) {
	$product_args['meta_key'] = 'views';
	$product_args['orderby']  = [ 'meta_value_num' => 'DESC' ];

	if ( Helper::is_plugin_active( 'post-views-counter/post-views-counter.php' ) ) {
		$product_args['suppress_filters'] = false;
		$product_args['orderby']          = 'post_views';
		$product_args['fields']           = '';
		$product_args['meta_key']         = '';
	}
}
if ( 'popular' == $products_type ) {
	$product_args['meta_key'] = 'total_sales';
	$product_args['orderby']  = [ 'meta_value_num' => 'DESC' ];
}

$posts_product = get_posts( apply_filters( 'woo_block_products_args', $product_args ) );
if ( ! $posts_product ) {
	return;
}

$style_bg = '';
if ( $color_bg = $block['woo_block_color_bg'] ) {
	$style_bg = ' style="background-color:' . $color_bg . ';"';
}

$style_title = '';
if ( $color = $block['woo_block_color_title'] ) {
	$style_title = 'style="color:' . $color . ';"';
}

if ( $block_id = $block['woo_block_id_block'] ) {
	$block_id = str_replace( '#', '', $block_id );
	echo '<div class="block_divider" id="' . $block_id . '"></div>';
}

$is_show_stock  = get_theme_mod( 'product_stock_enabled', false );
$is_show_rating = get_theme_mod( 'product_rating_enabled', false );
if ( isset( $block['woo_block_product_stock_enabled'] ) ) {
	$is_show_stock = $block['woo_block_product_stock_enabled'];
}
if ( isset( $block['woo_block_product_rating_enabled'] ) ) {
	$is_show_rating = $block['woo_block_product_rating_enabled'];
}

if ( $block_attributes ) {
	$is_show_stock  = $block_attributes['showProductAvailability'] ?? false;
	$is_show_rating = $block_attributes['showProductRating'] ?? false;
}

$slider_enabled       = $block['slider_enabled'] ?? true;
$grid_count           = $block['grid_count'] ?? 5;
$slides_count         = $block['slides_count'] ?? 5;
$slider_speed         = $block['slider_speed'] ?? 8000;
$slider_dots          = $block['slider_dots'] ?? 'false';
$slider_arrows        = $block['slider_arrows'] ?? 'true';
$slider_arrows_mobile = $block['slider_arrows_mobile'] ?? '';

$section_class    = $block['section_class'] ?? '';
$section_position = $block['woo_block_position_content'] ?? 'default';
if ( 'default' != $section_position ) {
	$section_class .= '_section-' . $section_position . ' ';
}

$div_class    = 'goods-slider-section';
$slider_class = 'goods-slider-section__slider';
if ( ! $slider_enabled ) {
	$div_class    = 'goods-slider-section goods-noslider';
	$slider_class = 'goods-slider-section__grid _grid-' . $grid_count;
}
?>
<div class="<?php echo $section_class; ?><?php echo $div_class; ?>" id="goods-slider-<?php echo $key_block; ?>"<?php echo $style_bg; ?>>
	<?php
	if ( $block_attributes ) {
		wescle_blocks_bg_image( $block_attributes );
	}
	else {
		echo wescle_woo_block_bg_image( $block );
	}
	?>
    <div class="container">
		<?php if ( $slider_enabled ) { ?>
        <div class="slider-wrapper <?php echo $slider_arrows_mobile; ?>">
			<?php } ?>
            <div class="goods-slider-section__header">
                <div class="goods-slider-section__about">
					<?php
					if ( $title ) {
						printf( '<%1$s class="goods-slider-section__title title title_divider" %2$s>' . $title . '</%1$s>', $title_type, $style_title );
					}
					?>
					<?php if ( $text ) { ?>
                        <div class="goods-slider-section__text"><?php echo $text; ?></div>
					<?php } ?>
                </div>
				<?php if ( $link && $link_text ) { ?>
                    <a class="goods-slider-section__link" href="<?php echo esc_url( $link ); ?>"><?php echo esc_html( $link_text ); ?></a>
				<?php } ?>
				<?php if ( $slider_enabled ) { ?>
                    <div class="goods-slider-section__buttons slider-buttons">
                        <button class="slider-buttons__item slider-buttons__item_prev" type="button">
                            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(180deg); -webkit-transform: rotate(180deg); transform: rotate(180deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 42 42">
                                <path fill-rule="evenodd" d="M11 38.32L28.609 21L11 3.68L13.72 1L34 21.01L13.72 41z" fill="white"></path>
                            </svg>
                        </button>
                        <button class="slider-buttons__item slider-buttons__item_next" type="button">
                            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 42 42">
                                <path fill-rule="evenodd" d="M11 38.32L28.609 21L11 3.68L13.72 1L34 21.01L13.72 41z" fill="white"></path>
                            </svg>
                        </button>
                    </div>
				<?php } ?>
            </div>
            <div class="<?php echo $slider_class; ?> goods-slider-<?php echo $key_block; ?>__slider" data-slides="<?php echo $slides_count; ?>" data-autoplay-speed="<?php echo $slider_speed; ?>" data-dots="<?php echo $slider_dots; ?>" data-arrows="<?php echo $slider_arrows; ?>">
				<?php
				$item_args = [
					'is_show_stock'  => $is_show_stock,
					'is_show_rating' => $is_show_rating,
					'isset_slider'   => $slider_enabled,
				];

				if ( ! $is_show_stock ) {
					remove_action( 'woocommerce_shop_loop_item_title', 'wescle_loop_stock_product', 5 );
					remove_action( 'woocommerce_before_shop_loop_item_title', 'wescle_loop_stock_product', 5 );
				}
				else {
					add_action( 'woocommerce_shop_loop_item_title', 'wescle_loop_stock_product', 5 );
					add_action( 'woocommerce_before_shop_loop_item_title', 'wescle_loop_stock_product', 5 );
				}
				if ( ! $is_show_rating ) {
					remove_action( 'woocommerce_shop_loop_item_title', 'wescle_loop_rating_product', 5 );
					remove_action( 'woocommerce_before_shop_loop_item_title', 'wescle_loop_rating_product', 5 );
				}
				else {
					add_action( 'woocommerce_shop_loop_item_title', 'wescle_loop_rating_product', 5 );
					add_action( 'woocommerce_before_shop_loop_item_title', 'wescle_loop_rating_product', 5 );
				}

				foreach ( $posts_product as $post ) {
					setup_postdata( $post );

					get_template_part( 'template-parts/section/woo-products', 'item', $item_args );
				}
				wp_reset_postdata();
				?>
            </div>
			<?php if ( $slider_enabled ) { ?>
        </div>
	<?php } ?>
    </div>
</div>