<?php
if ( ! Helper::is_woocommerce_active() ) {
	return;
}

$block            = $args['block'];
$key_block        = $args['key_block'];
$block_attributes = $args['block_attributes'] ?? '';

$title      = str_replace( '%', '%%', $block['woo_block_title'] );
$title_type = $block['woo_block_title_type'];
$text       = $block['woo_block_text'];

$link    = $block['woo_block_link_url'];
$link_id = $block['woo_block_link_id'];
if ( $link_id ) {
	$link = get_permalink( $link_id );
}
$link_text = $block['woo_block_link_text'];

$default_category_id = absint( get_option( 'default_product_cat', 0 ) );
$terms_args          = [
	'taxonomy'   => 'product_cat',
	'hide_empty' => true,
	'orderby'    => 'menu_order',
	'exclude'    => [ $default_category_id ]
];

$category_selected = $block['woo_block_category_select'];
if ( $category_selected && $category_selected[0] ) {
	$terms_args['include'] = $category_selected;
	if ( $block_attributes ) {
		$terms_args['orderby'] = 'include';
	}
}
else {
	$limit = intval( $block['woo_block_category_limit'] );
	if ( $limit < 1 ) {
		$limit = 10;
	}
	$terms_args['number'] = $limit;
}
$terms = get_terms( apply_filters( 'woo_block_category_args', $terms_args ) );
if ( ! $terms ) {
	return;
}

$style_bg = '';
if ( $color_bg = $block['woo_block_color_bg'] ) {
	$style_bg = 'style="background-color:' . $color_bg . ';"';
}

$style_title = '';
if ( $color = $block['woo_block_color_title'] ) {
	$style_title = 'style="color:' . $color . ';"';
}

if ( $block_id = $block['woo_block_id_block'] ) {
	$block_id = str_replace( '#', '', $block_id );
	echo '<div class="block_divider" id="' . $block_id . '"></div>';
}

$category_shadow       = $block['woo_block_category_shadow'] ?? true;
$category_count_at_img = $block['woo_block_category_count_at_img'] ?? false;
$category_show_count   = $block['woo_block_category_show_count'] ?? true;

$slider_enabled       = $block['slider_enabled'] ?? true;
$grid_count           = $block['grid_count'] ?? 5;
$slides_count         = $block['slides_count'] ?? 5;
$slider_speed         = $block['slider_speed'] ?? 8000;
$slider_dots          = $block['slider_dots'] ?? 'false';
$slider_arrows        = $block['slider_arrows'] ?? 'true';
$slider_arrows_mobile = $block['slider_arrows_mobile'] ?? '';

$section_class    = $block['section_class'] ?? '';
$section_position = $block['woo_block_position_content'] ?? 'default';
if ( 'default' != $section_position ) {
	$section_class .= '_section-' . $section_position . ' ';
}

$div_class = 'goods-categories-noslider goods-categories';
if ( $slider_enabled ) {
	$div_class = 'goods-slider-section goods-categories';
}
if ( ! $category_shadow ) {
	$div_class .= ' _without-shadow';
}
if ( $category_count_at_img ) {
	$div_class .= ' _count-at-img';
}
?>
<div class="<?php echo $section_class; ?> <?php echo $div_class; ?>" id="goods-categories-<?php echo $key_block; ?>" <?php echo $style_bg; ?>>
	<?php
	if ( $block_attributes ) {
		wescle_blocks_bg_image( $block_attributes );
	}
	else {
		echo wescle_woo_block_bg_image( $block );
	}
	?>
    <div class="container">
		<?php if ( $slider_enabled ) { ?>
        <div class="slider-wrapper <?php echo $slider_arrows_mobile; ?>">
			<?php } ?>
            <div class="goods-slider-section__header">
                <div class="goods-slider-section__about">
					<?php
					if ( $title ) {
						printf( '<%1$s class="goods-slider-section__title title title_divider" %2$s>' . $title . '</%1$s>', $title_type, $style_title );
					}
					?>
					<?php if ( $text ) { ?>
                        <div class="goods-slider-section__text"><?php echo $text; ?></div>
					<?php } ?>
                </div>
				<?php if ( $link && $link_text ) { ?>
                    <a class="goods-slider-section__link" href="<?php echo esc_url( $link ); ?>"><?php echo esc_html( $link_text ); ?></a>
				<?php } ?>
				<?php if ( $slider_enabled ) { ?>
                    <div class="goods-slider-section__buttons slider-buttons">
                        <button class="slider-buttons__item slider-buttons__item_prev" type="button">
                            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(180deg); -webkit-transform: rotate(180deg); transform: rotate(180deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 42 42">
                                <path fill-rule="evenodd" d="M11 38.32L28.609 21L11 3.68L13.72 1L34 21.01L13.72 41z" fill="white"></path>
                            </svg>
                        </button>
                        <button class="slider-buttons__item slider-buttons__item_next" type="button">
                            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 42 42">
                                <path fill-rule="evenodd" d="M11 38.32L28.609 21L11 3.68L13.72 1L34 21.01L13.72 41z" fill="white"></path>
                            </svg>
                        </button>
                    </div>
				<?php } ?>
            </div>
			<?php if ( $slider_enabled ) { ?>
                <div class="goods-categories__slider goods-categories-<?php echo $key_block; ?>__slider" data-slides="<?php echo $slides_count; ?>" data-autoplay-speed="<?php echo $slider_speed; ?>" data-dots="<?php echo $slider_dots; ?>" data-arrows="<?php echo $slider_arrows; ?>">
					<?php foreach ( $terms as $term ) { ?>
                        <div class="goods-categories__slide">
                            <a class="goods-categories-item" href="<?php echo get_term_link( $term ); ?>">
                                <div class="goods-categories-item__image">
									<?php woocommerce_subcategory_thumbnail( $term ); ?>
									<?php if ( $category_show_count && $category_count_at_img ) { ?>
                                        <div class="goods-categories-item__count"><?php echo $term->count; ?></div>
									<?php } ?>
                                </div>
                                <div class="goods-categories-item__body">
									<?php if ( $category_show_count && ! $category_count_at_img ) { ?>
                                        <div class="goods-categories-item__count"><?php echo $term->count; ?></div>
									<?php } ?>
                                    <div class="goods-categories-item__title"><?php echo $term->name; ?></div>
                                </div>
                            </a>
                        </div>
					<?php } ?>
                </div>
			<?php } else { ?>
                <div class="goods-categories__grid _grid-<?php echo $grid_count; ?>">
					<?php foreach ( $terms as $term ) { ?>
                        <a class="goods-categories-item" href="<?php echo get_term_link( $term ); ?>">
                            <div class="goods-categories-item__image">
								<?php woocommerce_subcategory_thumbnail( $term ); ?>
								<?php if ( $category_show_count && $category_count_at_img ) { ?>
                                    <div class="goods-categories-item__count"><?php echo $term->count; ?></div>
								<?php } ?>
                            </div>
                            <div class="goods-categories-item__body">
								<?php if ( $category_show_count && ! $category_count_at_img ) { ?>
                                    <div class="goods-categories-item__count"><?php echo $term->count; ?></div>
								<?php } ?>
                                <div class="goods-categories-item__title"><?php echo $term->name; ?></div>
                            </div>
                        </a>
					<?php } ?>
                </div>
			<?php } ?>
			<?php if ( $slider_enabled ) { ?>
        </div>
	<?php } ?>
    </div>
</div>