<?php
$args          = get_query_var( 'template_args' );
$posts_section = $args['posts'];
if ( ! $posts_section ) {
	return;
}

$block_title      = $args['block_title'] ?? '';
$block_title_type = ( isset( $args['block_title_type'] ) && $args['block_title_type'] ) ? $args['block_title_type'] : 'div';
$block_text       = $args['block_text'] ?? '';
$link_text        = $args['link_text'] ?? '';
$link_url         = $args['link_url'] ?? '';

$div_class         = 'recommended';
$post_card_columns = $args['post_card_columns'] ?? '3';
if ( '2' == $post_card_columns ) {
	$div_class .= ' recommended_col2';
}
else {
	$div_class .= ' recommended_col3';
}
?>
<div class="<?php echo $div_class; ?>">
	<?php
	if ( $block_title ) {
		printf( '<%1$s class="recommended__title title title_content title_divider">' . $block_title . '</%1$s>', $block_title_type );
	}
	if ( $block_text || $link_url ) {
		echo '<div class="recommended__header">';
		if ( $block_text ) {
			echo '<div class="recommended__text">' . $block_text . '</div>';
		}
		if ( $link_text && $link_url ) {
			echo '<a class="recommended__link" href="' . $link_url . '">' . $link_text . '</a>';
		}
		echo '</div>';
	}
	?>

    <div class="row recommended__row">
		<?php
		foreach ( $posts_section as $post ) {
			setup_postdata( $post );

			$itemscope = '';
			if ( Helper::is_microdata_active() ) {
				if ( is_archive() ) {
					$itemscope = 'itemscope itemprop="blogPost" itemtype="http://schema.org/BlogPosting"';
				}
				else {
					$itemscope = 'itemscope itemtype="http://schema.org/BlogPosting"';
				}
			}
			?>
            <div class="col recommended__col" <?php echo $itemscope; ?>>
                <div class="recommended__post recommended-post post">
                    <div class="post__image">
                        <a href="<?php the_permalink(); ?>">
							<?php
							$img_size = THEME_SLUG . '_loop_thumbnail_default';

							if ( $img_id = get_post_meta( $post->ID, 'thumbnail_archive', 1 ) ) {
								echo str_replace( '<img ', '<img itemprop="image" ', wp_get_attachment_image( $img_id, $img_size ) );
							}
							else {
								echo str_replace( '<img ', '<img itemprop="image" ', get_the_post_thumbnail( $post, $img_size ) );
							}
							?>
                        </a>
						<?php if ( isset( $args['post_card_meta']['category'] ) ) { ?>
							<?php post_card_category(); ?>
						<?php } ?>
                    </div>
                    <div class="post__body">
						<?php post_card_title(); ?>

						<?php if ( isset( $args['post_card_meta']['excerpt'] ) ) { ?>
                            <div class="post__text" itemprop="articleBody"><?php post_card_excerpt(); ?></div>
						<?php } ?>

						<?php post_card_meta( $args['post_card_meta'] ); ?>

						<?php if ( $itemscope ) { ?>
							<?php echo Helper::html_microdata_publisher(); ?>
                            <meta itemscope itemprop="mainEntityOfPage" itemType="https://schema.org/WebPage" itemid="<?php echo esc_url( get_permalink() ); ?>" content="<?php echo esc_attr( get_the_title() ); ?>">
						<?php } ?>
                    </div>
                </div>
            </div>
			<?php
		}
		wp_reset_postdata();
		?>
    </div>
</div>