<?php
$args          = get_query_var( 'template_args' );
$posts_section = $args['posts'];
if ( ! $posts_section ) {
	return;
}

$block_class      = isset( $args['block_class'] ) ? $args['block_class'] : '';
$block_title      = isset( $args['block_title'] ) ? $args['block_title'] : '';
$block_title_type = ( isset( $args['block_title_type'] ) && $args['block_title_type'] ) ? $args['block_title_type'] : 'div';
$block_text       = $args['block_text'] ?? '';
$link_text        = $args['link_text'] ?? '';
$link_url         = $args['link_url'] ?? '';

$isset_itemprop = isset( $args['is_itemprop'] ) ? $args['is_itemprop'] : true;
?>
<div class="latest2 <?php echo $block_class; ?>">
	<?php
	if ( $block_title ) {
		printf( '<%1$s class="latest2__title title title_content title_divider">' . $block_title . '</%1$s>', $block_title_type );
	}
	if ( $block_text || $link_url ) {
		echo '<div class="latest2__header">';
		if ( $block_text ) {
			echo '<div class="latest2__text">' . $block_text . '</div>';
		}
		if ( $link_text && $link_url ) {
			echo '<a class="latest2__link" href="' . $link_url . '">' . $link_text . '</a>';
		}
		echo '</div>';
	}
	?>

    <div class="latest2__row">
		<?php
		foreach ( $posts_section as $post ) {
			setup_postdata( $post );

			$itemscope = '';
			if ( $isset_itemprop && Helper::is_microdata_active() ) {
				if ( is_archive() ) {
					$itemscope = 'itemscope itemprop="blogPost" itemtype="http://schema.org/BlogPosting"';
				}
				else {
					$itemscope = 'itemscope itemtype="http://schema.org/BlogPosting"';
				}
			}
			?>
            <div class="latest2__col" <?php echo $itemscope; ?>>
                <div class="latest2__post latest2-post post">
                    <a href="<?php the_permalink(); ?>" class="post__image">
						<?php
						$replace = '';
						if ( $isset_itemprop ) {
							$replace = ' itemprop="image"';
						}

						$img_size = 'medium';

						if ( $img_id = get_post_meta( $post->ID, 'thumbnail_archive', 1 ) ) {
							echo str_replace( '<img ', '<img' . $replace . ' ', wp_get_attachment_image( $img_id, $img_size ) );
						}
						else {
							echo str_replace( '<img ', '<img' . $replace . ' ', get_the_post_thumbnail( $post, $img_size ) );
						}
						?>
                    </a>

                    <div class="post__body">
		                <?php if ( isset( $args['post_card_meta']['category'] ) ) { ?>
			                <?php post_card_category(); ?>
		                <?php } ?>

		                <?php post_card_title( true, $isset_itemprop ); ?>

		                <?php if ( isset( $args['post_card_meta']['excerpt'] ) ) { ?>
                            <div class="post__text" itemprop="articleBody"><?php post_card_excerpt( 200 ); ?></div>
		                <?php } ?>

		                <?php post_card_meta( $args['post_card_meta'], true, false, $isset_itemprop ); ?>

		                <?php if ( $isset_itemprop ) { ?>
							<?php echo Helper::html_microdata_publisher() ?>
                            <meta itemscope itemprop="mainEntityOfPage" itemType="https://schema.org/WebPage" itemid="<?php the_permalink() ?>" content="<?php the_title(); ?>">
						<?php } ?>
                    </div>
                </div>
            </div>
			<?php
		}
		wp_reset_postdata();
		?>
    </div>
</div>