<?php
$args          = get_query_var( 'template_args' );
$posts_section = $args['posts'];
if ( ! $posts_section ) {
	return;
}

$block_title      = $args['block_title'] ?? '';
$block_title_type = ( isset( $args['block_title_type'] ) && $args['block_title_type'] ) ? $args['block_title_type'] : 'div';
$block_text       = $args['block_text'] ?? '';
$link_text        = $args['link_text'] ?? '';
$link_url         = $args['link_url'] ?? '';

$key_block = $args['key_block'] ?? '';
?>
<div class="featured featured-<?php echo $key_block; ?>">
	<?php
	if ( $block_title ) {
		printf( '<%1$s class="featured__title title title_content title_divider">' . $block_title . '</%1$s>', $block_title_type );
	}
	if ( $block_text || $link_url ) {
		echo '<div class="featured__header">';
		if ( $block_text ) {
			echo '<div class="featured__text">' . $block_text . '</div>';
		}
		if ( $link_text && $link_url ) {
			echo '<a class="featured__link" href="' . $link_url . '">' . $link_text . '</a>';
		}
		echo '</div>';
	}
	?>

    <div class="row featured__row">
		<?php
		foreach ( $posts_section as $post ) {
			setup_postdata( $post );

			$itemscope = '';
			if ( Helper::is_microdata_active() ) {
				if ( is_archive() ) {
					$itemscope = 'itemscope itemprop="blogPost" itemtype="http://schema.org/BlogPosting"';
				}
				else {
					$itemscope = 'itemscope itemtype="http://schema.org/BlogPosting"';
				}
			}
			?>
            <div class="col featured__col" <?php echo $itemscope; ?>>
                <div class="featured__post featured-post post">
                    <a href="<?php the_permalink(); ?>" class="post__image image-overlay image-overlay_gradient">
						<?php
						$img_size = THEME_SLUG . '_loop_thumbnail_vertical';

						if ( $img_id = get_post_meta( $post->ID, 'thumbnail_archive', 1 ) ) {
							echo str_replace( '<img ', '<img itemprop="image" ', wp_get_attachment_image( $img_id, $img_size ) );
						}
						else {
							echo str_replace( '<img ', '<img itemprop="image" ', get_the_post_thumbnail( $post, $img_size ) );
						}
						?>
                    </a>
                    <div class="post__body">
		                <?php
		                $limit = - 1;
		                if ( ! isset( $args['post_card_meta']['category'] ) ) {
			                $limit = 0;
		                }

		                post_card_category( '', $limit );
		                ?>

		                <?php post_card_title(); ?>

		                <?php post_card_meta( $args['post_card_meta'] ); ?>

		                <?php if ( $itemscope ) { ?>
			                <?php echo Helper::html_microdata_publisher() ?>
                            <meta itemscope itemprop="mainEntityOfPage" itemType="https://schema.org/WebPage" itemid="<?php the_permalink() ?>" content="<?php the_title(); ?>">
		                <?php } ?>
                    </div>
                </div>
            </div>
			<?php
		}
		wp_reset_postdata();
		?>
    </div>
</div>