<?php
$slides = Helper::get_slides_main_banners();
if ( ! $slides ) {
	return;
}
?>
<div class="main-banner">
    <div class="container">
        <div class="slider-buttons">
            <button class="slider-buttons__item slider-buttons__item_prev" type="button">
                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(180deg); -webkit-transform: rotate(180deg); transform: rotate(180deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 42 42">
                    <path fill-rule="evenodd" d="M11 38.32L28.609 21L11 3.68L13.72 1L34 21.01L13.72 41z" fill="white"></path>
                </svg>
            </button>
            <button class="slider-buttons__item slider-buttons__item_next" type="button">
                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 42 42">
                    <path fill-rule="evenodd" d="M11 38.32L28.609 21L11 3.68L13.72 1L34 21.01L13.72 41z" fill="white"></path>
                </svg>
            </button>
        </div>
        <div class="main-banner__slider">
			<?php
			foreach ( $slides as $slide ) {
				$bg_style = '';
				if ( $slide['bg_color'] ) {
					$bg_style = 'style="background-color:' . $slide['bg_color'] . '"';
				}
				?>
                <div class="main-banner__slide">
                    <div class="main-banner-item" <?php echo $bg_style; ?>>
						<?php if ( $slide['discount'] ) { ?>
                            <span class="main-banner-item__discount"><?php echo $slide['discount']; ?></span>
						<?php } ?>
                        <div class="main-banner-item__body">
                            <div class="main-banner-item__title"><?php echo $slide['title']; ?></div>
							<?php if ( $slide['text'] ) { ?>
                                <div class="main-banner-item__text"><?php echo $slide['text']; ?></div>
							<?php } ?>
							<?php if ( $slide['button_link'] || $slide['price'] ) { ?>
                                <div class="main-banner-item__bottom">
									<?php
									if ( $slide['button_link'] ) {
										$target_blank = '';
										if ( $slide['target_blank'] ) {
											$target_blank = 'target="_blank"';
										}
										?>
                                        <a class="btn btn-main" href="<?php echo $slide['button_link']; ?>" <?php echo $target_blank; ?>><?php echo $slide['button_text']; ?></a>
									<?php } ?>
									<?php if ( $slide['price'] ) { ?>
                                        <span class="main-banner-item__price"><?php echo $slide['price']; ?></span>
									<?php } ?>
                                </div>
							<?php } ?>
                        </div>
                        <div class="main-banner-item__img">
							<?php
							if ( $slide['image'] ) {
								echo wp_get_attachment_image( $slide['image'], 'medium' );
							}
							?>
                        </div>
                    </div>
                </div>
			<?php } ?>
        </div>
    </div>
</div>