<?php
$slider_layout = get_post_meta( $post->ID, 'slider_layout', 1 );
if ( 'none' == $slider_layout ) {
	return;
}

$data_arrows         = '';
$autoplay_speed      = get_post_meta( $post->ID, 'slider_autoplay_speed', 1 );
$data_autoplay_speed = 'data-autoplay-speed="' . ( $autoplay_speed * 1000 ) . '"';
if ( in_array( $slider_layout, [ 'columns_two', 'columns_one', 'columns_four', 'banner', 'store' ] ) ) {
	$data_dots   = get_post_meta( $post->ID, 'slider_dots', 1 ) ? 'true' : 'false';
	$data_arrows = get_post_meta( $post->ID, 'slider_arrows', 1 ) ? 'true' : 'false';

	$data_autoplay_speed .= ' data-dots="' . $data_dots . '" data-arrows="' . $data_arrows . '"';
}

if ( in_array( $slider_layout, [ 'columns_two', 'columns_one', 'columns_four' ] ) ) {
	$key_layout = 'columns_two';

	$post_card_meta = [];
	foreach ( choices_visibility_meta( true ) as $key => $val ) {
		$post_card_meta[ $key ] = $key;
	}

	foreach ( choices_visibility_meta( true ) as $key => $val ) {
		if ( ! get_post_meta( $post->ID, 'slider_' . $key_layout . '_visibility_' . $key, 1 ) ) {
			unset( $post_card_meta[ $key ] );
		}
	}

	$post_card_order = get_post_meta( $post->ID, 'slider_' . $key_layout . '_meta', 1 );
	if ( ! isset( $post_card_meta['category'] ) ) {
		foreach ( $post_card_order as $key => $item ) {
			if ( $item == 'category' ) {
				unset( $post_card_order[ $key ] );
			}
		}
	}

	$posts_per_page = intval( get_post_meta( $post->ID, 'slider_columns_two_limit', 1 ) );
	if ( ! $posts_per_page ) {
		$posts_per_page = 8;
	}

	$args = [
		'post_type'        => 'post',
		'posts_per_page'   => $posts_per_page,
		'tax_query'        => [],
		'post__in'         => '',
		'suppress_filters' => false
	];

	$cat_include = get_post_meta( $post->ID, 'slider_columns_two_category', 1 );
	if ( ! $cat_include ) {
		$cat_include = [];
	}
	$posts_include = get_post_meta( $post->ID, 'slider_columns_two_posts', 1 );
	if ( ! $posts_include ) {
		$posts_include = [];
	}

	if ( $posts_include && $posts_include[0] ) {
		$args['post__in']       = $posts_include;
		$args['orderby']        = [ 'menu_order' => 'ASC', 'date' => 'DESC' ];
		$args['posts_per_page'] = count( $posts_include );
	}
	elseif ( $cat_include && $cat_include[0] ) {
		$args['tax_query'][] = [
			'taxonomy' => 'category',
			'terms'    => $cat_include,
		];
	}

	$args            = apply_filters( 'landing_promo_slider_args', $args, $slider_layout, $post->ID );
	$posts_in_slider = get_posts( $args );
	if ( $posts_in_slider ) {
		$template_args = [
			'posts_in_slider'     => $posts_in_slider,
			'post_card_order'     => $post_card_order,
			'post_card_meta'      => $post_card_meta,
			'data_autoplay_speed' => $data_autoplay_speed,
			'data_arrows'         => $data_arrows,
			'content_box'         => get_post_meta( $post->ID, 'content_box', 1 ),
			'is_fullwidth'        => get_post_meta( $post->ID, 'slider_columns_fullwidth', 1 ),
			'color_bg'            => get_post_meta( $post->ID, 'home_slider_carousel_color_bg', 1 ),
			'without_gradient'    => get_post_meta( $post->ID, 'slider_image_without_gradient', 1 ),
		];

		set_query_var( 'template_args', $template_args );
		get_template_part( 'template-parts/home/promo', $slider_layout );
	}
}
elseif ( in_array( $slider_layout, [ 'columns_one_two', 'columns_one_four' ] ) ) {
	$left_key  = 'left_block';
	$right_key = 'right_block';

	$left_post_card_meta  = [];
	$right_post_card_meta = [];
	foreach ( choices_visibility_meta( true ) as $key => $val ) {
		$left_post_card_meta[ $key ]  = $key;
		$right_post_card_meta[ $key ] = $key;
	}

	foreach ( choices_visibility_meta( true ) as $key => $val ) {
		if ( ! get_post_meta( $post->ID, 'slider_' . $left_key . '_visibility_' . $key, 1 ) ) {
			unset( $left_post_card_meta[ $key ] );
		}
	}

	foreach ( choices_visibility_meta( true ) as $key => $val ) {
		if ( ! get_post_meta( $post->ID, 'slider_' . $right_key . '_visibility_' . $key, 1 ) ) {
			unset( $right_post_card_meta[ $key ] );
		}
	}

	$left_post_card_order  = get_post_meta( $post->ID, 'slider_' . $left_key . '_sortable_meta', 1 );
	$right_post_card_order = get_post_meta( $post->ID, 'slider_' . $right_key . '_sortable_meta', 1 );

	if ( ! isset( $left_post_card_meta['category'] ) ) {
		foreach ( $left_post_card_order as $key => $item ) {
			if ( $item == 'category' ) {
				unset( $left_post_card_order[ $key ] );
			}
		}
	}

	if ( ! isset( $right_post_card_meta['category'] ) ) {
		foreach ( $right_post_card_order as $key => $item ) {
			if ( $item == 'category' ) {
				unset( $right_post_card_order[ $key ] );
			}
		}
	}

	/* POSTS in left Column */
	$left_args = [
		'post_type'        => 'post',
		'posts_per_page'   => 1,
		'tax_query'        => [],
		'post__in'         => '',
		'orderby'          => [ 'menu_order' => 'ASC', 'date' => 'DESC' ],
		'suppress_filters' => false
	];

	$cat_include = get_post_meta( $post->ID, 'slider_' . $left_key . '_category', 1 );
	if ( ! $cat_include ) {
		$cat_include = [];
	}
	$posts_include = get_post_meta( $post->ID, 'slider_' . $left_key . '_category_posts', 1 );
	if ( ! $posts_include ) {
		$posts_include = [];
	}

	if ( $posts_include && $posts_include[0] ) {
		$left_args['post__in']       = $posts_include;
		$left_args['posts_per_page'] = count( $posts_include );
	}
	elseif ( $cat_include && $cat_include[0] ) {
		$left_args['tax_query'][] = [
			'taxonomy' => 'category',
			'terms'    => $cat_include,
		];
	}

	$left_args        = apply_filters( 'landing_promo_' . $left_key . '_args', $left_args, $slider_layout, $post->ID );
	$posts_left_block = get_posts( $left_args );

	/* POSTS in right Column */
	$right_args = [
		'post_type'        => 'post',
		'posts_per_page'   => 4,
		'tax_query'        => [],
		'post__in'         => '',
		'orderby'          => [ 'menu_order' => 'ASC', 'date' => 'DESC' ],
		'suppress_filters' => false
	];

	$cat_include = get_post_meta( $post->ID, 'slider_' . $right_key . '_category', 1 );
	if ( ! $cat_include ) {
		$cat_include = [];
	}
	$posts_include = get_post_meta( $post->ID, 'slider_' . $right_key . '_category_posts', 1 );
	if ( ! $posts_include ) {
		$posts_include = [];
	}
	$offset = intval( get_post_meta( $post->ID, 'slider_' . $right_key . '_offset', 1 ) );

	if ( $posts_include && $posts_include[0] ) {
		$right_args['post__in']       = $posts_include;
		$right_args['posts_per_page'] = count( $posts_include );
	}
	elseif ( $cat_include && $cat_include[0] ) {
		$right_args['tax_query'][] = [
			'taxonomy' => 'category',
			'terms'    => $cat_include,
		];

		if ( isset( $left_args['tax_query'] ) && $left_args['tax_query'][0]['terms'] ) {
			foreach ( $cat_include as $cat_id ) {
				if ( in_array( $cat_id, $left_args['tax_query'][0]['terms'] ) ) {
					$right_args['offset'] = 1;
				}
			}
		}
	}

	if ( $offset ) {
		$right_args['offset'] = intval( $offset );
	}

	$right_args        = apply_filters( 'landing_promo_' . $right_key . '_args', $right_args, $slider_layout );
	$posts_right_block = get_posts( $right_args );

	if ( $posts_left_block && $posts_right_block ) {
		$template_args = [
			'left_posts_in_slider' => $posts_left_block,
			'left_post_card_order' => $left_post_card_order,
			'left_post_card_meta'  => $left_post_card_meta,

			'right_posts_in_slider' => $posts_right_block,
			'right_post_card_order' => $right_post_card_order,
			'right_post_card_meta'  => $right_post_card_meta,

			'content_box'      => get_post_meta( $post->ID, 'content_box', 1 ),
			'color_bg'         => get_post_meta( $post->ID, 'home_slider_carousel_color_bg', 1 ),
			'without_gradient' => get_post_meta( $post->ID, 'slider_image_without_gradient', 1 ),
		];

		set_query_var( 'template_args', $template_args );
		get_template_part( 'template-parts/home/promo', $slider_layout );
	}
}
elseif ( in_array( $slider_layout, [ 'banner' ] ) ) {
	$template_args = [
		'slides'              => get_post_meta( $post->ID, 'wescle_slider_banners', 1 ),
		'data_autoplay_speed' => $data_autoplay_speed,
		'data_arrows'         => $data_arrows,
		'content_box'         => get_post_meta( $post->ID, 'content_box', 1 ),
		'h1_on'               => get_post_meta( $post->ID, 'slider_banner_title_is_h1', 1 ),
		'color_bg'            => get_post_meta( $post->ID, 'home_slider_carousel_color_bg', 1 ),
		'is_fullwidth'        => get_post_meta( $post->ID, 'slider_columns_fullwidth', 1 ),
		'without_gradient'    => get_post_meta( $post->ID, 'slider_image_without_gradient', 1 ),
		'slider_effect' => get_post_meta( $post->ID, 'slider_banner_slider_effect', 1 ) === 'fade' ? 'data-fade="true"' : ''
	];
	set_query_var( 'template_args', $template_args );
	get_template_part( 'template-parts/home/promo', 'banner' );
}
elseif ( 'store' == $slider_layout && Helper::is_woocommerce_active() ) {
	$slides_data = [
		'one' => [],
		'two' => [],
	];

	foreach ( [ 'one', 'two' ] as $key ) {
		$slides     = [];
		$size_image = 'medium_large';
		if ( 'one' == $key ) {
			$size_image = 'medium_large';
			if ( ! get_post_meta( $post->ID, 'slider_store_menu_enabled', 1 ) || 'default' == get_post_meta( $post->ID, 'content_box', 1 ) || ! get_post_meta( $post->ID, 'slider_store_two_enabled', 1 ) ) {
				$size_image = 'large';
			};
			if ( ! get_post_meta( $post->ID, 'slider_store_menu_enabled', 1 ) && ! get_post_meta( $post->ID, 'slider_store_two_enabled', 1 ) ) {
				$size_image = 'full';
			}
		}

		if ( 'two' == $key ) {
			if ( ! get_post_meta( $post->ID, 'slider_store_' . $key . '_enabled', 1 ) ) {
				continue;
			}
		}

		$type = get_post_meta( $post->ID, 'slider_store_' . $key . '_type', 1 );
		if ( 'product' == $type ) {
			$button_label = '';
			if ( 'one' == $key ) {
				$button_label = get_post_meta( $post->ID, 'slider_store_' . $key . '_button_label', 1 );
			}

			$limit = get_post_meta( $post->ID, 'slider_store_' . $key . '_limit', 1 );
			if ( $limit < 1 ) {
				$limit = 6;
			}
			$product_args = [
				'post_type'        => 'product',
				'posts_per_page'   => $limit,
				'tax_query'        => [],
				'orderby'          => [ 'menu_order' => 'ASC', 'date' => 'DESC' ],
				'suppress_filters' => false
			];

			$product_cats = get_post_meta( $post->ID, 'slider_store_' . $key . '_category', 1 );
			if ( $product_cats && $product_cats[0] ) {
				$product_args['tax_query'][] = [
					'taxonomy' => 'product_cat',
					'terms'    => $product_cats
				];
			}

			$product_ids = get_post_meta( $post->ID, 'slider_store_' . $key . '_products', 1 );
			if ( $product_ids && $product_ids[0] ) {
				unset( $product_args['tax_query'] );

				$product_args['posts_per_page'] = count( $product_ids );
				$product_args['post__in']       = $product_ids;
			}

			$posts_product = get_posts( apply_filters( 'landing_slider_store_' . $key . '_products_args', $product_args ) );
			foreach ( $posts_product as $post ) {
				setup_postdata( $post );
				global $product;

				$slides[] = [
					'image_html'    => $product->get_image( $size_image ),
					'category_html' => ( 'one' == $key ) ? str_replace( '<a', '<a class="category"', wc_get_product_category_list( $product->get_id(), ' ', '', '' ) ) : '',
					'title'         => get_the_title(),
					'text'          => '',
					'link'          => get_permalink(),
					'price'         => $product->is_type( 'simple' ) ? wc_price( $product->get_price() ) : $product->get_price_html(),
					'price_old'     => $product->is_on_sale() && $product->get_sale_price() ? wc_price( $product->get_regular_price() ) : '',
					'button_label'  => $button_label,
				];
			}
			wp_reset_postdata();
		}
		elseif ( 'custom' == $type ) {
			$custom_items = get_post_meta( $post->ID, 'slider_store_' . $key . '_slides', 1 );
			foreach ( $custom_items as $custom_item ) {
				if ( $img_id = $custom_item['image'] ) {
					$image = wp_get_attachment_image( $img_id, $size_image );
				}
				else {
					$image = wc_placeholder_img( $size_image, [ 'loading' => 'lazy' ] );
				}

				$slides[] = [
					'image_html'       => $image,
					'category_html'    => '',
					'title'            => $custom_item['title'],
					'text'             => $custom_item['text'] ?? '',
					'woo_text_h_align' => $custom_item['woo_text_h_align'] ?? 'left',
					'woo_text_v_align' => $custom_item['woo_text_v_align'] ?? 'bottom',
					'link'             => $custom_item['button_url'],
					'price'            => $custom_item['price'],
					'price_old'        => $custom_item['price_old'],
					'button_label'     => $custom_item['button_label'] ?? '',
					'button_label2'    => $custom_item['button_label2'] ?? '',
					'button_url2'      => $custom_item['button_url2'] ?? '',
					'video'            => $custom_item['video'] ?? '',
					'video_yt'         => $custom_item['video_yt'] ?? '',
					'video_autoplay'   => $custom_item['video_autoplay'] ?? '',
					'video_loop'       => $custom_item['video_loop'] ?? '',
					'video_control'    => $custom_item['video_control'] ?? '',
				];
			}
		}

		$slides_data[ $key ] = $slides;
	}

	$template_args = [
		'slides'              => $slides_data,
		'data_autoplay_speed' => $data_autoplay_speed,
		'data_arrows'         => $data_arrows,
		'menu_enabled'        => get_post_meta( $post->ID, 'slider_store_menu_enabled', 1 ),
		'slider_two_enabled'  => get_post_meta( $post->ID, 'slider_store_two_enabled', 1 ),
		'content_box'         => get_post_meta( $post->ID, 'content_box', 1 ),
		'h1_on'               => get_post_meta( $post->ID, 'slider_banner_title_is_h1', 1 ),
		'color_bg'            => get_post_meta( $post->ID, 'home_slider_carousel_color_bg', 1 ),
		'without_gradient'    => get_post_meta( $post->ID, 'slider_image_without_gradient', 1 ),
		'is_fullwidth'        => get_post_meta( $post->ID, 'slider_store_one_fullwidth', 1 ),
	];
	set_query_var( 'template_args', $template_args );
	get_template_part( 'template-parts/home/promo', $slider_layout );
}
elseif ( in_array( $slider_layout, [ 'animated' ] ) ) {
	$block_attributes = [
		'blockPosition'                  => get_post_meta( $post->ID, 'animated_position_content', 1 ),
		'backgroundImage'                => [],
		'backgroundImageTablet'          => [],
		'backgroundImagePhone'           => [],
		'backgroundImageObjectFit'       => get_post_meta( $post->ID, 'animated_image_bg_fit', 1 ),
		'backgroundImageObjectFitTablet' => get_post_meta( $post->ID, 'animated_image_bg_fit_tablet', 1 ),
		'backgroundImageObjectFitPhone'  => get_post_meta( $post->ID, 'animated_image_bg_fit_mobile', 1 ),
	];
	if ( $img_id = get_post_meta( $post->ID, 'backgroundImage', 1 ) ) {
		$image                                      = wp_get_attachment_image_src( $img_id, 'full' );
		$block_attributes['backgroundImage']['url'] = $image[0];
	}
	if ( $img_id = get_post_meta( $post->ID, 'backgroundImageTablet', 1 ) ) {
		$image                                            = wp_get_attachment_image_src( $img_id, 'large' );
		$block_attributes['backgroundImageTablet']['url'] = $image[0];
	}
	if ( $img_id = get_post_meta( $post->ID, 'backgroundImagePhone', 1 ) ) {
		$image                                           = wp_get_attachment_image_src( $img_id, 'medium_large' );
		$block_attributes['backgroundImagePhone']['url'] = $image[0];
	}

	$template_args = [
		'color_bg'                  => get_post_meta( $post->ID, 'home_slider_carousel_color_bg', 1 ),
		'btn_flare'                 => ( get_post_meta( $post->ID, 'slider_button_type', 1 ) === 'animation' ) ? 'btn-flare' : '',
		'animated_label_text'       => get_post_meta( $post->ID, 'animated_label_text', 1 ),
		'animated_label_href'       => get_post_meta( $post->ID, 'animated_label_href', 1 ),
		'animated_title_1'          => get_post_meta( $post->ID, 'animated_title_1', 1 ),
		'animated_title_type'       => get_post_meta( $post->ID, 'parallax_title_type', 1 ),
		'animated_title_text_items' => get_post_meta( $post->ID, 'animated_title_text_items', 1 ),
		'animated_title_2'          => get_post_meta( $post->ID, 'animated_title_2', 1 ),
		'animated_title_3'          => get_post_meta( $post->ID, 'animated_title_3', 1 ),
		'animated_buttons'          => get_post_meta( $post->ID, 'animated_buttons', 1 ),
		'animated_advantages'       => get_post_meta( $post->ID, 'animated_advantages', 1 ),
		'animated_bg_image_1'       => get_post_meta( $post->ID, 'animated_bg_image_1', 1 ),
		'animated_play_label'       => get_post_meta( $post->ID, 'animated_play_label', 1 ),
		'animated_video_href'       => get_post_meta( $post->ID, 'animated_video_href', 1 ),
		'block_attributes'          => $block_attributes,
	];
	set_query_var( 'template_args', $template_args );
	get_template_part( 'template-parts/home/promo', 'animated' );
}
elseif ( in_array( $slider_layout, [ 'parallax' ] ) ) {
	$block_attributes = [
		'blockPosition'                  => get_post_meta( $post->ID, 'animated_position_content', 1 ),
		'backgroundImage'                => [],
		'backgroundImageTablet'          => [],
		'backgroundImagePhone'           => [],
		'backgroundImageObjectFit'       => get_post_meta( $post->ID, 'animated_image_bg_fit', 1 ),
		'backgroundImageObjectFitTablet' => get_post_meta( $post->ID, 'animated_image_bg_fit_tablet', 1 ),
		'backgroundImageObjectFitPhone'  => get_post_meta( $post->ID, 'animated_image_bg_fit_mobile', 1 ),
	];
	if ( $img_id = get_post_meta( $post->ID, 'backgroundImage', 1 ) ) {
		$image                                      = wp_get_attachment_image_src( $img_id, 'full' );
		$block_attributes['backgroundImage']['url'] = $image[0];
	}
	if ( $img_id = get_post_meta( $post->ID, 'backgroundImageTablet', 1 ) ) {
		$image                                            = wp_get_attachment_image_src( $img_id, 'large' );
		$block_attributes['backgroundImageTablet']['url'] = $image[0];
	}
	if ( $img_id = get_post_meta( $post->ID, 'backgroundImagePhone', 1 ) ) {
		$image                                           = wp_get_attachment_image_src( $img_id, 'medium_large' );
		$block_attributes['backgroundImagePhone']['url'] = $image[0];
	}

	$template_args = [
		'color_bg'                   => get_post_meta( $post->ID, 'home_slider_carousel_color_bg', 1 ),
		'btn_flare'                  => ( get_post_meta( $post->ID, 'slider_button_type', 1 ) === 'animation' ) ? 'btn-flare' : '',
		'parallax_label_text'        => get_post_meta( $post->ID, 'animated_label_text', 1 ),
		'parallax_title_1'           => get_post_meta( $post->ID, 'parallax_title_1', 1 ),
		'parallax_title_type'        => get_post_meta( $post->ID, 'parallax_title_type', 1 ),
		'parallax_text_items'        => get_post_meta( $post->ID, 'parallax_text_items', 1 ),
		'parallax_button_label'      => get_post_meta( $post->ID, 'parallax_button_label', 1 ),
		'parallax_button_url'        => get_post_meta( $post->ID, 'parallax_button_url', 1 ),
		'parallax_text_button'       => get_post_meta( $post->ID, 'parallax_text_button', 1 ),
		'parallax_text_after_button' => get_post_meta( $post->ID, 'parallax_text_after_button', 1 ),
		'parallax_bg_image_1'        => get_post_meta( $post->ID, 'parallax_bg_image_1', 1 ),
		'parallax_bg_image_2'        => get_post_meta( $post->ID, 'parallax_bg_image_2', 1 ),
		'block_attributes'           => $block_attributes,
	];
	set_query_var( 'template_args', $template_args );
	get_template_part( 'template-parts/home/promo', 'parallax' );
}
else {
	get_template_part( 'template-parts/home/promo', $slider_layout );
}