<?php
foreach ( $home_blocks_posts as $key_block => $block ) {

	$block_on = isset( $block['block_on'] ) ? $block['block_on'] : '';
	if ( $block_on === false ) {
		continue;
	}

	$code_advt = $block['block_advt'];
	if ( $code_advt ) {
		set_query_var( 'template_args', [ 'code' => $code_advt, 'container' => false ] );
		get_template_part( 'template-parts/section/advt', '' );
	}

	$block_title       = str_replace( '%', '%%', $block['block_title'] );
	$block_title_type  = $block['block_title_type'];
	$post_card_type    = $block['block_post_card_type'] ? $block['block_post_card_type'] : 'default';
	$post_card_opacity = $block['block_post_card_opacity'] ?? 100;
	$post_card_columns = $block['block_post_card_columns'] ?? 3;
	$block_type        = 'recommended';

	if ( $post_card_type == 'vertical' ) {
		$block_type = 'featured';
	}
	elseif ( $post_card_type == 'horizontal' ) {
		$block_type = 'latest';
	}
	elseif ( $post_card_type == 'horizontal2' ) {
		$block_type = 'latest2';
	}

	$post_card_meta = [];
	foreach ( $choices_visibility_meta as $key => $val ) {
		$post_card_meta[ $key ] = $key;
	}

	foreach ( $choices_visibility_meta as $key => $val ) {
		if ( isset( $block[ 'visibility_' . $key ] ) && ! $block[ 'visibility_' . $key ] ) {
			unset( $post_card_meta[ $key ] );
		}
	}

	$posts_per_page = absint( $block['block_limit'] );
	if ( $posts_per_page > 40 ) {
		$posts_per_page = 0;
	}

	if ( $posts_per_page == 0 ) {
		$posts_per_page = 3;
	}

	$args = [
		'post_type'        => 'post',
		'posts_per_page'   => $posts_per_page,
		'tax_query'        => [],
		'post__in'         => '',
		'suppress_filters' => false
	];

	$posts_orderby = $block['block_posts_orderby'];
	if ( $posts_orderby == 'views' ) {
		if ( Helper::is_plugin_active( 'post-views-counter/post-views-counter.php' ) ) {
			$args['suppress_filters'] = false;
			$args['orderby']          = 'post_views';
			$args['fields']           = '';
			$args['meta_key']         = '';
		}
		else {
			$args['orderby']  = 'meta_value_num';
			$args['order']    = 'DESC';
			$args['meta_key'] = 'views';
		}
	}
	else {
		$args['orderby'] = $posts_orderby;
	}

	$cat_include   = $block['block_category'];
	$posts_include = $block['block_posts'];

	if ( $posts_include && $posts_include[0] ) {
		$args['post__in']       = $posts_include;
		$args['posts_per_page'] = count( $posts_include );
	}
	elseif ( $cat_include && $cat_include[0] ) {
		$args['tax_query'][] = [
			'taxonomy' => 'category',
			'terms'    => $cat_include,
		];
	}

	if ( $code_advt && ! $cat_include && ! $posts_include ) {
		continue;
	}

	$args = apply_filters( 'block_posts_args', $args, $block );

	$posts_section = get_posts( $args );
	if ( $posts_section ) {
		$data = [
			'posts'             => $posts_section,
			'block_title'       => $block_title,
			'block_title_type'  => $block_title_type,
			'post_card_type'    => $post_card_type,
			'post_card_opacity' => $post_card_opacity,
			'post_card_columns' => $post_card_columns,
			'key_block'         => $key_block,
			'post_card_meta'    => $post_card_meta,
			'posts_per_page'    => $posts_per_page,
		];

		set_query_var( 'template_args', $data );
		get_template_part( 'template-parts/section/section', $block_type );
	}
}