<?php
global $post;

$block_title = get_theme_mod( 'share_social_title', Helper::get_default_theme_data( 'share_social_title' ) );

$custom_code = get_theme_mod( 'share_social_custom' );
if ( ! $custom_code ) {
	$url     = urlencode( get_permalink() );
	$title   = urlencode( get_the_title() );
	$img_url = '';
	if ( get_post_thumbnail_id() ) {
		$img_url = urlencode( wp_get_attachment_url( get_post_thumbnail_id() ) );
	}

	$social_share = Helper::choices_share_social();
	$hide_share   = get_theme_mod( 'share_social_hide', [] );
	if ( $hide_share ) {
		foreach ( $social_share as $key => $val ) {
			if ( in_array( $key, $hide_share ) ) {
				unset( $social_share[ $key ] );
			}
		}
	}

	if ( empty( $social_share ) ) {
		return;
	}
}
?>
<div class="section-post__share share">
	<?php if ( $block_title ) { ?>
        <div class="share__title"><span><?php echo $block_title; ?></span>
            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(-90deg); -webkit-transform: rotate(-90deg); transform: rotate(-90deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 32 32">
                <g fill="none" stroke="#626262" stroke-linecap="round" stroke-linejoin="round" stroke-width="4">
                    <path d="M30 12L16 24L2 12"></path>
                </g>
            </svg>
        </div>
	<?php } ?>
	<?php
	if ( $custom_code ) {
		echo do_shortcode( $custom_code );
	}
	else {
		?>
        <ul class="share__list">
			<?php if ( isset( $social_share['vk'] ) ) { ?>
                <li><span title="<?php echo $social_share['vk']; ?>" data-href="//vk.com/share.php?url=<?php echo $url; ?>" onclick="window.open(this.getAttribute('data-href'),'','width=500,height=500,top=300px,left=300px'); return false;">
                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveAspectRatio="xMidYMid meet" viewBox="0 0 20 20">
                    <path d="M10 .4C4.698.4.4 4.698.4 10s4.298 9.6 9.6 9.6s9.6-4.298 9.6-9.6S15.302.4 10 .4zm3.692 10.831s.849.838 1.058 1.227c.006.008.009.016.011.02c.085.143.105.254.063.337c-.07.138-.31.206-.392.212h-1.5c-.104 0-.322-.027-.586-.209c-.203-.142-.403-.375-.598-.602c-.291-.338-.543-.63-.797-.63a.305.305 0 0 0-.095.015c-.192.062-.438.336-.438 1.066c0 .228-.18.359-.307.359h-.687c-.234 0-1.453-.082-2.533-1.221c-1.322-1.395-2.512-4.193-2.522-4.219c-.075-.181.08-.278.249-.278h1.515c.202 0 .268.123.314.232c.054.127.252.632.577 1.2c.527.926.85 1.302 1.109 1.302a.3.3 0 0 0 .139-.036c.338-.188.275-1.393.26-1.643c0-.047-.001-.539-.174-.775c-.124-.171-.335-.236-.463-.26a.55.55 0 0 1 .199-.169c.232-.116.65-.133 1.065-.133h.231c.45.006.566.035.729.076c.33.079.337.292.308 1.021c-.009.207-.018.441-.018.717c0 .06-.003.124-.003.192c-.01.371-.022.792.24.965a.216.216 0 0 0 .114.033c.091 0 .365 0 1.107-1.273a9.718 9.718 0 0 0 .595-1.274c.015-.026.059-.106.111-.137a.266.266 0 0 1 .124-.029h1.781c.194 0 .327.029.352.104c.044.119-.008.482-.821 1.583l-.363.479c-.737.966-.737 1.015.046 1.748z"
                          fill="#626262"></path>
                </svg>
                </span>
                </li>
			<?php } ?>
			<?php if ( isset( $social_share['ok'] ) ) { ?>
                <li><span title="<?php echo $social_share['ok']; ?>" data-href="https://connect.ok.ru/offer?url=<?php echo $url; ?>" onclick="window.open(this.getAttribute('data-href'),'','width=500,height=500,top=300px,left=300px'); return false;">
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512.5 512.5"> <path d="M256.2 277.3c76.6 0 138.7-62.1 138.7-138.7S332.8 0 256.2 0 117.6 62.1 117.6 138.7C117.7 215.2 179.7 277.2 256.2 277.3zM256.2 64c41.2 0 74.7 33.4 74.7 74.7s-33.4 74.7-74.7 74.7 -74.7-33.4-74.7-74.7S215 64 256.2 64z" fill="#626262"></path> <path
                            d="M392.1 343c15.1-9.9 24.2-26.8 24.2-44.8 0.2-15-8.2-28.7-21.7-35.3 -13.8-6.9-30.4-5.3-42.7 4 -57 41.5-134.3 41.5-191.3 0 -12.3-9.3-28.8-10.9-42.7-4 -13.4 6.6-21.9 20.3-21.7 35.3 0 18 9.1 34.9 24.2 44.8 19.3 12.9 40.4 22.9 62.5 29.9 3.8 1.2 7.6 2.2 11.6 3.2l-64.5 63c-16.9 16.4-17.3 43.4-0.9 60.3 16.4 16.9 43.4 17.3 60.3 0.9 0.4-0.3 0.7-0.7 1-1l65.7-68 65.8 68.1c16.4 16.9 43.4 17.4 60.3 1 16.9-16.4 17.4-43.4 1-60.3 -0.3-0.4-0.7-0.7-1-1l-64.4-63c4-1 7.9-2.1 11.7-3.3C351.7 365.9 372.8 355.9 392.1 343z"
                            fill="#626262"></path>
                </svg>
                </span>
                </li>
			<?php } ?>
			<?php if ( isset( $social_share['fb'] ) ) { ?>
                <li><span title="<?php echo $social_share['fb']; ?>" data-href="//www.facebook.com/sharer.php?u=<?php echo $url; ?>" data-title="<?php echo $title; ?>" onclick="window.open(this.getAttribute('data-href'),'','width=500,height=500,top=300px,left=300px'); return false;">
                  <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 24 24">
                    <path d="M13.397 20.997v-8.196h2.765l.411-3.209h-3.176V7.548c0-.926.258-1.56 1.587-1.56h1.684V3.127A22.336 22.336 0 0 0 14.201 3c-2.444 0-4.122 1.492-4.122 4.231v2.355H7.332v3.209h2.753v8.202h3.312z" fill="#626262"></path>
                  </svg>
                </span>
                </li>
			<?php } ?>
			<?php if ( isset( $social_share['twitter'] ) ) { ?>
                <li><span title="<?php echo $social_share['twitter']; ?>" data-href="//twitter.com/share?url=<?php echo $title . ' --&gt; ' . $url; ?>" onclick="window.open(this.getAttribute('data-href'),'','width=500,height=500,top=300px,left=300px'); return false;">
                  <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 1024 1024">
                    <path d="M928 254.3c-30.6 13.2-63.9 22.7-98.2 26.4a170.1 170.1 0 0 0 75-94a336.64 336.64 0 0 1-108.2 41.2A170.1 170.1 0 0 0 672 174c-94.5 0-170.5 76.6-170.5 170.6c0 13.2 1.6 26.4 4.2 39.1c-141.5-7.4-267.7-75-351.6-178.5a169.32 169.32 0 0 0-23.2 86.1c0 59.2 30.1 111.4 76 142.1a172 172 0 0 1-77.1-21.7v2.1c0 82.9 58.6 151.6 136.7 167.4a180.6 180.6 0 0 1-44.9 5.8c-11.1 0-21.6-1.1-32.2-2.6C211 652 273.9 701.1 348.8 702.7c-58.6 45.9-132 72.9-211.7 72.9c-14.3 0-27.5-.5-41.2-2.1C171.5 822 261.2 850 357.8 850C671.4 850 843 590.2 843 364.7c0-7.4 0-14.8-.5-22.2c33.2-24.3 62.3-54.4 85.5-88.2z"
                          fill="#626262"></path>
                  </svg>
                </span>
                </li>
			<?php } ?>
			<?php if ( isset( $social_share['pinterest'] ) ) { ?>
				<?php if ( $img_url ) { ?>
                    <li><span title="<?php echo $social_share['pinterest']; ?>" data-href="//pinterest.com/pin/create/button/?url=<?php echo $url; ?>&amp;media=<?php echo $img_url; ?>&amp;description=<?php echo $title; ?>" onclick="window.open(this.getAttribute('data-href'),'','width=500,height=500,top=300px,left=300px'); return false;">
                  <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 24 24">
                    <path d="M5.077 9.457c0-.778.136-1.513.404-2.199a5.63 5.63 0 0 1 1.121-1.802a7.614 7.614 0 0 1 1.644-1.329a7.513 7.513 0 0 1 2.002-.844a8.57 8.57 0 0 1 2.185-.281c1.139 0 2.199.241 3.182.721a6.021 6.021 0 0 1 2.391 2.094c.614.915.919 1.95.919 3.104c0 .692-.068 1.369-.207 2.031a8.28 8.28 0 0 1-.646 1.913a6.605 6.605 0 0 1-1.082 1.617a4.723 4.723 0 0 1-1.568 1.114a4.962 4.962 0 0 1-2.045.417c-.489 0-.977-.115-1.459-.346c-.482-.23-.828-.546-1.036-.951c-.073.281-.173.687-.306 1.218c-.128.53-.214.872-.252 1.027c-.04.154-.114.411-.222.767a5.183 5.183 0 0 1-.281.769l-.344.674a7.98 7.98 0 0 1-.498.838c-.181.262-.405.575-.672.935l-.149.053l-.099-.108c-.107-1.133-.162-1.811-.162-2.035c0-.663.079-1.407.235-2.233c.153-.825.395-1.862.72-3.109c.325-1.246.511-1.979.561-2.196c-.229-.467-.345-1.077-.345-1.827c0-.599.187-1.16.562-1.688c.376-.526.851-.789 1.427-.789c.441 0 .783.146 1.028.439c.246.292.366.66.366 1.109c0 .476-.158 1.165-.476 2.066c-.318.902-.476 1.575-.476 2.022c0 .453.162.832.486 1.129a1.68 1.68 0 0 0 1.179.449c.396 0 .763-.09 1.104-.271a2.46 2.46 0 0 0 .849-.733a6.123 6.123 0 0 0 1.017-2.225c.096-.422.17-.823.216-1.2c.049-.379.07-.737.07-1.077c0-1.247-.396-2.219-1.183-2.915c-.791-.696-1.821-1.042-3.088-1.042c-1.441 0-2.646.466-3.611 1.401c-.966.932-1.452 2.117-1.452 3.554c0 .317.048.623.139.919c.089.295.186.53.291.704c.104.171.202.338.291.492c.09.154.137.264.137.33c0 .202-.053.465-.16.79c-.111.325-.242.487-.4.487c-.015 0-.077-.011-.185-.034a2.21 2.21 0 0 1-.979-.605a3.17 3.17 0 0 1-.659-1.022a6.986 6.986 0 0 1-.352-1.169a4.884 4.884 0 0 1-.132-1.153z"
                          fill="#626262"></path>
                  </svg>
                </span>
                    </li>
				<?php } ?>
			<?php } ?>
			<?php if ( isset( $social_share['telegram'] ) ) { ?>
                <li><span title="<?php echo $social_share['telegram']; ?>" data-href="//telegram.me/share/url?url=<?php echo $url; ?>&text=<?php echo $title; ?>" onclick="window.open(this.getAttribute('data-href'),'','width=500,height=500,top=300px,left=300px'); return false;">
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveAspectRatio="xMidYMid meet" viewBox="0 0 32 32">
                        <path d="M16 .5C7.437.5.5 7.438.5 16S7.438 31.5 16 31.5c8.563 0 15.5-6.938 15.5-15.5S24.562.5 16 .5zm7.613 10.619l-2.544 11.988c-.188.85-.694 1.056-1.4.656l-3.875-2.856l-1.869 1.8c-.206.206-.381.381-.781.381l.275-3.944l7.181-6.488c.313-.275-.069-.431-.482-.156l-8.875 5.587l-3.825-1.194c-.831-.262-.85-.831.175-1.231l14.944-5.763c.694-.25 1.3.169 1.075 1.219z" fill="#626262"></path>
                    </svg>
                </span>
                </li>
			<?php } ?>
			<?php if ( isset( $social_share['linkedin'] ) ) { ?>
                <li><span title="<?php echo $social_share['linkedin']; ?>" data-href="https://www.linkedin.com/shareArticle?mini=true&amp;url=<?php echo $url; ?>&amp;title=<?php echo $title ?>" onclick="window.open(this.getAttribute('data-href'),'','width=500,height=500,top=300px,left=300px'); return false;">
                  <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 32 32">
                    <path d="M8.643 4A2.641 2.641 0 0 0 6 6.64C6 8.1 7.183 9.31 8.64 9.31c1.459 0 2.643-1.21 2.643-2.668A2.64 2.64 0 0 0 8.643 4zm12.892 7c-2.219 0-3.488 1.16-4.098 2.314h-.064v-2.003H13V26h4.557v-7.271c0-1.916.144-3.768 2.515-3.768c2.337 0 2.371 2.185 2.371 3.889V26H27v-8.068C27 13.984 26.151 11 21.535 11zm-15.172.31V26h4.56V11.31h-4.56z" fill="#626262"></path>
                  </svg>
                </span>
                </li>
			<?php } ?>
			<?php if ( isset( $social_share['whatsapp'] ) ) { ?>
                <li><span title="<?php echo $social_share['whatsapp']; ?>" data-href="https://api.whatsapp.com/send/?phone&amp;text=<?php echo $url; ?>&amp;app_absent=0" onclick="window.open(this.getAttribute('data-href'),'','width=500,height=500,top=300px,left=300px'); return false;">
                  <svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 512 512" style="enable-background:new 0 0 512 512;" xml:space="preserve">
                      <path fill="#626262" d="M256.064,0h-0.128l0,0C114.784,0,0,114.816,0,256c0,56,18.048,107.904,48.736,150.048l-31.904,95.104 l98.4-31.456C155.712,496.512,204,512,256.064,512C397.216,512,512,397.152,512,256S397.216,0,256.064,0z"></path>
                      <path style="fill:#FAFAFA;"
                            d="M405.024,361.504c-6.176,17.44-30.688,31.904-50.24,36.128c-13.376,2.848-30.848,5.12-89.664-19.264 C189.888,347.2,141.44,270.752,137.664,265.792c-3.616-4.96-30.4-40.48-30.4-77.216s18.656-54.624,26.176-62.304 c6.176-6.304,16.384-9.184,26.176-9.184c3.168,0,6.016,0.16,8.576,0.288c7.52,0.32,11.296,0.768,16.256,12.64 c6.176,14.88,21.216,51.616,23.008,55.392c1.824,3.776,3.648,8.896,1.088,13.856c-2.4,5.12-4.512,7.392-8.288,11.744 c-3.776,4.352-7.36,7.68-11.136,12.352c-3.456,4.064-7.36,8.416-3.008,15.936c4.352,7.36,19.392,31.904,41.536,51.616 c28.576,25.44,51.744,33.568,60.032,37.024c6.176,2.56,13.536,1.952,18.048-2.848c5.728-6.176,12.8-16.416,20-26.496 c5.12-7.232,11.584-8.128,18.368-5.568c6.912,2.4,43.488,20.48,51.008,24.224c7.52,3.776,12.48,5.568,14.304,8.736 C411.2,329.152,411.2,344.032,405.024,361.504z"></path> <g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g><g></g>
                  </svg>
                </span>
                </li>
			<?php } ?>
        </ul>
		<?php
	}
	?>
</div>