<?php
global $post;

if ( Helper::is_woocommerce_shortcode_page() ) {
	return;
}

if ( $post->post_type == 'service' ) {
	$per_page_related = intval( get_theme_mod( 'service_block_related', 3 ) );
}
elseif ( $post->post_type == 'portfolio_wescle' ) {
	$per_page_related = intval( get_theme_mod( 'portfolio_wescle_block_related', 3 ) );
}
elseif ( $post->post_type == 'event_wescle' ) {
	$per_page_related = intval( get_theme_mod( 'event_wescle_block_related', 3 ) );
}
elseif ( $post->post_type == 'product_wescle' ) {
	$per_page_related = intval( get_theme_mod( 'product_wescle_block_related', 3 ) );
}
elseif ( $post->post_type == 'video_wescle' ) {
	$per_page_related = intval( get_theme_mod( 'video_wescle_block_related', 3 ) );
}
elseif ( $post->post_type == 'team_wescle' ) {
	$per_page_related = intval( get_theme_mod( 'team_wescle_block_related', 3 ) );
}
elseif ( $post->post_type == 'course_wescle' ) {
	$per_page_related = intval( get_theme_mod( 'course_wescle_block_related', 3 ) );
}
elseif ( $post->post_type == 'catalog_item' ) {
	$per_page_related = intval( get_theme_mod( 'catalog_item_block_related', 2 ) );
}
else {
	$per_page_related = intval( get_theme_mod( 'post_block_related', 3 ) );
}

if ( $per_page_related < 0 ) {
	$per_page_related = 0;
}
if ( $per_page_related > 20 ) {
	$per_page_related = 20;
}

if ( ! $per_page_related ) {
	return;
}

$posts_related_args = array(
	'post_type'        => $post->post_type,
	'category__in'     => ( $post->post_type == 'post' ) ? wp_get_post_categories( $post->ID ) : '',
	'posts_per_page'   => $per_page_related,
	'post__not_in'     => array( $post->ID ),
	'orderby'          => 'rand',
	'suppress_filters' => false
);
$posts_related_args = apply_filters( 'posts_related_args', $posts_related_args );
$posts_related      = get_posts( $posts_related_args );
if ( $posts_related ) {
	if ( $post->post_type == 'service' ) {
		$title_block = get_theme_mod( 'service_block_related_title', esc_html__( 'Похожие услуги', 'wescle' ) );
	}
	elseif ( $post->post_type == 'portfolio_wescle' ) {
		$title_block = get_theme_mod( 'portfolio_wescle_block_related_title', esc_html__( 'Похожие работы', 'wescle' ) );
	}
	elseif ( $post->post_type == 'event_wescle' ) {
		$title_block = get_theme_mod( 'event_wescle_block_related_title', esc_html__( 'Похожие мероприятия', 'wescle' ) );
	}
	elseif ( $post->post_type == 'product_wescle' ) {
		$title_block = get_theme_mod( 'product_wescle_block_related_title', esc_html__( 'Похожие товары', 'wescle' ) );
	}
	elseif ( $post->post_type == 'video_wescle' ) {
		$title_block = get_theme_mod( 'video_wescle_block_related_title', esc_html__( 'Похожие видео', 'wescle' ) );
	}
	elseif ( $post->post_type == 'team_wescle' ) {
		$title_block = get_theme_mod( 'team_wescle_block_related_title', '' );
	}
	elseif ( $post->post_type == 'course_wescle' ) {
		$title_block = get_theme_mod( 'course_wescle_block_related_title', Helper::get_default_theme_data( 'course_block_related_title' ) );
	}
	elseif ( $post->post_type == 'catalog_item' ) {
		$title_block = get_theme_mod( 'catalog_item_block_related_title', '' );
	}
	else {
		$title_block = get_theme_mod( 'post_block_related_title', esc_html__( 'Похожие записи', 'wescle' ) );
	}

	$title_block = apply_filters( 'wescle_related_title', $title_block );

	if ( in_array( $post->post_type, [ 'product_wescle', 'video_wescle', 'course_wescle', 'catalog_item' ] ) ) {
		echo '<div class="latest related-articles" id="related">';
		if ( $title_block ) {
			echo '<div class="latest__title title title_content title_divider">' . $title_block . '</div>';
		}

		if ( 'product_wescle' === $post->post_type ) {
			$item_type     = 'product';
			$div_class     = 'products-section__grid';
			$div_col_open  = '';
			$div_col_close = '';
		}
		elseif ( 'catalog_item' === $post->post_type ) {
			$item_type     = 'catalog';
			$div_class     = 'wescle-transport__grid';
			$div_col_open  = '';
			$div_col_close = '';
		}
		elseif ( 'video_wescle' === $post->post_type ) {
			$item_type     = 'video';
			$div_class     = 'video-section__row';
			$div_col_open  = '<div class="video-section__col">';
			$div_col_close = '</div>';
		}
		elseif ( 'course_wescle' === $post->post_type ) {
			$item_type     = 'course';
			$div_class     = 'post-course__row';
			$div_col_open  = '';
			$div_col_close = '';
		}

		if ( 'catalog_item' === $post->post_type ) {
			echo '<div class="_tabs-block" data-number="0">';
		}
		echo '<div class="' . $div_class . '">';

		foreach ( $posts_related as $post ) {
			setup_postdata( $post );

			echo $div_col_open;
			get_template_part( 'template-parts/content/' . $item_type, 'item' );
			echo $div_col_close;
		}
		wp_reset_postdata();

		if ( 'catalog_item' === $post->post_type ) {
			echo '</div>';
		}
		echo '</div>';
		echo '</div>';
	}
	else {
		$post_card_meta = Helper::get_post_card_meta();

		$template_args = [
			'posts'          => $posts_related,
			'block_title'    => $title_block,
			'block_class'    => 'related-articles',
			'post_card_meta' => $post_card_meta,
			'is_itemprop'    => false,
		];

		set_query_var( 'template_args', $template_args );
		get_template_part( 'template-parts/section/section', 'latest' );
	}
}